package com.objectriver.microservices.things;

import com.objectriver.microservices.things.abstracts.RestThing;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;

import java.util.*;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */


public abstract class RestDictionary<T> extends RestObject {
    protected Map<String,T> dictionary = new HashMap();
    protected RestThingType ofType;
    public RestDictionary(String identifier) {
        super(identifier);
        super.setRestThingType(RestThingType.Dictionary);
        super.concreteClass=true;
    }
    public RestThingType getOfType() {
        return ofType;
    }
    public void setOfType(RestThingType ofType) {
        this.ofType = ofType;
    }

    public Iterator<String> iteratorDict() {
        return dictionary.keySet().iterator();
    }
    public void putDict(String key, T value) {
        dictionary.put(key,value);
    }
    public T getDict(String key) {
        return dictionary.get(key);
    }
    public boolean isDictEmpty() {
        return dictionary.keySet().isEmpty();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor)visitor;
        descend &= v.beginVisitOfRestDictionary(this);
        if(descend) {
            Iterator<T> iter = dictionary.values().iterator();
            while(iter.hasNext()) {
                T item = iter.next();
                switch(ofType) {
                    case Object:
                    case List: {
                        RestThing thing = (RestThing)item;
                        thing.visit(v);
                        break;
                    }
                default:
                }
            }
        }
        v.endVisitOfRestDictionary(this);
        return descend;
    }
}
