package com.objectriver.microservices.things.abstracts;

import com.objectriver.microservices.things.RestMember;
import com.objectriver.microservices.things.RestThingType;
import com.objectriver.microservices.things.Visitor;
import com.objectriver.microservices.things.json.abstracts.RestThingVisitor;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

import java.util.*;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public abstract class RestScope extends RestThing { // implements Map<String,Pair<RestThingType,Object>> {
    public RestScope(String identifier, RestThingType type, RestThing parent) {
        super(identifier,type,parent);
    }
    public RestScope(String identifier, RestThingType type) {
        super(identifier,type);
    }

    protected Map<String,RestMember> memberMap = new HashMap();
    protected ArrayList<String> memberList = new ArrayList();

    public Iterator<String> iterator() {
        return memberList.iterator();
    }
    public abstract List<RestMember> getMembers();
    public boolean acceptVisit(Visitor visitor, boolean descend) {
        RestThingVisitor v = (RestThingVisitor)visitor;
        descend = v.beginVisitOfRestScope(this);
        if(descend) {
            List<RestMember> members = getMembers();
            for(RestMember member : members) {
                descend &= member.acceptVisit(visitor, descend);
            }
        }
        v.endVisitOfRestScope(this);
        return descend;
    }
    /**--------- Map implementation -------------*/
    protected int size() {
        return memberMap.size();
    }
    public boolean isEmpty() {
        return memberMap.isEmpty();
    }
    protected boolean containsKey(Object key) {
        return memberMap.containsKey(((String)key));
    }
    protected boolean containsValue(Object value) {
        throw new NotImplementedException();
    }
    public RestMember get(Object key) {
        return memberMap.get(((String)key));
    }
    public RestMember get(String key) {
        return memberMap.get(key);
    }

    public Object getValue(String key) {
        if(memberMap.keySet().contains(key)) {
            RestMember member = memberMap.get(key);
            if(member!=null) {
                return member.getValue();
            }
        }
        return null;
    }

    public RestScope put(String key, RestMember value) {
        if(!memberList.contains(key))
            memberList.add(key);
        if(value==null) {
            value = new RestMember(key,RestThingType.Null,null,this);
        }
        memberMap.put(key,value);
        return this;
    }
    public RestScope put(String key, Object value) {

        RestMember member = new RestMember(key,RestThingType.valueOf(value),value,this);
        put(key,member);
        return this;
    }
    protected RestScope put(String key, RestThingType type, Object value) {
        RestMember member = new RestMember(key,(value==null)? type : RestThingType.valueOf(value),value,this);
        put(key,member);
        return this;
    }

    public RestMember remove(Object key) {
        String keystr = ((String)key);
        memberList.remove(keystr);
        return memberMap.remove(keystr);
    }

    public void removeAll(List<String> keys) {
        for(String key : keys) {
            this.remove(key);
        }
    }

    protected void clear() {
        memberList.clear();
        memberMap.clear();
    }
    protected Set<String> keySet() {
        return memberMap.keySet();
    }
}
