package com.objectriver.microservices.things.abstracts;

import com.objectriver.microservices.things.RestThingType;
import com.objectriver.microservices.things.Thing;
import com.objectriver.microservices.things.Visit;
import com.objectriver.microservices.things.Visitor;

import java.util.HashMap;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public abstract class RestThing implements Thing,Visit,Cloneable {
    public String identifier;
    public RestThing(String identifier, RestThingType type, RestThing parent) {
        this.identifier = identifier;
        this.type = type;
        this.parent = parent;
    }
    public RestThing(String identifier, RestThingType type) {
        this.identifier = identifier;
        this.type = type;
    }

    @Override
    public String getIdentifier() {
        return identifier;
    }
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected RestThingType type;
    public RestThingType getRestThingType() {
        return type;
    }
    public void setRestThingType(RestThingType type) {
        this.type = type;
    }
    /** Visit */
    protected abstract boolean acceptVisit(Visitor v, boolean b);
    public final void visit(Visitor visitor) {
        acceptVisit(visitor, true);
    }
    /** Parent property definted for upward navigation */
    protected RestThing parent;
    public RestThing getParent(Class clazz) {
        RestThing thing = parent;
        while(thing!=null && !clazz.isInstance(thing))
            thing = thing.getParent();
        return thing;
    }
    public RestThing getParent() {
        return parent;
    }
    public void setParent(RestThing p) {
        parent=p;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String clazzName = this.getClass().getName();
        clazzName = clazzName.substring(clazzName.lastIndexOf('.')+1);
        if(this.parent!=null) {
            buff.append(parent.toString()).append('.');
        }
        buff.append(clazzName).append('=');
        buff.append((identifier==null)?"null":identifier.toString());
        return buff.toString();
    }

    /*-------------------------------------------------
     * Implement PostIt interface. Kind of a Decorator pattern.
     *-----------------------------------------------*/
    private HashMap postIts = null;
    public void postIt(String key, Object o) {
        if(this.postIts==null) {
            this.postIts = new HashMap();
        }
        if(isPosted(key))
            postItDiscard(key);
        postIts.put(key,o);
    }
    public Object postItRead(String key) {
        if(postIts==null) return null;
        return postIts.get(key);
    }
    public void postItDiscard(String key) {
        if(postIts==null) return;
        postIts.remove(key);
    }
    public boolean isPosted(String key) {
        if(postIts==null) return false;
        return postIts.containsKey(key);
    }

}
