package com.objectriver.microservices.things.json.abstracts;

import com.objectriver.microservices.things.*;
import com.objectriver.microservices.things.abstracts.RestScope;
import com.objectriver.microservices.things.abstracts.RestThing;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public abstract class RestThingVisitor implements Visitor {
    /**
     * Rest Generic Objects
     */
    public boolean beginVisitOfRestDocument(RestDocument value) {return true;}
    public void endVisitOfRestDocument(RestDocument value) {}

    public boolean beginVisitOfRestObject(RestObject value) {return true;}
    public void endVisitOfRestObject(RestObject value) {}

    public boolean beginVisitOfRestScope(RestScope value) {return true;}
    public void endVisitOfRestScope(RestScope value) {}

    public boolean beginVisitOfRestList(RestList value)  {return true;}
    public void endVisitOfRestList(RestList value) {}

    public boolean beginVisitOfRestDictionary(RestDictionary value)  {return true;}
    public void endVisitOfRestDictionary(RestDictionary value) {}

    public boolean beginVisitOfRestMember(RestMember value)  {return true;}
    public void endVisitOfRestMember(RestMember value) {}

    public boolean beginVisitOfRestThing(RestThing value)  {return true;}
    public void endVisitOfRestThing(RestThing value) {}
}
