package com.objectriver.microservices.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class ISO8601DateTimeSingleton {
    static private DateFormat timestampformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    static private DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
    static private ISO8601DateTimeSingleton instance = new ISO8601DateTimeSingleton();
    private ISO8601DateTimeSingleton() {};
    public static ISO8601DateTimeSingleton getInstance() {
        return instance;
    }
    public String getIsoDate(Date date) {
        String isodate;
        synchronized (dateformat) {
            isodate = dateformat.format(date);
        }
        return isodate;
    }
    public String getIsoDate(Timestamp ts) {
        String isots;
        synchronized (timestampformat) {
            isots = timestampformat.format(ts);
        }
        return isots;
    }
    // FastApi Timestamps 2023-01-13T13:27:13.306000+00:00
    private static Pattern fastApiTimestamp1 = Pattern.compile("(\\.[1234567890]{6})");
    private static Pattern fastApiTimestamp2 = Pattern.compile("([+][1234567890]{2}:[1234567890]{2})");
    public <T extends java.util.Date> T parseDateTime(T datetype, String isodate) throws java.text.ParseException {
        java.util.Date utilDate;
        /**
         * Find bogus FastApi timestamp, and remove 6 digit ms. 2016-05-24T15:54:14.876123
         * remove timezone offset +00:00
         */
        Matcher matcher = fastApiTimestamp1.matcher(isodate);
        if(matcher.find()) {
            String group1 = matcher.group(1);
            isodate = isodate.replace(group1, group1.substring(0, 4));
        }
        matcher = fastApiTimestamp2.matcher(isodate);
        if(matcher.find()) {
            String group1 = matcher.group(1);
            isodate = isodate.replace(group1,"");
        }

        isodate = constructIsoDateTime(isodate);
        if(isodate.length()==10) {
            synchronized (dateformat) {
                utilDate = dateformat.parse(isodate);
            }
        }
        else {
            synchronized (timestampformat) {
                utilDate = timestampformat.parse(isodate);
            }
        }
        datetype.setTime(utilDate.getTime());
        return datetype;
    }

    public static void main(String[] agrs) {
        try {
            Date mydate = ISO8601DateTimeSingleton.getInstance().parseDateTime(new Date(System.currentTimeMillis()), "2019-03-13");
            System.out.println(mydate.toString());
        }
        catch(ParseException ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println(constructIsoDateTime("2018-12-12"));
        System.out.println(constructIsoDateTime("2018-12-12 12:12:12"));
        System.out.println(constructIsoDateTime("2018-12-12 12:12:12.123"));
        System.out.println(constructIsoDateTime("2018-12-12T12:12:12.123Z"));
        System.out.println(constructIsoDateTime("2018-12-12T12:12:12.123+0000"));

        try {
            Timestamp myts = ISO8601DateTimeSingleton.getInstance().parseDateTime(Timestamp.valueOf(LocalDateTime.now()), "2018-12-13T12:12:12.123456");
            System.out.println(myts);
            Timestamp myts2 = ISO8601DateTimeSingleton.getInstance().parseDateTime(Timestamp.valueOf(LocalDateTime.now()), "2018-12-13T12:12:12.123");
            System.out.println(myts2);
            Timestamp myts3 = ISO8601DateTimeSingleton.getInstance().parseDateTime(Timestamp.valueOf(LocalDateTime.now()), "2018-12-13T12:12:12.123+00:00");
            System.out.println(myts3);
            Timestamp myts4 = ISO8601DateTimeSingleton.getInstance().parseDateTime(Timestamp.valueOf(LocalDateTime.now()), "2018-12-13T12:12:12.123123+00:00");
            System.out.println(myts4);
            Timestamp myts5 = ISO8601DateTimeSingleton.getInstance().parseDateTime(Timestamp.valueOf(LocalDateTime.now()), "2018-12-12T12:12:12.123Z");
            System.out.println(myts5);
        }
        catch(ParseException ex) {
            System.out.println(ex.getMessage());
        }
    }

    private static final Pattern pattern = Pattern.compile("^(\\d\\d\\d\\d-\\d\\d-\\d\\d)([T ]?(\\d\\d:\\d\\d:\\d\\d)?[.]?(\\d\\d\\d)?([Z]|\\+\\d\\d\\d\\d)?)?");
    private static String constructIsoDateTime(String isodate) {
        if(isodate.length()>8 && isodate.charAt(4)=='-') {
            Matcher matcher = pattern.matcher(isodate);
            if (matcher.matches()) {
                if (matcher.group(1) != null) {
                    isodate = matcher.group(1);
                }
                if (matcher.group(3) != null) {
                    isodate += ('T' + matcher.group(3));
                    if (matcher.group(4) != null) {
                        isodate += ('.' + matcher.group(4) + 'Z');
                    } else {
                        isodate += ".000Z";
                    }
                }
//                else {
//                    isodate += "T00:00:00.00Z";
//                }
            }
        }
        return isodate;
    }
}
