package com.objectriver.microservices.util;
/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
import java.util.Random;

/** Singleton class for Randoms.
 */

public class RandomSingleton {
    private Random ran = new Random(System.currentTimeMillis());

    public long nextLong() {
        long rval;
        synchronized(this) {
            rval = ran.nextLong();
        }
        return rval;
    }
    public long nextLong(int places, boolean absolute) {
        places = Math.min(places,19);
        long modulus = 1L;
        if(places!=19)
            for(int ii=0; ii<places; ii++)
                modulus *= 10;
        /**
         * get random and return.
         */
        long result = ran.nextLong() % modulus;
        if(absolute)
            return Math.abs(result);
        return result;
    }
    private static RandomSingleton ourInstance;
    private RandomSingleton() {
    }
    public synchronized static RandomSingleton getInstance() {
        if (ourInstance == null) {
            ourInstance = new RandomSingleton();
        }
        return ourInstance;
    }
}

