package com.objectriver.microservices.util;

import org.apache.http.NameValuePair;

import java.util.ArrayList;
import java.util.List;

/**
 *                             NOTICE
 *               COPYRIGHT (c) 2016 ObjectRiver Inc
 *                UNPUBLISHED - ALL RIGHTS RESERVED
 */
public class RestNameValuePair implements NameValuePair {
    private final String name;
    private final String value;
    protected RestNameValuePair(String name, String value) {
        super();
        this.name=name;
        this.value=value;
    }
    public static RestNameValuePair of(String name, String value) {
        return new RestNameValuePair(name,value);
    }
    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getValue() {
        return value;
    }

    public static List<NameValuePair> listOf(RestNameValuePair pair) {
        List<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(pair);
        return list;
    }
    public static List<NameValuePair> listOf(NameValuePair array[]) {
        List<NameValuePair> list = new ArrayList<NameValuePair>();
        for(NameValuePair pair : array) {
            list.add(pair);
        }
        return list;
    }
}
