/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.Masker;
import org.glassfish.tyrus.core.ProtocolException;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.core.frame.TyrusFrame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public final class ProtocolHandler {
    public static final int MASK_SIZE = 4;
    private static final Logger LOGGER = Logger.getLogger(ProtocolHandler.class.getName());
    private final boolean client;
    private final SecureRandom secureRandom = new SecureRandom();
    private final ParsingState state = new ParsingState();
    private volatile TyrusWebSocket webSocket;
    private volatile byte outFragmentedType;
    private volatile Writer writer;
    private volatile byte inFragmentedType;
    private volatile boolean processingFragment;
    private volatile boolean sendingFragment = false;
    private volatile String subProtocol = null;
    private volatile List<Extension> extensions;
    private volatile ExtendedExtension.ExtensionContext extensionContext;
    private volatile ByteBuffer remainder = null;
    private volatile boolean hasExtensions = false;
    private volatile MessageEventListener messageEventListener = MessageEventListener.NO_OP;

    ProtocolHandler(boolean client) {
        this.client = client;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }

    public Handshake handshake(TyrusEndpointWrapper endpointWrapper, UpgradeRequest request, UpgradeResponse response, ExtendedExtension.ExtensionContext extensionContext) throws HandshakeException {
        Handshake handshake = Handshake.createServerHandshake(request, extensionContext);
        this.extensions = handshake.respond(request, response, endpointWrapper);
        this.subProtocol = response.getFirstHeaderValue("Sec-WebSocket-Protocol");
        this.extensionContext = extensionContext;
        this.hasExtensions = this.extensions != null && this.extensions.size() > 0;
        return handshake;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    String getSubProtocol() {
        return this.subProtocol;
    }

    public void setWebSocket(TyrusWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public void setExtensionContext(ExtendedExtension.ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        this.hasExtensions = extensions != null && extensions.size() > 0;
    }

    public void setMessageEventListener(MessageEventListener messageEventListener) {
        this.messageEventListener = messageEventListener;
    }

    public final Future<Frame> send(TyrusFrame frame, boolean useTimeout) {
        return this.send(frame, null, (Boolean)useTimeout);
    }

    public final Future<Frame> send(TyrusFrame frame) {
        return this.send(frame, null, (Boolean)true);
    }

    Future<Frame> send(TyrusFrame frame, CompletionHandler<Frame> completionHandler, Boolean useTimeout) {
        return this.write(frame, completionHandler, (boolean)useTimeout);
    }

    Future<Frame> send(ByteBuffer frame, CompletionHandler<Frame> completionHandler, Boolean useTimeout) {
        return this.write(frame, completionHandler, (boolean)useTimeout);
    }

    public Future<Frame> send(byte[] data) {
        return this.send(new BinaryFrame(data, false, true), null, (Boolean)true);
    }

    public void send(byte[] data, final SendHandler handler) {
        this.send(new BinaryFrame(data, false, true), new CompletionHandler<Frame>(){

            public void failed(Throwable throwable) {
                handler.onResult(new SendResult(throwable));
            }

            public void completed(Frame result) {
                handler.onResult(new SendResult());
            }
        }, (Boolean)true);
    }

    public Future<Frame> send(String data) {
        return this.send(new TextFrame(data, false, true));
    }

    public void send(String data, final SendHandler handler) {
        this.send(new TextFrame(data, false, true), new CompletionHandler<Frame>(){

            public void failed(Throwable throwable) {
                handler.onResult(new SendResult(throwable));
            }

            public void completed(Frame result) {
                handler.onResult(new SendResult());
            }
        }, (Boolean)true);
    }

    public Future<Frame> sendRawFrame(ByteBuffer data) {
        return this.send(data, null, (Boolean)true);
    }

    public Future<Frame> stream(boolean last, byte[] bytes, int off, int len) {
        if (this.sendingFragment) {
            if (last) {
                this.sendingFragment = false;
            }
            return this.send(new BinaryFrame(Arrays.copyOfRange(bytes, off, off + len), true, last));
        }
        this.sendingFragment = !last;
        return this.send(new BinaryFrame(Arrays.copyOfRange(bytes, off, off + len), false, last));
    }

    public Future<Frame> stream(boolean last, String fragment) {
        if (this.sendingFragment) {
            if (last) {
                this.sendingFragment = false;
            }
            return this.send(new TextFrame(fragment, true, last));
        }
        this.sendingFragment = !last;
        return this.send(new TextFrame(fragment, false, last));
    }

    public Future<Frame> close(int code, String reason) {
        CloseReason closeReason = new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason);
        CloseFrame outgoingCloseFrame = code == CloseReason.CloseCodes.NO_STATUS_CODE.getCode() || code == CloseReason.CloseCodes.CLOSED_ABNORMALLY.getCode() || code == CloseReason.CloseCodes.TLS_HANDSHAKE_FAILURE.getCode() || this.client && (code == CloseReason.CloseCodes.SERVICE_RESTART.getCode() || code == CloseReason.CloseCodes.TRY_AGAIN_LATER.getCode()) ? new CloseFrame(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, reason)) : new CloseFrame(closeReason);
        Future<Frame> send = this.send(outgoingCloseFrame, null, (Boolean)false);
        this.webSocket.onClose(new CloseFrame(closeReason));
        return send;
    }

    private Future<Frame> write(TyrusFrame frame, CompletionHandler<Frame> completionHandler, boolean useTimeout) {
        Writer localWriter = this.writer;
        TyrusFuture<Frame> future = new TyrusFuture<Frame>();
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        ByteBuffer byteBuffer = this.frame(frame);
        localWriter.write(byteBuffer, (CompletionHandler)new CompletionHandlerWrapper(completionHandler, future, frame));
        this.messageEventListener.onFrameSent(frame.getFrameType(), frame.getPayloadLength());
        return future;
    }

    private Future<Frame> write(ByteBuffer frame, CompletionHandler<Frame> completionHandler, boolean useTimeout) {
        Writer localWriter = this.writer;
        TyrusFuture<Frame> future = new TyrusFuture<Frame>();
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        localWriter.write(frame, (CompletionHandler)new CompletionHandlerWrapper(completionHandler, future, null));
        return future;
    }

    long decodeLength(byte[] bytes) {
        return Utils.toLong(bytes, 0, bytes.length);
    }

    byte[] encodeLength(long length) {
        byte[] lengthBytes;
        if (length <= 125L) {
            lengthBytes = new byte[]{(byte)length};
        } else {
            byte[] b = Utils.toArray(length);
            if (length <= 65535L) {
                lengthBytes = new byte[3];
                lengthBytes[0] = 126;
                System.arraycopy(b, 6, lengthBytes, 1, 2);
            } else {
                lengthBytes = new byte[9];
                lengthBytes[0] = 127;
                System.arraycopy(b, 0, lengthBytes, 1, 8);
            }
        }
        return lengthBytes;
    }

    void validate(byte fragmentType, byte opcode) {
        if (opcode != 0 && opcode != fragmentType && !this.isControlFrame(opcode)) {
            throw new ProtocolException(LocalizationMessages.SEND_MESSAGE_INFRAGMENT());
        }
    }

    byte checkForLastFrame(Frame frame) {
        byte local = frame.getOpcode();
        if (frame.isControlFrame()) {
            local = (byte)(local | 0x80);
            return local;
        }
        if (!frame.isFin()) {
            if (this.outFragmentedType != 0) {
                local = 0;
            } else {
                this.outFragmentedType = local;
                local = (byte)(local & 0x7F);
            }
            this.validate(this.outFragmentedType, local);
        } else if (this.outFragmentedType != 0) {
            local = -128;
            this.outFragmentedType = 0;
        } else {
            local = (byte)(local | 0x80);
        }
        return local;
    }

    public void doClose() {
        Writer localWriter = this.writer;
        if (localWriter == null) {
            throw new IllegalStateException(LocalizationMessages.CONNECTION_NULL());
        }
        try {
            localWriter.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(LocalizationMessages.IOEXCEPTION_CLOSE(), e);
        }
    }

    public ByteBuffer frame(Frame frame) {
        if (this.client) {
            frame = Frame.builder(frame).maskingKey(this.secureRandom.nextInt()).mask(true).build();
        }
        if (this.extensions != null && this.extensions.size() > 0) {
            for (Extension extension : this.extensions) {
                if (!(extension instanceof ExtendedExtension)) continue;
                try {
                    frame = ((ExtendedExtension)extension).processOutgoing(this.extensionContext, frame);
                }
                catch (Throwable t) {
                    LOGGER.log(Level.FINE, LocalizationMessages.EXTENSION_EXCEPTION(extension.getName(), t.getMessage()), t);
                }
            }
        }
        byte opcode = this.checkForLastFrame(frame);
        if (frame.isRsv1()) {
            opcode = (byte)(opcode | 0x40);
        }
        if (frame.isRsv2()) {
            opcode = (byte)(opcode | 0x20);
        }
        if (frame.isRsv3()) {
            opcode = (byte)(opcode | 0x10);
        }
        byte[] bytes = frame.getPayloadData();
        byte[] lengthBytes = this.encodeLength(frame.getPayloadLength());
        int payloadLength = (int)frame.getPayloadLength();
        int length = 1 + lengthBytes.length + payloadLength + (this.client ? 4 : 0);
        int payloadStart = 1 + lengthBytes.length + (this.client ? 4 : 0);
        byte[] packet = new byte[length];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (this.client) {
            Integer maskingKey = frame.getMaskingKey();
            if (maskingKey == null) {
                throw new ProtocolException("Masking key cannot be null when sending message from client to server.");
            }
            Masker masker = new Masker(maskingKey);
            packet[1] = (byte)(packet[1] | 0x80);
            masker.mask(packet, payloadStart, bytes, payloadLength);
            System.arraycopy(masker.getMask(), 0, packet, payloadStart - 4, 4);
        } else {
            System.arraycopy(bytes, 0, packet, payloadStart, payloadLength);
        }
        return ByteBuffer.wrap(packet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Frame unframe(ByteBuffer buffer) {
        try {
            block8: while (true) {
                switch (this.state.state.get()) {
                    case 0: {
                        if (buffer.remaining() < 2) {
                            return null;
                        }
                        byte opcode = buffer.get();
                        this.state.finalFragment = this.isBitSet(opcode, 7);
                        this.state.controlFrame = this.isControlFrame(opcode);
                        this.state.opcode = (byte)(opcode & 0x7F);
                        if (!this.state.finalFragment && this.state.controlFrame) {
                            throw new ProtocolException(LocalizationMessages.CONTROL_FRAME_FRAGMENTED());
                        }
                        byte lengthCode = buffer.get();
                        this.state.masked = (lengthCode & 0x80) == 128;
                        this.state.masker = new Masker(buffer);
                        if (this.state.masked) {
                            lengthCode = (byte)(lengthCode ^ 0x80);
                        }
                        this.state.lengthCode = lengthCode;
                        this.state.state.incrementAndGet();
                        continue block8;
                    }
                    case 1: {
                        if (this.state.lengthCode <= 125) {
                            this.state.length = this.state.lengthCode;
                        } else {
                            int lengthBytes;
                            if (this.state.controlFrame) {
                                throw new ProtocolException(LocalizationMessages.CONTROL_FRAME_LENGTH());
                            }
                            int n = lengthBytes = this.state.lengthCode == 126 ? 2 : 8;
                            if (buffer.remaining() < lengthBytes) {
                                return null;
                            }
                            this.state.masker.setBuffer(buffer);
                            this.state.length = this.decodeLength(this.state.masker.unmask(lengthBytes));
                        }
                        this.state.state.incrementAndGet();
                        continue block8;
                    }
                    case 2: {
                        if (this.state.masked) {
                            if (buffer.remaining() < 4) {
                                return null;
                            }
                            this.state.masker.setBuffer(buffer);
                            this.state.masker.readMask();
                        }
                        this.state.state.incrementAndGet();
                        continue block8;
                    }
                    case 3: {
                        if ((long)buffer.remaining() < this.state.length) {
                            return null;
                        }
                        this.state.masker.setBuffer(buffer);
                        byte[] data = this.state.masker.unmask((int)this.state.length);
                        if ((long)data.length != this.state.length) {
                            throw new ProtocolException(LocalizationMessages.DATA_UNEXPECTED_LENGTH(data.length, this.state.length));
                        }
                        Frame frame = Frame.builder().fin(this.state.finalFragment).rsv1(this.isBitSet(this.state.opcode, 6)).rsv2(this.isBitSet(this.state.opcode, 5)).rsv3(this.isBitSet(this.state.opcode, 4)).opcode((byte)(this.state.opcode & 0xF)).payloadLength(this.state.length).payloadData(data).build();
                        this.state.recycle();
                        return frame;
                    }
                }
                break;
            }
            throw new IllegalStateException(LocalizationMessages.UNEXPECTED_STATE(this.state.state));
        }
        catch (Exception e) {
            this.state.recycle();
            throw (RuntimeException)e;
        }
    }

    public void process(Frame frame, TyrusWebSocket socket) {
        CloseReason.CloseCode closeCode;
        TyrusFrame tyrusFrame;
        if (frame.isRsv1() || frame.isRsv2() || frame.isRsv3()) {
            throw new ProtocolException(LocalizationMessages.RSV_INCORRECTLY_SET());
        }
        byte opcode = frame.getOpcode();
        boolean fin = frame.isFin();
        if (!frame.isControlFrame()) {
            boolean continuationFrame;
            boolean bl = continuationFrame = opcode == 0;
            if (continuationFrame && !this.processingFragment) {
                throw new ProtocolException(LocalizationMessages.UNEXPECTED_END_FRAGMENT());
            }
            if (this.processingFragment && !continuationFrame) {
                throw new ProtocolException(LocalizationMessages.FRAGMENT_INVALID_OPCODE());
            }
            if (!fin && !continuationFrame) {
                this.processingFragment = true;
            }
            if (!fin && this.inFragmentedType == 0) {
                this.inFragmentedType = opcode;
            }
        }
        if ((tyrusFrame = TyrusFrame.wrap(frame, this.inFragmentedType, this.remainder)) instanceof TextFrame) {
            this.remainder = ((TextFrame)tyrusFrame).getRemainder();
        }
        if (!this.client && tyrusFrame.isControlFrame() && tyrusFrame instanceof CloseFrame && ((closeCode = ((CloseFrame)tyrusFrame).getCloseReason().getCloseCode()).equals(CloseReason.CloseCodes.SERVICE_RESTART) || closeCode.equals(CloseReason.CloseCodes.TRY_AGAIN_LATER))) {
            throw new ProtocolException("Illegal close code: " + closeCode);
        }
        tyrusFrame.respond(socket);
        if (!tyrusFrame.isControlFrame() && fin) {
            this.inFragmentedType = 0;
            this.processingFragment = false;
        }
    }

    private boolean isControlFrame(byte opcode) {
        return (opcode & 8) == 8;
    }

    private boolean isBitSet(byte b, int bit) {
        return (b >> bit & 1) != 0;
    }

    private static class ParsingState {
        final AtomicInteger state = new AtomicInteger(0);
        volatile byte opcode = (byte)-1;
        volatile long length = -1L;
        volatile boolean masked;
        volatile Masker masker;
        volatile boolean finalFragment;
        volatile boolean controlFrame;
        private volatile byte lengthCode = (byte)-1;

        private ParsingState() {
        }

        void recycle() {
            this.state.set(0);
            this.opcode = (byte)-1;
            this.length = -1L;
            this.lengthCode = (byte)-1;
            this.masked = false;
            this.masker = null;
            this.finalFragment = false;
            this.controlFrame = false;
        }
    }

    private static class CompletionHandlerWrapper
    extends CompletionHandler<ByteBuffer> {
        private final CompletionHandler<Frame> frameCompletionHandler;
        private final TyrusFuture<Frame> future;
        private final Frame frame;

        private CompletionHandlerWrapper(CompletionHandler<Frame> frameCompletionHandler, TyrusFuture<Frame> future, Frame frame) {
            this.frameCompletionHandler = frameCompletionHandler;
            this.future = future;
            this.frame = frame;
        }

        public void cancelled() {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.cancelled();
            }
            if (this.future != null) {
                this.future.setFailure(new RuntimeException(LocalizationMessages.FRAME_WRITE_CANCELLED()));
            }
        }

        public void failed(Throwable throwable) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.failed(throwable);
            }
            if (this.future != null) {
                this.future.setFailure(throwable);
            }
        }

        public void completed(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.completed((Object)this.frame);
            }
            if (this.future != null) {
                this.future.setResult(this.frame);
            }
        }

        public void updated(ByteBuffer result) {
            if (this.frameCompletionHandler != null) {
                this.frameCompletionHandler.updated((Object)this.frame);
            }
        }
    }
}

