/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.DeploymentException;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.BaseContainer;
import org.glassfish.tyrus.core.CloseReasons;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.InputStreamBuffer;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.ReaderBuffer;
import org.glassfish.tyrus.core.ReflectionHelper;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusFuture;
import org.glassfish.tyrus.core.TyrusServerEndpointConfig;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.cluster.BroadcastListener;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.cluster.RemoteSession;
import org.glassfish.tyrus.core.coder.CoderWrapper;
import org.glassfish.tyrus.core.coder.InputStreamDecoder;
import org.glassfish.tyrus.core.coder.NoOpByteArrayCoder;
import org.glassfish.tyrus.core.coder.NoOpByteBufferCoder;
import org.glassfish.tyrus.core.coder.NoOpTextCoder;
import org.glassfish.tyrus.core.coder.PrimitiveDecoders;
import org.glassfish.tyrus.core.coder.ReaderDecoder;
import org.glassfish.tyrus.core.coder.ToStringEncoder;
import org.glassfish.tyrus.core.frame.BinaryFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.frame.TextFrame;
import org.glassfish.tyrus.core.frame.TyrusFrame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public class TyrusEndpointWrapper {
    private static final Logger LOGGER = Logger.getLogger(TyrusEndpointWrapper.class.getName());
    private static final int MIN_SESSIONS_PER_THREAD = 16;
    private final WebSocketContainer container;
    private final String contextPath;
    private final String endpointPath;
    private final String serverEndpointPath;
    private final List<CoderWrapper<Decoder>> decoders = new ArrayList<CoderWrapper<Decoder>>();
    private final List<CoderWrapper<Encoder>> encoders = new ArrayList<CoderWrapper<Encoder>>();
    private final EndpointConfig configuration;
    private final Class<? extends Endpoint> endpointClass;
    private final Endpoint endpoint;
    private final Map<TyrusWebSocket, TyrusSession> webSocketToSession = new ConcurrentHashMap<TyrusWebSocket, TyrusSession>();
    private final Map<String, RemoteSession> clusteredSessions = new ConcurrentHashMap<String, RemoteSession>();
    private final ComponentProviderService componentProvider;
    private final ServerEndpointConfig.Configurator configurator;
    private final Method onOpen;
    private final Method onClose;
    private final Method onError;
    private final SessionListener sessionListener;
    private final EndpointEventListener endpointEventListener;
    private final boolean parallelBroadcastEnabled;
    private final ClusterContext clusterContext;
    private static final Session dummySession = new Session(){

        public WebSocketContainer getContainer() {
            return null;
        }

        public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        }

        public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        }

        public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        }

        public Set<MessageHandler> getMessageHandlers() {
            return null;
        }

        public void removeMessageHandler(MessageHandler handler) {
        }

        public String getProtocolVersion() {
            return null;
        }

        public String getNegotiatedSubprotocol() {
            return null;
        }

        public List<Extension> getNegotiatedExtensions() {
            return null;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public long getMaxIdleTimeout() {
            return 0L;
        }

        public void setMaxIdleTimeout(long milliseconds) {
        }

        public void setMaxBinaryMessageBufferSize(int length) {
        }

        public int getMaxBinaryMessageBufferSize() {
            return 0;
        }

        public void setMaxTextMessageBufferSize(int length) {
        }

        public int getMaxTextMessageBufferSize() {
            return 0;
        }

        public RemoteEndpoint.Async getAsyncRemote() {
            return null;
        }

        public RemoteEndpoint.Basic getBasicRemote() {
            return null;
        }

        public String getId() {
            return null;
        }

        public void close() throws IOException {
        }

        public void close(CloseReason closeReason) throws IOException {
        }

        public URI getRequestURI() {
            return null;
        }

        public Map<String, List<String>> getRequestParameterMap() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public Map<String, String> getPathParameters() {
            return null;
        }

        public Map<String, Object> getUserProperties() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public Set<Session> getOpenSessions() {
            return null;
        }
    };

    public TyrusEndpointWrapper(Class<? extends Endpoint> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, ClusterContext clusterContext, EndpointEventListener endpointEventListener, Boolean parallelBroadcastEnabled) throws DeploymentException {
        this(null, endpointClass, configuration, componentProvider, container, contextPath, configurator, sessionListener, clusterContext, endpointEventListener, parallelBroadcastEnabled);
    }

    public TyrusEndpointWrapper(Endpoint endpoint, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, ClusterContext clusterContext, EndpointEventListener endpointEventListener, Boolean parallelBroadcastEnabled) throws DeploymentException {
        this(endpoint, null, configuration, componentProvider, container, contextPath, configurator, sessionListener, clusterContext, endpointEventListener, parallelBroadcastEnabled);
    }

    /*
     * WARNING - void declaration
     */
    private TyrusEndpointWrapper(Endpoint endpoint, Class<? extends Endpoint> endpointClass, EndpointConfig configuration, ComponentProviderService componentProvider, WebSocketContainer container, String contextPath, final ServerEndpointConfig.Configurator configurator, SessionListener sessionListener, final ClusterContext clusterContext, EndpointEventListener endpointEventListener, Boolean parallelBroadcastEnabled) throws DeploymentException {
        Class<?> type;
        Method method;
        this.endpointClass = endpointClass;
        this.endpoint = endpoint;
        this.container = container;
        this.contextPath = contextPath;
        this.configurator = configurator;
        this.sessionListener = sessionListener;
        this.clusterContext = clusterContext;
        this.endpointEventListener = endpointEventListener != null ? endpointEventListener : EndpointEventListener.NO_OP;
        this.parallelBroadcastEnabled = parallelBroadcastEnabled == null ? true : parallelBroadcastEnabled;
        if (configuration instanceof ServerEndpointConfig) {
            this.serverEndpointPath = ((ServerEndpointConfig)configuration).getPath();
            this.endpointPath = (contextPath.endsWith("/") ? contextPath.substring(0, contextPath.length() - 1) : contextPath) + "/" + (this.serverEndpointPath.startsWith("/") ? this.serverEndpointPath.substring(1) : this.serverEndpointPath);
        } else {
            this.serverEndpointPath = null;
            this.endpointPath = null;
        }
        this.componentProvider = configurator == null ? componentProvider : new ComponentProviderService(componentProvider){

            public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
                return (T)configurator.getEndpointInstance(endpointClass);
            }
        };
        Class<Object> clazz = endpointClass == null ? endpoint.getClass() : endpointClass;
        Object var13_13 = null;
        Method onCloseMethod = null;
        Method onErrorMethod = null;
        for (Method m : Endpoint.class.getMethods()) {
            if (m.getName().equals("onOpen")) {
                Method method2 = m;
                continue;
            }
            if (m.getName().equals("onClose")) {
                onCloseMethod = m;
                continue;
            }
            if (!m.getName().equals("onError")) continue;
            onErrorMethod = m;
        }
        try {
            void var13_14;
            assert (var13_14 != null);
            assert (onCloseMethod != null);
            assert (onErrorMethod != null);
            method = clazz.getMethod(var13_14.getName(), var13_14.getParameterTypes());
            onCloseMethod = clazz.getMethod(onCloseMethod.getName(), onCloseMethod.getParameterTypes());
            onErrorMethod = clazz.getMethod(onErrorMethod.getName(), onErrorMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        if (endpoint != null) {
            this.onOpen = method;
            this.onClose = onCloseMethod;
            this.onError = onErrorMethod;
        } else {
            this.onOpen = componentProvider.getInvocableMethod(method);
            this.onClose = componentProvider.getInvocableMethod(onCloseMethod);
            this.onError = componentProvider.getInvocableMethod(onErrorMethod);
        }
        this.configuration = configuration == null ? new EndpointConfig(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            public List<Class<? extends Encoder>> getEncoders() {
                return Collections.emptyList();
            }

            public List<Class<? extends Decoder>> getDecoders() {
                return Collections.emptyList();
            }

            public Map<String, Object> getUserProperties() {
                return this.properties;
            }
        } : configuration;
        for (Class clazz2 : this.configuration.getDecoders()) {
            type = this.getDecoderClassType(clazz2);
            if (TyrusEndpointWrapper.getDefaultDecoders().contains(clazz2)) {
                try {
                    this.decoders.add(new CoderWrapper(ReflectionHelper.getInstance(clazz2), type));
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new DeploymentException(e.getMessage(), (Throwable)e);
                }
            }
            this.decoders.add(new CoderWrapper<Class>(clazz2, type));
        }
        if (endpoint == null || !(endpoint instanceof AnnotatedEndpoint)) {
            for (Class clazz3 : TyrusEndpointWrapper.getDefaultDecoders()) {
                type = this.getDecoderClassType(clazz3);
                try {
                    this.decoders.add(new CoderWrapper(ReflectionHelper.getInstance(clazz3), type));
                }
                catch (ReflectiveOperationException e) {
                    throw new DeploymentException(e.getMessage(), (Throwable)e);
                }
            }
        }
        for (Class clazz4 : this.configuration.getEncoders()) {
            type = this.getEncoderClassType(clazz4);
            this.encoders.add(new CoderWrapper<Class>(clazz4, type));
        }
        this.encoders.add(new CoderWrapper<NoOpTextCoder>(new NoOpTextCoder(), String.class));
        this.encoders.add(new CoderWrapper<NoOpByteBufferCoder>(new NoOpByteBufferCoder(), ByteBuffer.class));
        this.encoders.add(new CoderWrapper<NoOpByteArrayCoder>(new NoOpByteArrayCoder(), byte[].class));
        this.encoders.add(new CoderWrapper<ToStringEncoder>(new ToStringEncoder(), Object.class));
        if (clusterContext != null) {
            clusterContext.registerSessionListener(this.getEndpointPath(), new org.glassfish.tyrus.core.cluster.SessionListener(){

                @Override
                public void onSessionOpened(String sessionId) {
                    Map<RemoteSession.DistributedMapKey, Object> distributedSessionProperties = clusterContext.getDistributedSessionProperties(sessionId);
                    TyrusEndpointWrapper.this.clusteredSessions.put(sessionId, new RemoteSession(sessionId, clusterContext, distributedSessionProperties, TyrusEndpointWrapper.this, dummySession));
                }

                @Override
                public void onSessionClosed(String sessionId) {
                    TyrusEndpointWrapper.this.clusteredSessions.remove(sessionId);
                }
            });
            clusterContext.registerBroadcastListener(this.getEndpointPath(), new BroadcastListener(){

                @Override
                public void onBroadcast(String text) {
                    TyrusEndpointWrapper.this.broadcast(text, true);
                }

                @Override
                public void onBroadcast(byte[] data) {
                    TyrusEndpointWrapper.this.broadcast(ByteBuffer.wrap(data), true);
                }
            });
            for (String string : clusterContext.getRemoteSessionIds(this.getEndpointPath())) {
                Map<RemoteSession.DistributedMapKey, Object> distributedSessionProperties = clusterContext.getDistributedSessionProperties(string);
                this.clusteredSessions.put(string, new RemoteSession(string, clusterContext, distributedSessionProperties, this, dummySession));
            }
        }
    }

    static List<Class<? extends Decoder>> getDefaultDecoders() {
        ArrayList<Class<? extends Decoder>> classList = new ArrayList<Class<? extends Decoder>>();
        classList.addAll(PrimitiveDecoders.ALL);
        classList.add(NoOpTextCoder.class);
        classList.add(NoOpByteBufferCoder.class);
        classList.add(NoOpByteArrayCoder.class);
        classList.add(ReaderDecoder.class);
        classList.add(InputStreamDecoder.class);
        return classList;
    }

    private static URI getURI(String uri, String queryString) {
        if (queryString != null && !queryString.isEmpty()) {
            return URI.create(String.format("%s?%s", uri, queryString));
        }
        return URI.create(uri);
    }

    private <T> Object getCoderInstance(Session session, CoderWrapper<T> wrapper) {
        T coder = wrapper.getCoder();
        if (coder == null) {
            ErrorCollector collector = new ErrorCollector();
            Object coderInstance = this.componentProvider.getCoderInstance(wrapper.getCoderClass(), session, this.getEndpointConfig(), collector);
            if (!collector.isEmpty()) {
                DeploymentException deploymentException = collector.composeComprehensiveException();
                LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                return null;
            }
            return coderInstance;
        }
        return coder;
    }

    Object decodeCompleteMessage(TyrusSession session, Object message, Class<?> type, CoderWrapper<Decoder> selectedDecoder) throws DecodeException, IOException {
        Class<Decoder> decoderClass = selectedDecoder.getCoderClass();
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                Decoder.Text decoder = (Decoder.Text)this.getCoderInstance(session, selectedDecoder);
                session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Decoding with ", selectedDecoder);
                return decoder.decode((String)message);
            }
        } else if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                Decoder.Binary decoder = (Decoder.Binary)this.getCoderInstance(session, selectedDecoder);
                session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Decoding with ", selectedDecoder);
                return decoder.decode((ByteBuffer)message);
            }
        } else if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            if (type != null && type.isAssignableFrom(selectedDecoder.getType())) {
                session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Decoding with ", selectedDecoder);
                return ((Decoder.TextStream)this.getCoderInstance(session, selectedDecoder)).decode((Reader)new StringReader((String)message));
            }
        } else if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass) && type != null && type.isAssignableFrom(selectedDecoder.getType())) {
            byte[] array = ((ByteBuffer)message).array();
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Decoding with ", selectedDecoder);
            return ((Decoder.BinaryStream)this.getCoderInstance(session, selectedDecoder)).decode((InputStream)new ByteArrayInputStream(array));
        }
        return null;
    }

    private ArrayList<CoderWrapper<Decoder>> findApplicableDecoders(TyrusSession session, Object message, boolean isString) {
        ArrayList<CoderWrapper<Decoder>> result = new ArrayList<CoderWrapper<Decoder>>();
        for (CoderWrapper<Decoder> dec : this.decoders) {
            Decoder.Text decoder;
            if (isString && Decoder.Text.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Text)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((String)message)) continue;
                result.add(dec);
                continue;
            }
            if (!isString && Decoder.Binary.class.isAssignableFrom(dec.getCoderClass())) {
                decoder = (Decoder.Binary)this.getCoderInstance(session, dec);
                if (!decoder.willDecode((ByteBuffer)message)) continue;
                result.add(dec);
                continue;
            }
            if (isString && Decoder.TextStream.class.isAssignableFrom(dec.getCoderClass())) {
                result.add(dec);
                continue;
            }
            if (isString || !Decoder.BinaryStream.class.isAssignableFrom(dec.getCoderClass())) continue;
            result.add(dec);
        }
        session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Applicable decoders: ", result);
        return result;
    }

    public Object doEncode(Session session, Object message) throws EncodeException, IOException {
        for (CoderWrapper<Encoder> enc : this.encoders) {
            Class<Encoder> encoderClass = enc.getCoderClass();
            if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                Encoder.Binary encoder = (Encoder.Binary)this.getCoderInstance(session, enc);
                this.logUsedEncoder(enc, session);
                return encoder.encode(message);
            }
            if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                Encoder.Text encoder = (Encoder.Text)this.getCoderInstance(session, enc);
                this.logUsedEncoder(enc, session);
                return encoder.encode(message);
            }
            if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
                if (!enc.getType().isAssignableFrom(message.getClass())) continue;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Encoder.BinaryStream encoder = (Encoder.BinaryStream)this.getCoderInstance(session, enc);
                this.logUsedEncoder(enc, session);
                encoder.encode(message, (OutputStream)stream);
                return stream;
            }
            if (!Encoder.TextStream.class.isAssignableFrom(encoderClass) || !enc.getType().isAssignableFrom(message.getClass())) continue;
            StringWriter writer = new StringWriter();
            Encoder.TextStream encoder = (Encoder.TextStream)this.getCoderInstance(session, enc);
            this.logUsedEncoder(enc, session);
            encoder.encode(message, (Writer)writer);
            return writer;
        }
        throw new EncodeException(message, LocalizationMessages.ENCODING_FAILED());
    }

    private void logUsedEncoder(CoderWrapper<Encoder> encoder, Session session) {
        if (LOGGER.isLoggable(Level.FINEST) && session instanceof TyrusSession) {
            ((TyrusSession)session).getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_OUT, "Encoding with: ", encoder);
        }
    }

    public String getEndpointPath() {
        return this.endpointPath;
    }

    String getServerEndpointPath() {
        return this.serverEndpointPath;
    }

    List<Extension> getNegotiatedExtensions(List<Extension> clientExtensions) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedExtensions(((ServerEndpointConfig)this.configuration).getExtensions(), clientExtensions);
        }
        return Collections.emptyList();
    }

    String getNegotiatedProtocol(List<String> clientProtocols) {
        if (this.configuration instanceof ServerEndpointConfig) {
            return this.configurator.getNegotiatedSubprotocol(((ServerEndpointConfig)this.configuration).getSubprotocols(), clientProtocols);
        }
        return null;
    }

    Set<TyrusSession> getOpenSessions() {
        HashSet<TyrusSession> result = new HashSet<TyrusSession>();
        for (TyrusSession session : this.webSocketToSession.values()) {
            if (!session.isOpen()) continue;
            result.add(session);
        }
        return Collections.unmodifiableSet(result);
    }

    Set<RemoteSession> getRemoteSessions() {
        HashSet<RemoteSession> result = new HashSet<RemoteSession>();
        if (this.clusterContext != null) {
            result.addAll(this.clusteredSessions.values());
        }
        return Collections.unmodifiableSet(result);
    }

    public Session createSessionForRemoteEndpoint(TyrusWebSocket socket, String subprotocol, List<Extension> extensions, DebugContext debugContext) {
        TyrusSession session = new TyrusSession(this.container, socket, this, subprotocol, extensions, false, TyrusEndpointWrapper.getURI(this.contextPath, null), null, Collections.<String, String>emptyMap(), null, Collections.<String, List<String>>emptyMap(), null, null, null, debugContext);
        this.webSocketToSession.put(socket, session);
        return session;
    }

    private TyrusSession getSession(TyrusWebSocket socket) {
        return this.webSocketToSession.get(socket);
    }

    Session onConnect(TyrusWebSocket socket, UpgradeRequest upgradeRequest, String subProtocol, List<Extension> extensions, String connectionId, DebugContext debugContext) {
        Endpoint toCall;
        TyrusSession session = this.webSocketToSession.get(socket);
        if (session == null) {
            HashMap<String, String> templateValues = new HashMap<String, String>();
            for (Map.Entry entry : upgradeRequest.getParameterMap().entrySet()) {
                templateValues.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            session = new TyrusSession(this.container, socket, this, subProtocol, extensions, upgradeRequest.isSecure(), TyrusEndpointWrapper.getURI(upgradeRequest.getRequestURI().toString(), upgradeRequest.getQueryString()), upgradeRequest.getQueryString(), templateValues, upgradeRequest.getUserPrincipal(), upgradeRequest.getParameterMap(), this.clusterContext, connectionId, ((RequestContext)upgradeRequest).getRemoteAddr(), debugContext);
            this.webSocketToSession.put(socket, session);
            boolean maxSessionPerEndpointExceeded = this.configuration instanceof TyrusServerEndpointConfig && ((TyrusServerEndpointConfig)this.configuration).getMaxSessions() > 0 && this.webSocketToSession.size() > ((TyrusServerEndpointConfig)this.configuration).getMaxSessions();
            SessionListener.OnOpenResult onOpenResult = this.sessionListener.onOpen(session);
            if (maxSessionPerEndpointExceeded || !onOpenResult.equals((Object)SessionListener.OnOpenResult.SESSION_ALLOWED)) {
                try {
                    String refuseDetail;
                    this.webSocketToSession.remove(socket);
                    if (maxSessionPerEndpointExceeded) {
                        refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_ENDPOINT_EXCEEDED();
                    } else {
                        switch (onOpenResult) {
                            case MAX_SESSIONS_PER_APP_EXCEEDED: {
                                refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_APP_EXCEEDED();
                                break;
                            }
                            case MAX_SESSIONS_PER_REMOTE_ADDR_EXCEEDED: {
                                refuseDetail = LocalizationMessages.MAX_SESSIONS_PER_REMOTEADDR_EXCEEDED();
                                break;
                            }
                            default: {
                                refuseDetail = null;
                            }
                        }
                    }
                    debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Session opening refused: ", refuseDetail);
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.TRY_AGAIN_LATER, refuseDetail));
                }
                catch (IOException e) {
                    debugContext.appendLogMessageWithThrowable(LOGGER, Level.WARNING, DebugContext.Type.MESSAGE_IN, e, e.getMessage());
                }
                return null;
            }
            socket.setMessageEventListener(this.endpointEventListener.onSessionOpened(session.getId()));
        }
        ErrorCollector collector = new ErrorCollector();
        Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
        if (toCall == null) {
            if (!collector.isEmpty()) {
                DeploymentException t = collector.composeComprehensiveException();
                debugContext.appendLogMessageWithThrowable(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, (Throwable)t, t.getMessage());
            }
            this.webSocketToSession.remove(socket);
            this.sessionListener.onClose(session, CloseReasons.UNEXPECTED_CONDITION.getCloseReason());
            try {
                session.close(CloseReasons.UNEXPECTED_CONDITION.getCloseReason());
            }
            catch (IOException e) {
                debugContext.appendLogMessageWithThrowable(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, e, e.getMessage());
            }
            return null;
        }
        try {
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
            if (this.endpoint != null) {
                toCall.onOpen((Session)session, this.configuration);
            } else {
                this.onOpen.invoke((Object)toCall, session, this.configuration);
            }
        }
        catch (Throwable t) {
            if (this.endpoint != null) {
                toCall.onError((Session)session, t);
            } else {
                try {
                    this.onError.invoke((Object)toCall, session, t);
                }
                catch (Exception e) {
                    debugContext.appendLogMessageWithThrowable(LOGGER, Level.WARNING, DebugContext.Type.MESSAGE_IN, t, t.getMessage());
                }
            }
            this.endpointEventListener.onError(session.getId(), t);
        }
        return session;
    }

    void onMessage(TyrusWebSocket socket, ByteBuffer messageBytes) {
        block13: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received binary message");
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                    session.setState(TyrusSession.State.RUNNING);
                }
                if (session.isWholeBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, this.findApplicableDecoders(session, messageBytes, false));
                    break block13;
                }
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageBytes, true);
                    break block13;
                }
                throw new IllegalStateException(LocalizationMessages.BINARY_MESSAGE_HANDLER_NOT_FOUND(session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block13;
                ErrorCollector collector = new ErrorCollector();
                Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError((Session)session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    void onMessage(TyrusWebSocket socket, String messageString) {
        block13: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received text message");
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                    session.setState(TyrusSession.State.RUNNING);
                }
                if (session.isWholeTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, this.findApplicableDecoders(session, messageString, true));
                    break block13;
                }
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)messageString, true);
                    break block13;
                }
                throw new IllegalStateException(LocalizationMessages.TEXT_MESSAGE_HANDLER_NOT_FOUND(session));
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block13;
                ErrorCollector collector = new ErrorCollector();
                Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError((Session)session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    void onPartialMessage(TyrusWebSocket socket, String partialString, boolean last) {
        block26: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received partial text message");
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (session.isPartialTextHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialString, last);
                    if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                        session.setState(TyrusSession.State.RUNNING);
                    }
                    break block26;
                }
                if (session.isReaderHandlerPresent()) {
                    ReaderBuffer buffer = session.getReaderBuffer();
                    switch (state) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new ReaderBuffer(((BaseContainer)this.container).getExecutorService());
                                session.setReaderBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxTextMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(Reader.class));
                            buffer.appendMessagePart(partialString, last);
                            session.setState(TyrusSession.State.RECEIVING_TEXT);
                            break;
                        }
                        case RECEIVING_TEXT: {
                            buffer.appendMessagePart(partialString, last);
                            if (last) {
                                session.setState(TyrusSession.State.RUNNING);
                                break;
                            }
                            break block26;
                        }
                        default: {
                            if (state == TyrusSession.State.RECEIVING_BINARY) {
                                session.setState(TyrusSession.State.RUNNING);
                            }
                            throw new IllegalStateException(LocalizationMessages.PARTIAL_TEXT_MESSAGE_OUT_OF_ORDER(session));
                        }
                    }
                    break block26;
                }
                if (!session.isWholeTextHandlerPresent()) break block26;
                switch (state) {
                    case RUNNING: {
                        session.getTextBuffer().resetBuffer(session.getMaxTextMessageBufferSize());
                        session.getTextBuffer().appendMessagePart(partialString);
                        session.setState(TyrusSession.State.RECEIVING_TEXT);
                        break;
                    }
                    case RECEIVING_TEXT: {
                        session.getTextBuffer().appendMessagePart(partialString);
                        if (last) {
                            String message = session.getTextBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)message, this.findApplicableDecoders(session, message, true));
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        if (state == TyrusSession.State.RECEIVING_BINARY) {
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        throw new IllegalStateException(LocalizationMessages.TEXT_MESSAGE_OUT_OF_ORDER(session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block26;
                ErrorCollector collector = new ErrorCollector();
                Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError((Session)session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    void onPartialMessage(TyrusWebSocket socket, ByteBuffer partialBytes, boolean last) {
        block26: {
            TyrusSession session = this.getSession(socket);
            if (session == null) {
                LOGGER.log(Level.FINE, "Message received on already closed connection.");
                return;
            }
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received partial binary message");
            try {
                session.restartIdleTimeoutExecutor();
                TyrusSession.State state = session.getState();
                if (session.isPartialBinaryHandlerPresent()) {
                    session.notifyMessageHandlers((Object)partialBytes, last);
                    if (state == TyrusSession.State.RECEIVING_BINARY || state == TyrusSession.State.RECEIVING_TEXT) {
                        session.setState(TyrusSession.State.RUNNING);
                    }
                    break block26;
                }
                if (session.isInputStreamHandlerPresent()) {
                    InputStreamBuffer buffer = session.getInputStreamBuffer();
                    switch (state) {
                        case RUNNING: {
                            if (buffer == null) {
                                buffer = new InputStreamBuffer(((BaseContainer)this.container).getExecutorService());
                                session.setInputStreamBuffer(buffer);
                            }
                            buffer.resetBuffer(session.getMaxBinaryMessageBufferSize());
                            buffer.setMessageHandler(session.getMessageHandler(InputStream.class));
                            buffer.appendMessagePart(partialBytes, last);
                            session.setState(TyrusSession.State.RECEIVING_BINARY);
                            break;
                        }
                        case RECEIVING_BINARY: {
                            buffer.appendMessagePart(partialBytes, last);
                            if (last) {
                                session.setState(TyrusSession.State.RUNNING);
                                break;
                            }
                            break block26;
                        }
                        default: {
                            if (state == TyrusSession.State.RECEIVING_TEXT) {
                                session.setState(TyrusSession.State.RUNNING);
                            }
                            throw new IllegalStateException(LocalizationMessages.PARTIAL_BINARY_MESSAGE_OUT_OF_ORDER(session));
                        }
                    }
                    break block26;
                }
                if (!session.isWholeBinaryHandlerPresent()) break block26;
                switch (state) {
                    case RUNNING: {
                        session.getBinaryBuffer().resetBuffer(session.getMaxBinaryMessageBufferSize());
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        session.setState(TyrusSession.State.RECEIVING_BINARY);
                        break;
                    }
                    case RECEIVING_BINARY: {
                        session.getBinaryBuffer().appendMessagePart(partialBytes);
                        if (last) {
                            ByteBuffer bb = session.getBinaryBuffer().getBufferedContent();
                            session.notifyMessageHandlers((Object)bb, this.findApplicableDecoders(session, bb, false));
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        break;
                    }
                    default: {
                        if (state == TyrusSession.State.RECEIVING_TEXT) {
                            session.setState(TyrusSession.State.RUNNING);
                        }
                        throw new IllegalStateException(LocalizationMessages.BINARY_MESSAGE_OUT_OF_ORDER(session));
                    }
                }
            }
            catch (Throwable t) {
                Endpoint toCall;
                if (this.processThrowable(t, session)) break block26;
                ErrorCollector collector = new ErrorCollector();
                Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                if (toCall != null) {
                    if (this.endpoint != null) {
                        toCall.onError((Session)session, t);
                    } else {
                        try {
                            this.onError.invoke((Object)toCall, session, t);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                } else if (!collector.isEmpty()) {
                    DeploymentException deploymentException = collector.composeComprehensiveException();
                    LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                }
                this.endpointEventListener.onError(session.getId(), t);
            }
        }
    }

    private boolean processThrowable(Throwable throwable, Session session) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("Exception thrown while processing message. Session: '%session'.", session), throwable);
        }
        if (throwable instanceof WebSocketException) {
            try {
                session.close(((WebSocketException)throwable).getCloseReason());
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    void onPong(TyrusWebSocket socket, final ByteBuffer bytes) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            LOGGER.log(Level.FINE, "Pong received on already closed connection.");
            return;
        }
        session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received pong message");
        session.restartIdleTimeoutExecutor();
        if (session.isPongHandlerPresent()) {
            try {
                session.notifyPongHandler(new PongMessage(){

                    public ByteBuffer getApplicationData() {
                        return bytes;
                    }

                    public String toString() {
                        return "PongMessage: " + bytes;
                    }
                });
            }
            catch (Throwable t) {
                if (!this.processThrowable(t, session)) {
                    Endpoint toCall;
                    ErrorCollector collector = new ErrorCollector();
                    Object object = toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
                    if (toCall != null) {
                        if (this.endpoint != null) {
                            toCall.onError((Session)session, t);
                        } else {
                            try {
                                this.onError.invoke((Object)toCall, session, t);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.WARNING, t.getMessage(), t);
                            }
                        }
                    } else if (!collector.isEmpty()) {
                        DeploymentException deploymentException = collector.composeComprehensiveException();
                        LOGGER.log(Level.WARNING, deploymentException.getMessage(), (Throwable)deploymentException);
                    }
                    this.endpointEventListener.onError(session.getId(), t);
                }
            }
        } else {
            session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Unhandled pong message");
        }
    }

    void onPing(TyrusWebSocket socket, ByteBuffer bytes) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            LOGGER.log(Level.FINE, "Ping received on already closed connection.");
            return;
        }
        session.getDebugContext().appendLogMessage(LOGGER, Level.FINEST, DebugContext.Type.MESSAGE_IN, "Received ping message");
        session.restartIdleTimeoutExecutor();
        try {
            session.getBasicRemote().sendPong(bytes);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClose(TyrusWebSocket socket, CloseReason closeReason) {
        TyrusSession session = this.getSession(socket);
        if (session == null) {
            return;
        }
        session.setState(TyrusSession.State.CLOSED);
        ErrorCollector collector = new ErrorCollector();
        Endpoint toCall = this.endpoint != null ? this.endpoint : this.componentProvider.getInstance(this.endpointClass, session, collector);
        try {
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
            if (this.endpoint != null) {
                toCall.onClose((Session)session, closeReason);
            } else {
                this.onClose.invoke((Object)toCall, session, closeReason);
            }
        }
        catch (Throwable t) {
            if (toCall != null) {
                if (this.endpoint != null) {
                    toCall.onError((Session)session, t);
                } else {
                    try {
                        this.onError.invoke((Object)toCall, session, t);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, t.getMessage(), t);
                    }
                }
            } else {
                LOGGER.log(Level.WARNING, t.getMessage(), t);
            }
            this.endpointEventListener.onError(session.getId(), t);
        }
        finally {
            if (this.clusterContext != null) {
                this.clusterContext.removeSession(session.getId(), this.getEndpointPath());
                if (!CloseReason.CloseCodes.CLOSED_ABNORMALLY.equals((Object)closeReason.getCloseCode()) && !CloseReason.CloseCodes.GOING_AWAY.equals((Object)closeReason.getCloseCode())) {
                    this.clusterContext.destroyDistributedUserProperties(session.getConnectionId());
                }
            }
            session.setState(TyrusSession.State.CLOSED);
            this.webSocketToSession.remove(socket);
            this.endpointEventListener.onSessionClosed(session.getId());
            this.componentProvider.removeSession(session);
            this.sessionListener.onClose(session, closeReason);
        }
    }

    public EndpointConfig getEndpointConfig() {
        return this.configuration;
    }

    Map<Session, Future<?>> broadcast(String message) {
        return this.broadcast(message, false);
    }

    private Map<Session, Future<?>> broadcast(final String message, boolean local) {
        if (!local && this.clusterContext != null) {
            this.clusterContext.broadcastText(this.getEndpointPath(), message);
            return new HashMap();
        }
        if (this.webSocketToSession.isEmpty()) {
            return new HashMap();
        }
        TyrusWebSocket webSocket = this.webSocketToSession.keySet().iterator().next();
        TextFrame dataFrame = new TextFrame(message, false, true);
        ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
        final byte[] frame = new byte[byteBuffer.remaining()];
        byteBuffer.get(frame);
        final long payloadLength = dataFrame.getPayloadLength();
        SessionCallable broadcastCallable = new SessionCallable(){

            @Override
            public Future<?> call(TyrusWebSocket webSocket, TyrusSession session) {
                ProtocolHandler protocolHandler = webSocket.getProtocolHandler();
                if (protocolHandler.hasExtensions()) {
                    TextFrame dataFrame = new TextFrame(message, false, true);
                    ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                    byte[] tempFrame = new byte[byteBuffer.remaining()];
                    byteBuffer.get(tempFrame);
                    Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(tempFrame));
                    webSocket.getMessageEventListener().onFrameSent(TyrusFrame.FrameType.TEXT, dataFrame.getPayloadLength());
                    return frameFuture;
                }
                Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(frame));
                webSocket.getMessageEventListener().onFrameSent(TyrusFrame.FrameType.TEXT, payloadLength);
                return frameFuture;
            }
        };
        if (this.parallelBroadcastEnabled) {
            return this.executeInParallel(broadcastCallable);
        }
        HashMap futures = new HashMap();
        for (Map.Entry<TyrusWebSocket, TyrusSession> e : this.webSocketToSession.entrySet()) {
            if (!e.getValue().isOpen()) continue;
            Future<?> future = broadcastCallable.call(e.getKey(), e.getValue());
            futures.put(e.getValue(), future);
        }
        return futures;
    }

    Map<Session, Future<?>> broadcast(ByteBuffer message) {
        return this.broadcast(message, false);
    }

    private Map<Session, Future<?>> broadcast(ByteBuffer message, boolean local) {
        final byte[] byteArrayMessage = Utils.getRemainingArray(message);
        if (!local && this.clusterContext != null) {
            this.clusterContext.broadcastBinary(this.getEndpointPath(), byteArrayMessage);
            return new HashMap();
        }
        if (this.webSocketToSession.isEmpty()) {
            return new HashMap();
        }
        TyrusWebSocket webSocket = this.webSocketToSession.keySet().iterator().next();
        BinaryFrame dataFrame = new BinaryFrame(byteArrayMessage, false, true);
        ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
        final byte[] frame = new byte[byteBuffer.remaining()];
        byteBuffer.get(frame);
        final long payloadLength = dataFrame.getPayloadLength();
        SessionCallable broadcastCallable = new SessionCallable(){

            @Override
            public Future<?> call(TyrusWebSocket webSocket, TyrusSession session) {
                ProtocolHandler protocolHandler = webSocket.getProtocolHandler();
                if (protocolHandler.hasExtensions()) {
                    BinaryFrame dataFrame = new BinaryFrame(byteArrayMessage, false, true);
                    ByteBuffer byteBuffer = webSocket.getProtocolHandler().frame(dataFrame);
                    byte[] tempFrame = new byte[byteBuffer.remaining()];
                    byteBuffer.get(tempFrame);
                    Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(tempFrame));
                    webSocket.getMessageEventListener().onFrameSent(TyrusFrame.FrameType.BINARY, dataFrame.getPayloadLength());
                    return frameFuture;
                }
                Future<Frame> frameFuture = webSocket.sendRawFrame(ByteBuffer.wrap(frame));
                webSocket.getMessageEventListener().onFrameSent(TyrusFrame.FrameType.BINARY, payloadLength);
                return frameFuture;
            }
        };
        if (this.parallelBroadcastEnabled) {
            return this.executeInParallel(broadcastCallable);
        }
        HashMap futures = new HashMap();
        for (Map.Entry<TyrusWebSocket, TyrusSession> e : this.webSocketToSession.entrySet()) {
            if (!e.getValue().isOpen()) continue;
            Future<?> future = broadcastCallable.call(e.getKey(), e.getValue());
            futures.put(e.getValue(), future);
        }
        return futures;
    }

    private Map<Session, Future<?>> executeInParallel(final SessionCallable broadcastCallable) {
        final ArrayList<Map.Entry<TyrusWebSocket, TyrusSession>> sessions = new ArrayList<Map.Entry<TyrusWebSocket, TyrusSession>>();
        for (Map.Entry<TyrusWebSocket, TyrusSession> e : this.webSocketToSession.entrySet()) {
            if (!e.getValue().isOpen()) continue;
            sessions.add(e);
        }
        if (sessions.isEmpty()) {
            return new HashMap();
        }
        ExecutorService executor = ((BaseContainer)((TyrusSession)((Map.Entry)sessions.get(0)).getValue()).getContainer()).getExecutorService();
        HashMap submitFutures = new HashMap();
        int sessionCount = sessions.size();
        int maxThreadCount = sessionCount / 16 == 0 ? 1 : sessionCount / 16;
        int threadCount = Math.min(Runtime.getRuntime().availableProcessors(), maxThreadCount);
        for (int i = 0; i < threadCount; ++i) {
            final int lowerBound = (sessionCount + threadCount - 1) / threadCount * i;
            final int upperBound = Math.min((sessionCount + threadCount - 1) / threadCount * (i + 1), sessionCount);
            Future submitFuture = executor.submit(new Callable<Map<Session, Future<?>>>(){

                @Override
                public Map<Session, Future<?>> call() throws Exception {
                    HashMap futures = new HashMap();
                    for (int j = lowerBound; j < upperBound; ++j) {
                        Map.Entry e = (Map.Entry)sessions.get(j);
                        Future<?> future = broadcastCallable.call((TyrusWebSocket)e.getKey(), (TyrusSession)e.getValue());
                        futures.put((Session)e.getValue(), future);
                    }
                    return futures;
                }
            });
            submitFutures.put(submitFuture, new int[]{lowerBound, upperBound});
        }
        HashMap futures = new HashMap();
        for (Future submitFuture : submitFutures.keySet()) {
            try {
                futures.putAll((Map)submitFuture.get());
            }
            catch (InterruptedException e) {
                this.handleSubmitException(futures, sessions, (int[])submitFutures.get(submitFuture), e);
            }
            catch (ExecutionException e) {
                this.handleSubmitException(futures, sessions, (int[])submitFutures.get(submitFuture), e);
            }
        }
        return futures;
    }

    private void handleSubmitException(Map<Session, Future<?>> futures, List<Map.Entry<TyrusWebSocket, TyrusSession>> sessions, int[] bounds, Exception e) {
        for (int j = bounds[0]; j < bounds[1]; ++j) {
            TyrusFuture future = new TyrusFuture();
            future.setFailure(e);
            futures.put(sessions.get(j).getValue(), future);
        }
    }

    List<Decoder> getDecoders() {
        return this.decoders;
    }

    private Class<?> getEncoderClassType(Class<?> encoderClass) {
        if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Binary.class);
        }
        if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.Text.class);
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.BinaryStream.class);
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoderClass)) {
            return ReflectionHelper.getClassType(encoderClass, Encoder.TextStream.class);
        }
        return null;
    }

    private Class<?> getDecoderClassType(Class<?> decoderClass) {
        if (Decoder.Binary.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Binary.class);
        }
        if (Decoder.Text.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.Text.class);
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.BinaryStream.class);
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoderClass)) {
            return ReflectionHelper.getClassType(decoderClass, Decoder.TextStream.class);
        }
        return null;
    }

    final boolean upgrade(UpgradeRequest request) throws HandshakeException {
        String upgradeHeader = request.getHeader("Upgrade");
        if (request.getHeaders().get("Upgrade") != null && "websocket".equalsIgnoreCase(upgradeHeader)) {
            if (!(this.configuration instanceof ServerEndpointConfig)) {
                return false;
            }
            if (this.configurator.checkOrigin(request.getHeader("Origin"))) {
                return true;
            }
            throw new HandshakeException(403, LocalizationMessages.ORIGIN_NOT_VERIFIED());
        }
        return false;
    }

    TyrusWebSocket createSocket(ProtocolHandler handler) {
        return new TyrusWebSocket(handler, this);
    }

    boolean onError(TyrusWebSocket socket, Throwable t) {
        Logger.getLogger(TyrusEndpointWrapper.class.getName()).log(Level.WARNING, LocalizationMessages.UNEXPECTED_ERROR_CONNECTION_CLOSE(), t);
        return true;
    }

    void onHandShakeResponse(UpgradeRequest request, UpgradeResponse response) {
        EndpointConfig configuration = this.getEndpointConfig();
        if (configuration instanceof ServerEndpointConfig) {
            ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)configuration;
            serverEndpointConfig.getConfigurator().modifyHandshake(serverEndpointConfig, this.createHandshakeRequest(request), (HandshakeResponse)response);
        }
    }

    private HandshakeRequest createHandshakeRequest(UpgradeRequest webSocketRequest) {
        if (webSocketRequest instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)webSocketRequest;
            requestContext.lock();
            return requestContext;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TyrusEndpointWrapper");
        sb.append("{endpointClass=").append(this.endpointClass);
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", contextPath='").append(this.contextPath).append('\'');
        sb.append(", endpointPath=").append(this.endpointPath);
        sb.append(", encoders=[");
        boolean first = true;
        for (CoderWrapper<Encoder> coderWrapper : this.encoders) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(coderWrapper);
        }
        sb.append("]");
        sb.append(", decoders=[");
        first = true;
        for (CoderWrapper<Encoder> coderWrapper : this.decoders) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(coderWrapper);
        }
        sb.append("]");
        sb.append('}');
        return sb.toString();
    }

    private static interface SessionCallable {
        public Future<?> call(TyrusWebSocket var1, TyrusSession var2);
    }

    public static abstract class SessionListener {
        public OnOpenResult onOpen(TyrusSession session) {
            return OnOpenResult.SESSION_ALLOWED;
        }

        public void onClose(TyrusSession session, CloseReason closeReason) {
        }

        public static enum OnOpenResult {
            SESSION_ALLOWED,
            MAX_SESSIONS_PER_APP_EXCEEDED,
            MAX_SESSIONS_PER_REMOTE_ADDR_EXCEEDED;

        }
    }
}

