/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.glassfish.tyrus.core.AnnotatedEndpoint;
import org.glassfish.tyrus.core.Beta;
import org.glassfish.tyrus.core.ComponentProviderService;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.ErrorCollector;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusSession;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.cluster.ClusterContext;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.core.monitoring.ApplicationEventListener;
import org.glassfish.tyrus.core.monitoring.EndpointEventListener;
import org.glassfish.tyrus.core.monitoring.MessageEventListener;
import org.glassfish.tyrus.core.uri.Match;
import org.glassfish.tyrus.core.wsadl.model.Application;
import org.glassfish.tyrus.core.wsadl.model.Endpoint;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.WebSocketEngine;
import org.glassfish.tyrus.spi.Writer;

public class TyrusWebSocketEngine
implements WebSocketEngine {
    public static final String INCOMING_BUFFER_SIZE = "org.glassfish.tyrus.incomingBufferSize";
    public static final String MAX_SESSIONS_PER_APP = "org.glassfish.tyrus.maxSessionsPerApp";
    public static final String MAX_SESSIONS_PER_REMOTE_ADDR = "org.glassfish.tyrus.maxSessionsPerRemoteAddr";
    public static final String TRACING_TYPE = "org.glassfish.tyrus.server.tracingType";
    public static final String TRACING_THRESHOLD = "org.glassfish.tyrus.server.tracingThreshold";
    @Beta
    public static final String WSADL_SUPPORT = "org.glassfish.tyrus.server.wsadl";
    public static final String PARALLEL_BROADCAST_ENABLED = "org.glassfish.tyrus.server.parallelBroadcastEnabled";
    private static final int BUFFER_STEP_SIZE = 256;
    private static final Logger LOGGER = Logger.getLogger(TyrusWebSocketEngine.class.getName());
    private static final WebSocketEngine.UpgradeInfo NOT_APPLICABLE_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.NOT_APPLICABLE);
    private static final WebSocketEngine.UpgradeInfo HANDSHAKE_FAILED_UPGRADE_INFO = new NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus.HANDSHAKE_FAILED);
    private static final TyrusEndpointWrapper.SessionListener NO_OP_SESSION_LISTENER = new TyrusEndpointWrapper.SessionListener(){};
    private final Set<TyrusEndpointWrapper> endpointWrappers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ComponentProviderService componentProviderService = ComponentProviderService.create();
    private final WebSocketContainer webSocketContainer;
    private int incomingBufferSize = 0x40000B;
    private final ClusterContext clusterContext;
    private final ApplicationEventListener applicationEventListener;
    private final TyrusEndpointWrapper.SessionListener sessionListener;
    private final Boolean parallelBroadcastEnabled;
    private final DebugContext.TracingType tracingType;
    private final DebugContext.TracingThreshold tracingThreshold;

    public static TyrusWebSocketEngineBuilder builder(WebSocketContainer webSocketContainer) {
        return new TyrusWebSocketEngineBuilder(webSocketContainer);
    }

    private TyrusWebSocketEngine(WebSocketContainer webSocketContainer, Integer incomingBufferSize, ClusterContext clusterContext, ApplicationEventListener applicationEventListener, final Integer maxSessionsPerApp, final Integer maxSessionsPerRemoteAddr, DebugContext.TracingType tracingType, DebugContext.TracingThreshold tracingThreshold, Boolean parallelBroadcastEnabled) {
        if (incomingBufferSize != null) {
            this.incomingBufferSize = incomingBufferSize;
        }
        this.webSocketContainer = webSocketContainer;
        this.clusterContext = clusterContext;
        this.parallelBroadcastEnabled = parallelBroadcastEnabled;
        if (applicationEventListener == null) {
            this.applicationEventListener = ApplicationEventListener.NO_OP;
        } else {
            LOGGER.config("Application event listener " + applicationEventListener.getClass().getName() + " registered");
            this.applicationEventListener = applicationEventListener;
        }
        LOGGER.config("Incoming buffer size: " + this.incomingBufferSize);
        LOGGER.config("Max sessions per app: " + maxSessionsPerApp);
        LOGGER.config("Max sessions per remote address: " + maxSessionsPerRemoteAddr);
        LOGGER.config("Parallel broadcast enabled: " + (parallelBroadcastEnabled == null || parallelBroadcastEnabled != false));
        this.tracingType = tracingType;
        this.tracingThreshold = tracingThreshold;
        this.sessionListener = maxSessionsPerApp == null && maxSessionsPerRemoteAddr == null ? NO_OP_SESSION_LISTENER : new TyrusEndpointWrapper.SessionListener(){
            private final AtomicInteger counter = new AtomicInteger(0);
            private final Object counterLock = new Object();
            private final Map<String, AtomicInteger> remoteAddressCounters = new HashMap<String, AtomicInteger>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TyrusEndpointWrapper.SessionListener.OnOpenResult onOpen(TyrusSession session) {
                Map<String, AtomicInteger> map;
                if (maxSessionsPerApp != null) {
                    map = this.counterLock;
                    synchronized (map) {
                        if (this.counter.get() >= maxSessionsPerApp) {
                            return TyrusEndpointWrapper.SessionListener.OnOpenResult.MAX_SESSIONS_PER_APP_EXCEEDED;
                        }
                        this.counter.incrementAndGet();
                    }
                }
                if (maxSessionsPerRemoteAddr != null) {
                    map = this.remoteAddressCounters;
                    synchronized (map) {
                        AtomicInteger remoteAddressCounter = this.remoteAddressCounters.get(session.getRemoteAddr());
                        if (remoteAddressCounter == null) {
                            remoteAddressCounter = new AtomicInteger(1);
                            this.remoteAddressCounters.put(session.getRemoteAddr(), remoteAddressCounter);
                        } else {
                            if (remoteAddressCounter.get() >= maxSessionsPerRemoteAddr) {
                                return TyrusEndpointWrapper.SessionListener.OnOpenResult.MAX_SESSIONS_PER_REMOTE_ADDR_EXCEEDED;
                            }
                            remoteAddressCounter.incrementAndGet();
                        }
                    }
                }
                return TyrusEndpointWrapper.SessionListener.OnOpenResult.SESSION_ALLOWED;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClose(TyrusSession session, CloseReason closeReason) {
                Map<String, AtomicInteger> map;
                if (maxSessionsPerApp != null) {
                    map = this.counterLock;
                    synchronized (map) {
                        this.counter.decrementAndGet();
                    }
                }
                if (maxSessionsPerRemoteAddr != null) {
                    map = this.remoteAddressCounters;
                    synchronized (map) {
                        int remoteAddressCounter = this.remoteAddressCounters.get(session.getRemoteAddr()).decrementAndGet();
                        if (remoteAddressCounter == 0) {
                            this.remoteAddressCounters.remove(session.getRemoteAddr());
                        }
                    }
                }
            }
        };
    }

    private static ProtocolHandler loadHandler(UpgradeRequest request) {
        for (Version version : Version.values()) {
            if (!version.validate(request)) continue;
            return version.createHandler(false);
        }
        return null;
    }

    private static void handleUnsupportedVersion(UpgradeRequest request, UpgradeResponse response) {
        response.setStatus(426);
        response.getHeaders().put("Sec-WebSocket-Version", Arrays.asList(Version.getSupportedWireProtocolVersions()));
    }

    TyrusEndpointWrapper getEndpointWrapper(UpgradeRequest request, DebugContext debugContext) throws HandshakeException {
        if (this.endpointWrappers.isEmpty()) {
            return null;
        }
        String requestPath = request.getRequestUri();
        for (Match m : Match.getAllMatches(requestPath, this.endpointWrappers, debugContext)) {
            TyrusEndpointWrapper endpointWrapper = m.getEndpointWrapper();
            for (String name : m.getParameterNames()) {
                request.getParameterMap().put(name, Arrays.asList(m.getParameterValue(name)));
            }
            if (!endpointWrapper.upgrade(request)) continue;
            debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Endpoint selected as a match to the handshake URI: ", endpointWrapper.getEndpointPath());
            debugContext.appendLogMessage(LOGGER, Level.FINER, DebugContext.Type.MESSAGE_IN, "Target endpoint: ", endpointWrapper);
            return endpointWrapper;
        }
        return null;
    }

    public WebSocketEngine.UpgradeInfo upgrade(UpgradeRequest request, UpgradeResponse response) {
        TyrusEndpointWrapper endpointWrapper;
        DebugContext debugContext = this.createDebugContext(request);
        if (LOGGER.isLoggable(Level.FINE)) {
            debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Received handshake request:\n" + Utils.stringifyUpgradeRequest(request));
        }
        try {
            endpointWrapper = this.getEndpointWrapper(request, debugContext);
        }
        catch (HandshakeException e) {
            return this.handleHandshakeException(e, response);
        }
        if (endpointWrapper != null) {
            ProtocolHandler protocolHandler = TyrusWebSocketEngine.loadHandler(request);
            if (protocolHandler == null) {
                TyrusWebSocketEngine.handleUnsupportedVersion(request, response);
                debugContext.appendTraceMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, "Upgrade request contains unsupported version of Websocket protocol");
                if (LOGGER.isLoggable(Level.FINE)) {
                    debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, "Sending handshake response:\n" + Utils.stringifyUpgradeResponse(response));
                }
                response.getHeaders().putAll(debugContext.getTracingHeaders());
                debugContext.flush();
                return HANDSHAKE_FAILED_UPGRADE_INFO;
            }
            ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
                private final Map<String, Object> properties = new HashMap<String, Object>();

                @Override
                public Map<String, Object> getProperties() {
                    return this.properties;
                }
            };
            try {
                protocolHandler.handshake(endpointWrapper, request, response, extensionContext);
            }
            catch (HandshakeException e) {
                return this.handleHandshakeException(e, response);
            }
            this.logExtensionsAndSubprotocol(protocolHandler, debugContext);
            if (this.clusterContext != null && request.getHeaders().get("tyrus-cluster-connection-id") == null) {
                String connectionId = this.clusterContext.createConnectionId();
                response.getHeaders().put("tyrus-cluster-connection-id", Collections.singletonList(connectionId));
                debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Connection ID: ", connectionId);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, "Sending handshake response:\n" + Utils.stringifyUpgradeResponse(response) + "\n");
            }
            response.getHeaders().putAll(debugContext.getTracingHeaders());
            return new SuccessfulUpgradeInfo(endpointWrapper, protocolHandler, this.incomingBufferSize, request, response, extensionContext, debugContext);
        }
        response.setStatus(500);
        response.getHeaders().putAll(debugContext.getTracingHeaders());
        debugContext.flush();
        return NOT_APPLICABLE_UPGRADE_INFO;
    }

    private void logExtensionsAndSubprotocol(ProtocolHandler protocolHandler, DebugContext debugContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("Using negotiated extensions: [");
        boolean isFirst = true;
        for (Extension extension : protocolHandler.getExtensions()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(extension.getName());
        }
        sb.append("]");
        debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Using negotiated extensions: ", sb);
        debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Using negotiated subprotocol: ", protocolHandler.getSubProtocol());
    }

    private DebugContext createDebugContext(UpgradeRequest upgradeRequest) {
        String thresholdHeader = upgradeRequest.getHeader("X-Tyrus-Tracing-Threshold");
        DebugContext.TracingThreshold threshold = this.tracingThreshold;
        Exception thresholdHeaderParsingError = null;
        if (thresholdHeader != null) {
            try {
                threshold = DebugContext.TracingThreshold.valueOf(thresholdHeader);
            }
            catch (Exception e) {
                thresholdHeaderParsingError = e;
            }
        }
        DebugContext debugContext = this.tracingType == DebugContext.TracingType.ALL || this.tracingType == DebugContext.TracingType.ON_DEMAND && upgradeRequest.getHeader("X-Tyrus-Tracing-Accept") != null ? new DebugContext(threshold) : new DebugContext();
        if (thresholdHeaderParsingError != null) {
            debugContext.appendTraceMessageWithThrowable(LOGGER, Level.WARNING, DebugContext.Type.MESSAGE_IN, thresholdHeaderParsingError, "An error occurred while parsing ", "X-Tyrus-Tracing-Threshold", " header:", thresholdHeaderParsingError.getMessage());
        }
        return debugContext;
    }

    private WebSocketEngine.UpgradeInfo handleHandshakeException(HandshakeException handshakeException, UpgradeResponse response) {
        LOGGER.log(Level.CONFIG, handshakeException.getMessage(), handshakeException);
        response.setStatus(handshakeException.getHttpStatusCode());
        return HANDSHAKE_FAILED_UPGRADE_INFO;
    }

    public void setIncomingBufferSize(int incomingBufferSize) {
        this.incomingBufferSize = incomingBufferSize;
    }

    private void register(TyrusEndpointWrapper endpointWrapper) throws DeploymentException {
        this.checkPath(endpointWrapper);
        LOGGER.log(Level.FINER, "Registered endpoint: " + endpointWrapper);
        this.endpointWrappers.add(endpointWrapper);
    }

    public void register(Class<?> endpointClass, String contextPath) throws DeploymentException {
        EndpointConfig config;
        AnnotatedEndpoint endpoint;
        ErrorCollector collector = new ErrorCollector();
        EndpointEventListenerWrapper endpointEventListenerWrapper = new EndpointEventListenerWrapper();
        TyrusEndpointWrapper endpointWrapper = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProviderService, true, this.incomingBufferSize, collector, endpointEventListenerWrapper)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null, this.sessionListener, this.clusterContext, (EndpointEventListener)endpointEventListenerWrapper, this.parallelBroadcastEnabled);
        if (!collector.isEmpty()) {
            throw collector.composeComprehensiveException();
        }
        this.register(endpointWrapper);
        String endpointPath = config instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getPath() : null;
        EndpointEventListener endpointEventListener = this.applicationEventListener.onEndpointRegistered(endpointPath, endpointClass);
        endpointEventListenerWrapper.setEndpointEventListener(endpointEventListener);
    }

    public void register(ServerEndpointConfig serverConfig, String contextPath) throws DeploymentException {
        TyrusEndpointWrapper endpointWrapper;
        Class endpointClass;
        Class parent = endpointClass = serverConfig.getEndpointClass();
        boolean isEndpointClass = false;
        do {
            if (!(parent = parent.getSuperclass()).equals(javax.websocket.Endpoint.class)) continue;
            isEndpointClass = true;
        } while (!parent.equals(Object.class));
        EndpointEventListenerWrapper endpointEventListenerWrapper = new EndpointEventListenerWrapper();
        if (isEndpointClass) {
            endpointWrapper = new TyrusEndpointWrapper(endpointClass, (EndpointConfig)serverConfig, this.componentProviderService, this.webSocketContainer, contextPath, serverConfig.getConfigurator(), this.sessionListener, this.clusterContext, (EndpointEventListener)endpointEventListenerWrapper, this.parallelBroadcastEnabled);
        } else {
            EndpointConfig config;
            AnnotatedEndpoint endpoint;
            ErrorCollector collector = new ErrorCollector();
            endpointWrapper = new TyrusEndpointWrapper(endpoint, config, this.componentProviderService, this.webSocketContainer, contextPath, (config = (endpoint = AnnotatedEndpoint.fromClass(endpointClass, this.componentProviderService, true, this.incomingBufferSize, collector, endpointEventListenerWrapper)).getEndpointConfig()) instanceof ServerEndpointConfig ? ((ServerEndpointConfig)config).getConfigurator() : null, this.sessionListener, this.clusterContext, (EndpointEventListener)endpointEventListenerWrapper, this.parallelBroadcastEnabled);
            if (!collector.isEmpty()) {
                throw collector.composeComprehensiveException();
            }
        }
        this.register(endpointWrapper);
        EndpointEventListener endpointEventListener = this.applicationEventListener.onEndpointRegistered(serverConfig.getPath(), endpointClass);
        endpointEventListenerWrapper.setEndpointEventListener(endpointEventListener);
    }

    private void checkPath(TyrusEndpointWrapper endpoint) throws DeploymentException {
        for (TyrusEndpointWrapper endpointWrapper : this.endpointWrappers) {
            if (!Match.isEquivalent(endpoint.getEndpointPath(), endpointWrapper.getEndpointPath())) continue;
            throw new DeploymentException(LocalizationMessages.EQUIVALENT_PATHS(endpoint.getEndpointPath(), endpointWrapper.getEndpointPath()));
        }
    }

    public void unregister(TyrusEndpointWrapper endpointWrapper) {
        this.endpointWrappers.remove(endpointWrapper);
        this.applicationEventListener.onEndpointUnregistered(endpointWrapper.getEndpointPath());
    }

    public ApplicationEventListener getApplicationEventListener() {
        return this.applicationEventListener;
    }

    @Beta
    public Application getWsadlApplication() {
        Application application = new Application();
        for (TyrusEndpointWrapper wrapper : this.endpointWrappers) {
            Endpoint endpoint = new Endpoint();
            endpoint.setPath(wrapper.getServerEndpointPath());
            application.getEndpoint().add(endpoint);
        }
        return application;
    }

    private static class EndpointEventListenerWrapper
    implements EndpointEventListener {
        private volatile EndpointEventListener endpointEventListener = EndpointEventListener.NO_OP;

        private EndpointEventListenerWrapper() {
        }

        void setEndpointEventListener(EndpointEventListener endpointEventListener) {
            this.endpointEventListener = endpointEventListener;
        }

        @Override
        public MessageEventListener onSessionOpened(String sessionId) {
            return this.endpointEventListener.onSessionOpened(sessionId);
        }

        @Override
        public void onSessionClosed(String sessionId) {
            this.endpointEventListener.onSessionClosed(sessionId);
        }

        @Override
        public void onError(String sessionId, Throwable t) {
            this.endpointEventListener.onError(sessionId, t);
        }
    }

    public static class TyrusWebSocketEngineBuilder {
        private final WebSocketContainer webSocketContainer;
        private Integer incomingBufferSize = null;
        private ClusterContext clusterContext = null;
        private ApplicationEventListener applicationEventListener = null;
        private Integer maxSessionsPerApp = null;
        private Integer maxSessionsPerRemoteAddr = null;
        private DebugContext.TracingType tracingType = null;
        private DebugContext.TracingThreshold tracingThreshold = null;
        private Boolean parallelBroadcastEnabled = null;

        public TyrusWebSocketEngine build() {
            if (this.maxSessionsPerApp != null && this.maxSessionsPerApp <= 0) {
                LOGGER.log(Level.CONFIG, "Invalid configuration value org.glassfish.tyrus.maxSessionsPerApp (" + this.maxSessionsPerApp + "), expected value greater than 0.");
                this.maxSessionsPerApp = null;
            }
            if (this.maxSessionsPerRemoteAddr != null && this.maxSessionsPerRemoteAddr <= 0) {
                LOGGER.log(Level.CONFIG, "Invalid configuration value org.glassfish.tyrus.maxSessionsPerRemoteAddr (" + this.maxSessionsPerRemoteAddr + "), expected value greater than 0.");
                this.maxSessionsPerRemoteAddr = null;
            }
            if (this.maxSessionsPerApp != null && this.maxSessionsPerRemoteAddr != null && this.maxSessionsPerApp < this.maxSessionsPerRemoteAddr) {
                LOGGER.log(Level.FINE, String.format("Invalid configuration - value %s (%d) cannot be greater then %s (%d).", TyrusWebSocketEngine.MAX_SESSIONS_PER_REMOTE_ADDR, this.maxSessionsPerRemoteAddr, TyrusWebSocketEngine.MAX_SESSIONS_PER_APP, this.maxSessionsPerApp));
            }
            return new TyrusWebSocketEngine(this.webSocketContainer, this.incomingBufferSize, this.clusterContext, this.applicationEventListener, this.maxSessionsPerApp, this.maxSessionsPerRemoteAddr, this.tracingType, this.tracingThreshold, this.parallelBroadcastEnabled);
        }

        TyrusWebSocketEngineBuilder(WebSocketContainer webSocketContainer) {
            if (webSocketContainer == null) {
                throw new NullPointerException();
            }
            this.webSocketContainer = webSocketContainer;
        }

        public TyrusWebSocketEngineBuilder applicationEventListener(ApplicationEventListener applicationEventListener) {
            this.applicationEventListener = applicationEventListener;
            return this;
        }

        public TyrusWebSocketEngineBuilder incomingBufferSize(Integer incomingBufferSize) {
            this.incomingBufferSize = incomingBufferSize;
            return this;
        }

        public TyrusWebSocketEngineBuilder clusterContext(ClusterContext clusterContext) {
            this.clusterContext = clusterContext;
            return this;
        }

        public TyrusWebSocketEngineBuilder maxSessionsPerApp(Integer maxSessionsPerApp) {
            this.maxSessionsPerApp = maxSessionsPerApp;
            return this;
        }

        public TyrusWebSocketEngineBuilder maxSessionsPerRemoteAddr(Integer maxSessionsPerRemoteAddr) {
            this.maxSessionsPerRemoteAddr = maxSessionsPerRemoteAddr;
            return this;
        }

        public TyrusWebSocketEngineBuilder tracingType(DebugContext.TracingType tracingType) {
            this.tracingType = tracingType;
            return this;
        }

        public TyrusWebSocketEngineBuilder tracingThreshold(DebugContext.TracingThreshold tracingThreshold) {
            this.tracingThreshold = tracingThreshold;
            return this;
        }

        public TyrusWebSocketEngineBuilder parallelBroadcastEnabled(Boolean parallelBroadcastEnabled) {
            this.parallelBroadcastEnabled = parallelBroadcastEnabled;
            return this;
        }
    }

    static class TyrusConnection
    implements Connection {
        private final ReadHandler readHandler;
        private final Writer writer;
        private final Connection.CloseListener closeListener;
        private final TyrusWebSocket socket;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private final List<Extension> extensions;

        TyrusConnection(TyrusEndpointWrapper endpointWrapper, ProtocolHandler protocolHandler, int incomingBufferSize, Writer writer, Connection.CloseListener closeListener, UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, ExtendedExtension.ExtensionContext extensionContext, DebugContext debugContext) {
            protocolHandler.setWriter(writer);
            this.extensions = protocolHandler.getExtensions();
            this.socket = endpointWrapper.createSocket(protocolHandler);
            List connectionIdHeader = (List)upgradeRequest.getHeaders().get("tyrus-cluster-connection-id");
            String connectionId = connectionIdHeader != null && connectionIdHeader.size() == 1 ? (String)connectionIdHeader.get(0) : upgradeResponse.getFirstHeaderValue("tyrus-cluster-connection-id");
            this.socket.onConnect(upgradeRequest, protocolHandler.getSubProtocol(), this.extensions, connectionId, debugContext);
            this.readHandler = new TyrusReadHandler(protocolHandler, this.socket, endpointWrapper, incomingBufferSize, extensionContext, debugContext);
            this.writer = writer;
            this.closeListener = closeListener;
            this.extensionContext = extensionContext;
        }

        public ReadHandler getReadHandler() {
            return this.readHandler;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public Connection.CloseListener getCloseListener() {
            return this.closeListener;
        }

        public void close(CloseReason reason) {
            if (!this.socket.isConnected()) {
                return;
            }
            this.socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
            for (Extension extension : this.extensions) {
                if (!(extension instanceof ExtendedExtension)) continue;
                try {
                    ((ExtendedExtension)extension).destroy(this.extensionContext);
                }
                catch (Throwable t) {}
            }
        }
    }

    private static class SuccessfulUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final TyrusEndpointWrapper endpointWrapper;
        private final ProtocolHandler protocolHandler;
        private final int incomingBufferSize;
        private final UpgradeRequest upgradeRequest;
        private final UpgradeResponse upgradeResponse;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private final DebugContext debugContext;

        SuccessfulUpgradeInfo(TyrusEndpointWrapper endpointWrapper, ProtocolHandler protocolHandler, int incomingBufferSize, UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse, ExtendedExtension.ExtensionContext extensionContext, DebugContext debugContext) {
            this.endpointWrapper = endpointWrapper;
            this.protocolHandler = protocolHandler;
            this.incomingBufferSize = incomingBufferSize;
            this.upgradeRequest = upgradeRequest;
            this.upgradeResponse = upgradeResponse;
            this.extensionContext = extensionContext;
            this.debugContext = debugContext;
        }

        public WebSocketEngine.UpgradeStatus getStatus() {
            return WebSocketEngine.UpgradeStatus.SUCCESS;
        }

        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            TyrusConnection tyrusConnection = new TyrusConnection(this.endpointWrapper, this.protocolHandler, this.incomingBufferSize, writer, closeListener, this.upgradeRequest, this.upgradeResponse, this.extensionContext, this.debugContext);
            this.debugContext.flush();
            return tyrusConnection;
        }
    }

    private static class NoConnectionUpgradeInfo
    implements WebSocketEngine.UpgradeInfo {
        private final WebSocketEngine.UpgradeStatus status;

        NoConnectionUpgradeInfo(WebSocketEngine.UpgradeStatus status) {
            this.status = status;
        }

        public WebSocketEngine.UpgradeStatus getStatus() {
            return this.status;
        }

        public Connection createConnection(Writer writer, Connection.CloseListener closeListener) {
            return null;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final ProtocolHandler protocolHandler;
        private final TyrusWebSocket socket;
        private final TyrusEndpointWrapper endpointWrapper;
        private final int incomingBufferSize;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private final DebugContext debugContext;
        private volatile ByteBuffer buffer;

        private TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, TyrusEndpointWrapper endpointWrapper, int incomingBufferSize, ExtendedExtension.ExtensionContext extensionContext, DebugContext debugContext) {
            this.extensionContext = extensionContext;
            this.protocolHandler = protocolHandler;
            this.socket = socket;
            this.endpointWrapper = endpointWrapper;
            this.incomingBufferSize = incomingBufferSize;
            this.debugContext = debugContext;
        }

        public void handle(ByteBuffer data) {
            block12: {
                try {
                    if (data == null || !data.hasRemaining()) break block12;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException(LocalizationMessages.BUFFER_OVERFLOW());
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame incomingFrame;
                        if ((incomingFrame = this.protocolHandler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        Frame frame = incomingFrame;
                        for (Extension extension : this.protocolHandler.getExtensions()) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                this.debugContext.appendLogMessageWithThrowable(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, t, "Extension '", extension.getName(), "' threw an exception during processIncoming method invocation: ", t.getMessage());
                            }
                        }
                        this.protocolHandler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    this.debugContext.appendLogMessageWithThrowable(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, e, e.getMessage());
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    this.debugContext.appendLogMessageWithThrowable(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, e, e.getMessage());
                    if (!this.endpointWrapper.onError(this.socket, e)) break block12;
                    if (message != null && message.length() > 123) {
                        message = message.substring(0, 123);
                    }
                    this.socket.onClose(new CloseFrame(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, message)));
                }
            }
        }
    }
}

