/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.anttask;

import com.objectriver.cloudcompiler.client.CloudCompilerClient;
import com.objectriver.compiler.driver.DriverArguments;
import com.objectriver.compiler.util.FileName;
import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.util.FileHelper;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.asserts.AssertFailedError;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceFactory;
import com.objectriver.runtime.util.resource.ResourceHelper;
import com.objectriver.runtime.util.resource.ResourceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Parameter;

public class CloudCompilerClientTask
extends Task {
    protected String user = null;
    protected String password = null;
    protected File workDir;
    protected File srcDir;
    protected File outDir;
    protected String host = null;
    protected Resource tmplDir = null;
    protected File modelFile;
    protected int nIncludes = 0;
    protected Resource[] includes = ResourceHelper.emptyResourceArray;
    protected int nDefines = 0;
    protected String[] Defines = StringConst.emptyStringArray;
    protected boolean debug = false;
    protected boolean force = false;
    protected String lang = null;
    protected int nProjects = 0;
    protected String[] projects = null;
    protected CloudCompilerClient driver = null;
    private LinkedList params = null;

    @Override
    public void init() {
    }

    @Override
    public void execute() throws BuildException {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.modelFile == null) {
            throw new BuildException("Model not specified?", this.getLocation());
        }
        FileName project = new FileName(this.modelFile.getPath());
        argsList.add(this.modelFile.toString());
        if (this.srcDir == null) {
            this.srcDir = FileHelper.getSrcDir(project.getParentFile());
        }
        if (this.outDir == null) {
            this.outDir = this.srcDir;
        }
        if (this.workDir == null) {
            this.workDir = this.outDir;
        }
        argsList.add("-S" + this.srcDir.toString());
        argsList.add("-O" + this.outDir.toString());
        argsList.add("-W" + this.workDir.toString());
        if (this.host != null) {
            argsList.add("-H" + this.host);
        }
        if (this.user != null) {
            argsList.add("-U");
            argsList.add(this.user);
            argsList.add(this.password);
        }
        if (this.params != null) {
            for (Parameter param : this.params) {
                if (!param.getName().equals("project")) continue;
                this.setProject(param.getValue());
                argsList.add("-P" + param.getValue());
            }
        }
        try {
            String[] defines = DriverArguments.checkDefines(this.Defines);
            if (this.nProjects != 0) {
                for (String p : this.projects) {
                    if (!p.startsWith("-P")) {
                        p = "-P" + p;
                    }
                    argsList.add(p);
                }
            }
            for (String define : defines) {
                if (!define.startsWith("-D")) {
                    define = "-D" + define;
                }
                argsList.add(define);
            }
            for (Resource include : this.includes) {
                argsList.add("-I" + include.toString());
            }
            CloudCompilerClient.execute(argsList.toArray(new String[0]), true);
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (ClassCastException e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (AssertFailedError e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.err);
            throw new BuildException(e);
        }
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setTmplDir(String tmplDir) {
        try {
            this.tmplDir = ResourceFactory.valueOf(tmplDir, ResourceType.File);
        }
        catch (MalformedURLException e) {
            Assert.fail("Malformed Url Exception:" + tmplDir);
        }
        catch (FileNotFoundException e) {
            Assert.fail("Include path not found:" + tmplDir);
        }
    }

    public void setModel(File model) {
        this.modelFile = model;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setP(String p) {
        String[] projects;
        if (p.startsWith("-P")) {
            p = p.substring(2);
        }
        for (String pxml : projects = p.split(";")) {
            this.setProject(pxml);
        }
    }

    public void setProject(String projectXml) {
        switch (this.nProjects) {
            case 0: {
                this.projects = new String[1];
                break;
            }
            default: {
                String[] newProjects = new String[this.nProjects + 1];
                System.arraycopy(this.projects, 0, newProjects, 0, this.nProjects);
                this.projects = newProjects;
            }
        }
        this.projects[this.nProjects++] = projectXml;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Parameter createParameter() {
        return new Parameter();
    }

    public Parameter createParam() {
        Parameter param = new Parameter();
        if (this.params == null) {
            this.params = new LinkedList();
        }
        this.params.add(param);
        return param;
    }

    public void setI(String includeDir) {
        try {
            switch (this.nIncludes) {
                case 0: {
                    this.includes = new Resource[1];
                    break;
                }
                default: {
                    Resource[] newIncludes = new Resource[this.nIncludes + 1];
                    System.arraycopy(this.includes, 0, newIncludes, 0, this.nIncludes);
                    this.includes = newIncludes;
                }
            }
            this.includes[this.nIncludes++] = ResourceFactory.valueOf(includeDir, ResourceType.File);
        }
        catch (MalformedURLException e) {
            Assert.fail("Malformed Url Exception:" + includeDir);
        }
        catch (FileNotFoundException e) {
            Assert.fail("Include path not found:" + includeDir);
        }
    }

    public void setD(String d) {
        String[] defines;
        if (d.startsWith("-D")) {
            d = d.substring(2);
        }
        for (String define : defines = d.split(";")) {
            switch (this.nDefines) {
                case 0: {
                    this.Defines = new String[1];
                    break;
                }
                default: {
                    String[] newDefines = new String[this.nDefines + 1];
                    System.arraycopy(this.Defines, 0, newDefines, 0, this.nDefines);
                    this.Defines = newDefines;
                }
            }
            this.Defines[this.nDefines++] = define;
        }
    }

    public void setU(String up) {
        String[] userpassword = up.split(";");
        this.user = userpassword[0];
        this.password = userpassword.length == 2 ? userpassword[1] : "guest";
    }

    public static void main(String[] args) {
        CloudCompilerClientTask task = new CloudCompilerClientTask();
        task.setModel(new File("model/hello.rest"));
        task.setSrcDir(new File("./src"));
        task.setWorkDir(new File("./"));
        task.setOutDir(new File("./"));
        task.setU("steve@objectriver.net");
        task.execute();
    }
}

