/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client;

import com.objectriver.cloudcompiler.client.CloudCClientCustom;
import com.objectriver.cloudcompiler.client.exception.PluginCloudCompilerException;
import com.objectriver.cloudcompiler.client.exception.PluginSyntaxException;
import com.objectriver.cloudcompiler.client.util.location_picker.LocationPicker;
import com.objectriver.cloudcompiler.cloudc.common.CloudCLogger;
import com.objectriver.cloudcompiler.cloudc.common.beans.CloudCompilerException;
import com.objectriver.cloudcompiler.cloudc.common.enums.ExceptionLevel;
import com.objectriver.cloudcompiler.cloudc.common.enums.FileStat;
import com.objectriver.cloudcompiler.common.files.FileTree;
import com.objectriver.cloudcompiler.common.files.FileTreeException;
import com.objectriver.cloudcompiler.common.zip.ZipStream;
import com.objectriver.compiler.cpp.Cpp;
import com.objectriver.compiler.driver.ArgumentParser;
import com.objectriver.compiler.driver.DriverArguments;
import com.objectriver.compiler.driver.exceptions.ArgumentParserException;
import com.objectriver.compiler.driver.exceptions.SyntaxException;
import com.objectriver.compiler.util.FileName;
import com.objectriver.runtime.RuntimeClassLoader;
import com.objectriver.runtime.util.ArrayHelper;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.FileHelper;
import com.objectriver.runtime.util.Pair;
import com.objectriver.runtime.util.SimpleStringCipher;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.FileResource;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.json.stream.JsonParsingException;
import javax.websocket.DeploymentException;
import org.apache.commons.validator.routines.EmailValidator;

public class CloudCompilerClient
extends CloudCClientCustom {
    public static final String usage = "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]";
    public static final String usage2 = "      Rest[-Dlang=java|node|apex|angular|...]";
    public static final String usage3 = "      Rest|WebSocket: [-clientonly -serveronly]";
    private boolean anttask = false;

    public static void main(String[] args) {
        try {
            List<String> console = CloudCompilerClient.execute(args);
            for (String line : console) {
                System.out.println(line);
            }
        }
        catch (SyntaxException ex) {
            System.out.println(ex.getMessage());
            System.err.println(ex.getMessage());
        }
    }

    public static List<String> execute(String[] args) throws SyntaxException, CloudCompilerException {
        return CloudCompilerClient.execute(args, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> execute(String[] args, boolean anttask) throws SyntaxException, CloudCompilerException {
        CloudCompilerClient client = null;
        try {
            String home;
            String pw;
            Path currentRelativePath = Paths.get("", new String[0]);
            String s = currentRelativePath.toAbsolutePath().toString();
            if (args.length == 0) {
                throw new PluginSyntaxException(new SyntaxException("No arguments? ", usage), new ArrayList<String>());
            }
            for (int ii = 0; ii < args.length; ++ii) {
                args[ii] = args[ii].replaceAll("\\\\", "/");
            }
            String command = "CloudCompilerClient: ";
            for (String arg : args) {
                command = command + arg + " ";
            }
            System.out.println(command);
            DriverArguments driver = new DriverArguments();
            driver.setCloudCompilerClient(true);
            driver.driverName = "CloudCompiler";
            ArgumentParser parsedArgs = new ArgumentParser(args);
            FileName modelname = driver.argumentParseProjectFile(parsedArgs);
            FileResource modelResource = new FileResource(modelname);
            String extension = modelname.getExtension();
            if (extension == null) {
                throw new PluginSyntaxException(new SyntaxException("Modelfile has no file extension???.\n", usage), new ArrayList<String>());
            }
            boolean debug = driver.argumentParseDebug(parsedArgs);
            boolean force = driver.argumentParseForce(parsedArgs);
            String hostArg = driver.argumentParseHost(parsedArgs);
            File outDir = driver.argumentParseOutDir(parsedArgs);
            File srcDir = driver.argumentParseSrcDir(parsedArgs);
            if (outDir == null && srcDir == null) {
                outDir = new File(".");
                args = (String[])ArrayHelper.resize(args, args.length + 1);
                args[args.length - 1] = "-O" + outDir.getPath();
            } else if (outDir == null && srcDir != null) {
                StringTokenizer st = new StringTokenizer(srcDir.toString(), "/\\");
                int count = st.countTokens();
                if (st.countTokens() == 1) {
                    outDir = new File(".");
                } else {
                    String outDirStr = "";
                    for (int ii = 0; ii < count - 1; ++ii) {
                        outDirStr = outDirStr + st.nextToken();
                        if (ii + 1 >= count - 1) continue;
                        outDirStr = outDirStr + File.separator;
                    }
                    outDir = new File(outDirStr);
                }
                args = (String[])ArrayHelper.resize(args, args.length + 1);
                args[args.length - 1] = "-O" + outDir.getPath();
            }
            if (outDir != null && srcDir == null && (srcDir = FileHelper.getSrcDir(outDir == null ? new File(".") : outDir)) != null) {
                args = (String[])ArrayHelper.resize(args, args.length + 1);
                args[args.length - 1] = "-S" + srcDir.getPath();
            }
            String[] defines = DriverArguments.checkDefines(driver.argumentParseDefines(parsedArgs));
            Resource[] includes = driver.argumentParseIncludes(parsedArgs);
            Resource tmplDir = driver.argumentParseTmplDir(parsedArgs);
            Resource[] templates_ = driver.argumentParseTemplates(tmplDir, parsedArgs);
            String[] projects_ = driver.argumentParseProjectXml(parsedArgs);
            Pair<String, String> userpwPair = driver.argumentParseUser(parsedArgs);
            String user = userpwPair != null ? (String)userpwPair.first : null;
            String string = pw = userpwPair != null ? (String)userpwPair.second : null;
            if (!EmailValidator.getInstance().isValid(user)) {
                throw new PluginSyntaxException(new SyntaxException("Email address " + user + " is not valid?.\n", usage), new ArrayList<String>());
            }
            if (srcDir == null) {
                throw new PluginSyntaxException(new SyntaxException("-SsrcDir must be specified for this driver.\n", usage), new ArrayList<String>());
            }
            if (!srcDir.exists()) {
                throw new PluginSyntaxException(new SyntaxException("-S" + srcDir.getPath() + " does not exist? Maybe -S. if not generating Java.\n", usage), new ArrayList<String>());
            }
            if (tmplDir != null && !tmplDir.exists()) {
                throw new PluginSyntaxException(new SyntaxException("-TtmplDir  " + tmplDir.getPath() + " doe not exist!\n", usage), new ArrayList<String>());
            }
            if (templates_ != null) {
                throw new PluginSyntaxException(new SyntaxException("-t templates is not supported by this driver.\n", usage), new ArrayList<String>());
            }
            if (tmplDir != null && (tmplDir.getPath().startsWith("jar:") || tmplDir.getPath().indexOf("compiler") != -1 && tmplDir.getPath().indexOf("objectriver") != -1)) {
                tmplDir = null;
            }
            if ((home = System.getenv("OBJECTRIVER_HOME")) == null) {
                throw new PluginCloudCompilerException(new CloudCompilerException("Environment Variable OBJECTRIVER_HOME is not set?"), new ArrayList<String>());
            }
            try {
                client = CloudCompilerClient.cloudCompilerConnect(modelname, hostArg);
                client.anttask = anttask;
                Integer timeout = driver.argumentParseTimeout(parsedArgs);
                client.setTimeout(timeout != null ? timeout : 180);
                List<String> list = CloudCompilerClient.cloudCompilerExecute(client, user, pw, args, modelResource, defines, includes, outDir, tmplDir);
                return list;
            }
            catch (DeploymentException ex) {
                System.out.println("DeploymentException: " + ex.getMessage() + " Server not running?");
                throw new PluginCloudCompilerException(new CloudCompilerException("DeploymentException: " + ex.getMessage() + " Server not running?", ex), new ArrayList<String>());
            }
            catch (PluginCloudCompilerException ex) {
                throw ex;
            }
            catch (CloudCompilerException ex) {
                List<String> console = new ArrayList<String>();
                switch (ex.getLevel().getEnumeration()) {
                    case Error: {
                        System.err.println("CloudCompilerException: " + ex.getMessage());
                        console = ex.printCauseTrace();
                        throw new PluginCloudCompilerException(ex, console);
                    }
                    case Info: 
                    case Warning: {
                        System.out.printf("--------------------------- Exception %s--------------------------------", ex.getLevel().getEnumeration().toString());
                        System.out.printf(ex.getMessage(), new Object[0]);
                        System.out.printf("------------------------------------------------------------------------", ex.getLevel().getEnumeration().toString());
                        console.add("--------------------------- Exception " + ex.getLevel().getEnumeration().toString() + "--------------------------------");
                        console.add(ex.getMessage());
                        console.add("------------------------------------------------------------------------");
                        throw new PluginCloudCompilerException(ex, console);
                    }
                }
                throw new PluginCloudCompilerException(ex, console);
            }
            catch (WebRpcClientException ex) {
                System.out.println("WebRpcClientException: " + ex.getMessage());
                List<String> console = ex.printCauseTrace();
                throw new PluginCloudCompilerException(new CloudCompilerException(ex.getMessage(), ex), console);
            }
            catch (IOException ex) {
                System.out.println("IOException: " + ex.getMessage());
                throw new PluginCloudCompilerException(new CloudCompilerException(ex.getMessage(), ex), new ArrayList<String>());
            }
            finally {
                System.out.println("CloudCompiler: ended.");
                try {
                    if (client != null) {
                        client.disconnect();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (CloudCompilerException ex) {
            if (!(ex instanceof PluginCloudCompilerException)) throw new PluginCloudCompilerException(ex, new ArrayList<String>());
            throw ex;
        }
        catch (ArgumentParserException ex) {
            System.err.println("ArgumentParserException: " + ex.getMessage());
            throw new PluginCloudCompilerException(new CloudCompilerException("ArgumentParserException: " + ex.getMessage(), ex), new ArrayList<String>());
        }
        catch (SyntaxException ex) {
            throw new PluginSyntaxException(ex, new ArrayList<String>());
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex.getMessage());
            if (!(ex instanceof PluginCloudCompilerException)) throw new PluginCloudCompilerException(new CloudCompilerException("UnknownException: " + ex.getMessage(), ex), new ArrayList<String>());
            throw (PluginCloudCompilerException)ex;
        }
    }

    public static CloudCompilerClient cloudCompilerConnect(FileName modelname, String hostUrl) throws DeploymentException, IOException {
        CloudCompilerClient client = null;
        try {
            String url = null;
            if (hostUrl != null) {
                url = hostUrl;
            } else {
                try {
                    LocationPicker redirect = LocationPicker.parse("https://www.objectriver.net/cloudcompiler/location.json");
                    url = redirect.getLocation(modelname.getExtension());
                    if (url == null) {
                        ArrayList<String> errorList = new ArrayList<String>();
                        errorList.add("Unsupported model file extension: " + modelname.getExtension());
                        StringBuffer sb = new StringBuffer("Supported metadata file extensions=");
                        for (String extension : redirect.locationMap.keySet()) {
                            sb.append(extension).append(',');
                        }
                        errorList.add(sb.toString());
                        throw new PluginCloudCompilerException(new CloudCompilerException("Unknown model file extension=" + modelname.getExtension()), errorList);
                    }
                }
                catch (JsonParsingException ex) {
                    throw new IOException("IOException: Communicating with www.objectriver.net? ");
                }
            }
            client = CloudCompilerClient.connect(new CloudCompilerClient(), url);
        }
        catch (URISyntaxException ex) {
            System.out.println("URISyntaxException: " + ex.getMessage());
            ex.printStackTrace();
        }
        return client;
    }

    private static List<String> cloudCompilerExecute(CloudCompilerClient client, String user, String pw, String[] args, FileResource modelResource, String[] defines, Resource[] includes, File outDir, Resource tmplDir) throws IOException, CloudCompilerException {
        ArrayList<String> plugin_console = new ArrayList<String>();
        try {
            client.initialize(client, user, pw, modelResource);
            if (tmplDir != null) {
                String[] argList = new String[args.length - 1];
                int index = 0;
                for (String a : args) {
                    if (a.startsWith("-T")) continue;
                    argList[index++] = a;
                }
                args = argList;
            }
            client.commandline(client, args);
            List<String> parse_console = client.parse(client, modelResource, defines, includes);
            plugin_console.addAll(parse_console);
            List<String> check_console = client.check(client);
            plugin_console.addAll(check_console);
            List<String> templates_console = client.sendTemplates(client, tmplDir);
            plugin_console.addAll(templates_console);
            List<FileStat> statlist = client.generateFileList(client, outDir);
            List<String> generate_console = client.generate(client, statlist);
            plugin_console.addAll(generate_console);
            List<String> results_console = client.getResults(client, outDir);
            plugin_console.addAll(results_console);
        }
        catch (PluginCloudCompilerException ex) {
            plugin_console.addAll(ex.console);
        }
        catch (CloudCompilerException ex) {
            plugin_console.add(ex.getMessage());
        }
        return plugin_console;
    }

    protected void initialize(CloudCompilerClient client, String user, String pin, FileResource modelResource) throws CloudCompilerException {
        String domainName = "unknown";
        try {
            InetAddress addr = InetAddress.getByName(InetAddress.getLocalHost().getHostName());
            String hostnameCanonical = addr.getCanonicalHostName();
            int begin = hostnameCanonical.indexOf(".");
            domainName = begin == -1 ? hostnameCanonical : hostnameCanonical.substring(begin + 1);
        }
        catch (UnknownHostException begin) {
            // empty catch block
        }
        String country = System.getProperty("user.country");
        if (country == null) {
            country = "XX";
        }
        try {
            if (pin != null) {
                pin = SimpleStringCipher.encrypt(pin);
            }
        }
        catch (Exception ex) {
            if (this.anttask) {
                CloudCLogger.clogger.info("CloudCompiler: Internal Error? " + ex.getMessage());
            } else {
                System.out.println("CloudCompiler: Internal Error? " + ex.getMessage());
            }
            throw new CloudCompilerException(ExceptionLevel.Error_instance, "client.initialize", "Internal Error?", 201, ex);
        }
        String clientVersion = "V1_0_1/prod_1";
        client.initialize(user, pin, modelResource.getName(), domainName, country, clientVersion);
    }

    protected Boolean commandline(CloudCompilerClient client, String[] args) throws CloudCompilerException {
        for (int ii = 0; ii < args.length; ++ii) {
            if (!args[ii].equals("-U") || ii + 2 >= args.length) continue;
            args[ii + 2] = "1234567890";
            break;
        }
        return client.commandline(args);
    }

    protected List<String> generate(CloudCompilerClient client, List<FileStat> statlist) throws CloudCompilerException {
        ArrayList<String> console = new ArrayList<String>();
        if (this.anttask) {
            CloudCLogger.clogger.info("CloudCompiler: Generating ...");
        } else {
            System.out.println("CloudCompiler: Generating ...");
        }
        console.add("CloudCompiler: Generating ...");
        Object[] output = client.generate(statlist.toArray(new FileStat[0]));
        ArrayIterator iter = new ArrayIterator(output);
        while (iter.hasNext()) {
            String line = (String)iter.next();
            System.out.println(line);
            console.add(line);
        }
        return console;
    }

    protected List<FileStat> generateFileList(CloudCompilerClient client, File outDir) throws CloudCompilerException {
        Object[] generatedList = client.generateFileList();
        List<FileStat> statlist = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            ArrayIterator iter = new ArrayIterator(generatedList);
            while (iter.hasNext()) {
                list.add((String)iter.next());
            }
            statlist = FileTree.getFileStats(outDir.getPath(), list);
        }
        catch (FileTreeException ex) {
            System.err.println("generateFileList() throwing FileTreeException");
            throw new CloudCompilerException(ExceptionLevel.Error_instance, "client.generateFileList() ", ex.getMessage(), 202, ex);
        }
        return statlist;
    }

    protected List<String> sendTemplates(CloudCompilerClient client, Resource tmplDir) throws IOException, CloudCompilerException {
        ArrayList<String> console = new ArrayList<String>();
        if (tmplDir != null && !tmplDir.getPath().startsWith("jar:")) {
            if (this.anttask) {
                CloudCLogger.clogger.info("CloudCompiler: Syncing templates ...");
            } else {
                System.out.println("CloudCompiler: Syncing templates ...");
            }
            console.add("CloudCompiler: Syncing templates ...");
            OutputStream writer = client.getSession().getBasicRemote().getSendStream();
            client.sendTemplates(writer);
            ZipStream zs = new ZipStream();
            FileResource tmplDirFr = (FileResource)tmplDir;
            zs.zip(writer, tmplDirFr.getURL().getFile(), "^.*(?:tmpl|xml|incl).*", false);
            client.sendTemplates_wait();
            if (this.anttask) {
                CloudCLogger.clogger.info("CloudCompiler: Syncing templates OK");
            } else {
                System.out.println("CloudCompiler: Syncing templates OK");
            }
            console.add("CloudCompiler: Syncing templates OK");
        }
        return console;
    }

    protected List<String> check(CloudCompilerClient client) throws CloudCompilerException {
        ArrayList<String> console = new ArrayList<String>();
        System.out.println("CloudCompiler: SemanticCheck ...");
        console.add("CloudCompiler: SemanticCheck ...");
        Object[] checks = client.check();
        if (checks.length != 0) {
            ArrayIterator iter = new ArrayIterator(checks);
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (this.anttask) {
                    CloudCLogger.clogger.info(line);
                    continue;
                }
                System.out.println(line);
                console.add(line);
            }
            throw new PluginCloudCompilerException(new CloudCompilerException("Semantic Check Exception"), console);
        }
        if (this.anttask) {
            CloudCLogger.clogger.info("CloudCompiler: SemanticCheck OK");
        } else {
            System.out.println("CloudCompiler: SemanticCheck OK");
            console.add("CloudCompiler: SemanticCheck OK");
        }
        return console;
    }

    protected List<String> parse(CloudCompilerClient client, Resource modelResource, String[] defines, Resource[] includes) throws CloudCompilerException, IOException {
        ArrayList<String> console = new ArrayList<String>();
        this.parse_nowait(client, modelResource, defines, includes);
        if (this.anttask) {
            CloudCLogger.clogger.info("CloudCompiler: Parsed");
        } else {
            System.out.println("CloudCompiler: Parsed");
            console.add("CloudCompiler: Parsed");
        }
        client.parse_wait();
        return console;
    }

    protected List<String> parse_nowait(CloudCompilerClient client, Resource modelResource, String[] defines, Resource[] includes) throws CloudCompilerException, IOException {
        ArrayList<String> console = new ArrayList<String>();
        OutputStream outputStream = client.getSession().getBasicRemote().getSendStream();
        client.parse(outputStream);
        if (this.anttask) {
            CloudCLogger.clogger.info("CloudCompiler: Parsing ...");
        } else {
            System.out.println("CloudCompiler: Parsing ...");
            console.add("CloudCompiler: Parsing ...");
        }
        Resource configtest = RuntimeClassLoader.loadResource("model");
        Assert.assertTrue("model directory not found?", configtest != null);
        int nResources = includes == null ? 1 : includes.length + 1;
        Resource[] resources = new Resource[nResources];
        if (includes != null) {
            System.arraycopy(includes, 0, resources, 0, includes.length);
        }
        resources[nResources - 1] = configtest;
        this.preprocessModel(modelResource, resources, defines, new OutputStreamWriter(outputStream));
        return console;
    }

    protected List<String> getResults(CloudCompilerClient client, File outDir) throws IOException, CloudCompilerException {
        ArrayList<String> console = new ArrayList<String>();
        if (this.anttask) {
            CloudCLogger.clogger.info("CloudCompiler: Getting  Results ...");
        } else {
            System.out.println("CloudCompiler: Getting  Results ...");
            console.add("CloudCompiler: Getting  Results ...");
        }
        ZipStream zipper = new ZipStream();
        InputStream instream = (InputStream)client.getResults();
        zipper.unzip(instream, outDir.getAbsolutePath());
        console.add("CloudCompiler: Completed.");
        return console;
    }

    protected void preprocessModel(Resource modelResource, Resource[] includes, String[] defines, Writer writer) throws CloudCompilerException {
        try {
            Cpp.preprocess(modelResource, includes, defines, false, writer);
        }
        catch (IOException e) {
            if (this.anttask) {
                CloudCLogger.clogger.info("CloudCompiler: Error: IOException" + e.getMessage());
            } else {
                System.out.println("CloudCompiler: Error: IOException" + e.getMessage());
            }
            e.printStackTrace();
            throw new CloudCompilerException("CloudCompiler: Error: IOException", e);
        }
    }
}

