/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client;

import com.objectriver.cloudcompiler.client.StreamingCloudCompilerClient;
import com.objectriver.cloudcompiler.cloudc.common.beans.CloudCompilerException;
import com.objectriver.compiler.driver.exceptions.ArgumentParserException;
import com.objectriver.compiler.driver.exceptions.SyntaxException;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.resource.FileResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import javax.websocket.DeploymentException;

public class PlSqlStreamingCloudCompilerClientExample {
    public static void main(String[] args) {
        try {
            String directory = "src/test/";
            String APPCODE = "OTC";
            Object[] Schemas = new String[]{"OTC_HUB_WRHS"};
            String host = "-Hlocalhost:8080";
            String[] plsqlscanner_args = new String[]{host, APPCODE + ".plsql", "-DPhysicalDb=FRED", "-Ttemplates", "-PResProc.xml"};
            StreamingCloudCompilerClient client = StreamingCloudCompilerClient.connect(plsqlscanner_args);
            PipedWriter pw = new PipedWriter();
            client.parser_reader(new PipedReader(pw));
            pw.write("Model " + APPCODE + " {\n");
            pw.write("    PlSql {\n");
            ArrayIterator iter = new ArrayIterator(Schemas);
            while (iter.hasNext()) {
                String line;
                String schema = (String)iter.next();
                pw.write("#line 0 " + schema + ".plsql \n");
                pw.write("        SqlSchema " + schema + " {\n");
                FileResource inputResource = new FileResource(new File(directory + schema + ".plsql"));
                Reader reader = inputResource.getReader();
                BufferedReader br = new BufferedReader(reader);
                while ((line = br.readLine()) != null) {
                    pw.write(line + '\n');
                }
                pw.write("        };\n");
            }
            pw.write("    };\n");
            pw.write("};\n");
            pw.close();
            Boolean status = client.parse_readerwait();
            if (status.booleanValue()) {
                client.generate();
            }
            client.disconnect();
        }
        catch (CloudCompilerException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (SyntaxException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (ArgumentParserException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (URISyntaxException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (DeploymentException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

