/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client;

import com.objectriver.cloudcompiler.client.CloudCClientCustom;
import com.objectriver.cloudcompiler.client.CloudCompilerClient;
import com.objectriver.cloudcompiler.cloudc.common.beans.CloudCompilerException;
import com.objectriver.cloudcompiler.cloudc.common.enums.FileStat;
import com.objectriver.compiler.driver.ArgumentParser;
import com.objectriver.compiler.driver.DriverArguments;
import com.objectriver.compiler.driver.exceptions.ArgumentParserException;
import com.objectriver.compiler.driver.exceptions.SyntaxException;
import com.objectriver.compiler.util.FileName;
import com.objectriver.runtime.util.ArrayHelper;
import com.objectriver.runtime.util.FileHelper;
import com.objectriver.runtime.util.resource.FileResource;
import com.objectriver.runtime.util.resource.Resource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.List;
import javax.websocket.DeploymentException;

public class StreamingCloudCompilerClient
extends CloudCompilerClient {
    private boolean debug;
    private boolean force;
    private File outDir;
    private File srcDir;
    private String[] defines;
    private Resource[] includes;
    private Resource tmplDir;
    private Resource[] templates_;
    private String[] projects_;
    private FileName modelname;
    private FileResource modelResource;

    protected StreamingCloudCompilerClient() {
    }

    public static StreamingCloudCompilerClient connect(String[] args) throws CloudCompilerException, SyntaxException, ArgumentParserException, IOException, URISyntaxException, DeploymentException {
        StreamingCloudCompilerClient client = null;
        if (args.length == 0) {
            throw new SyntaxException("No arguments? ", "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]");
        }
        DriverArguments driver = new DriverArguments();
        driver.driverName = "CloudC";
        ArgumentParser parsedArgs = new ArgumentParser(args);
        System.out.println("CloudCompiler: Connecting ...");
        String host = driver.argumentParseHost(parsedArgs);
        if (host == null) {
            host = "localhost:8080";
        }
        if (host.indexOf(58) == -1) {
            host = host + ":8080";
        }
        client = CloudCClientCustom.connect(new StreamingCloudCompilerClient(), "ws://" + host + "/cloudcompiler/cloudC");
        client.debug = driver.argumentParseDebug(parsedArgs);
        client.force = driver.argumentParseForce(parsedArgs);
        client.modelname = new FileName(parsedArgs.getValue("NAME"));
        client.modelResource = new FileResource(client.modelname);
        client.outDir = driver.argumentParseOutDir(parsedArgs);
        client.srcDir = driver.argumentParseSrcDir(parsedArgs);
        if (client.srcDir == null) {
            client.srcDir = FileHelper.getSrcDir(client.outDir == null ? new File(".") : client.outDir);
            if (client.srcDir != null) {
                args = (String[])ArrayHelper.resize(args, args.length + 1);
                args[args.length - 1] = "-S" + client.srcDir.getPath();
            }
        }
        if (client.outDir == null && client.srcDir != null) {
            client.outDir = FileHelper.getParentFile(client.srcDir);
            args = (String[])ArrayHelper.resize(args, args.length + 1);
            args[args.length - 1] = "-O" + client.outDir.getPath();
        } else if (client.outDir == null) {
            client.outDir = new File(".");
            args = (String[])ArrayHelper.resize(args, args.length + 1);
            args[args.length - 1] = "-O.";
        }
        if (client.srcDir == null) {
            client.srcDir = FileHelper.toFile(client.outDir, "src");
            args = (String[])ArrayHelper.resize(args, args.length + 1);
            args[args.length - 1] = "-S" + client.srcDir.getPath();
        }
        client.defines = DriverArguments.checkDefines(driver.argumentParseDefines(parsedArgs));
        client.includes = driver.argumentParseIncludes(parsedArgs);
        client.tmplDir = driver.argumentParseTmplDir(parsedArgs);
        client.templates_ = driver.argumentParseTemplates(client.tmplDir, parsedArgs);
        client.projects_ = driver.argumentParseProjectXml(parsedArgs);
        if (client.srcDir == null) {
            throw new SyntaxException("-SsrcDir must be specified for this driver.", "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]");
        }
        if (!client.srcDir.exists()) {
            throw new SyntaxException("-S" + client.srcDir.getPath() + " does not exist?", "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]");
        }
        if (client.tmplDir != null && !client.tmplDir.exists()) {
            throw new SyntaxException("-TtmplDir  " + client.tmplDir.getPath() + " doe not exist!", "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]");
        }
        if (client.templates_ != null) {
            throw new SyntaxException("-t templates is not supported by this driver.", "Usage: CloudCompilerClient model -U user guest -wait minutes [ -Iinclude -Ddefine -WworkDir-OoutDir -SsrcDir ] Rest|WebSocket[-clientonly -serveronly]");
        }
        if (client.tmplDir != null && (client.tmplDir.getPath().startsWith("jar:") || client.tmplDir.getPath().indexOf("objectriver") != -1)) {
            client.tmplDir = null;
        }
        client.commandline(args);
        return client;
    }

    public void parser_reader(Reader preader) throws CloudCompilerException, IOException {
        FileResource fileResource = new FileResource(this.modelname.getAbsoluteFile()){

            @Override
            public boolean exists() {
                return true;
            }

            @Override
            public boolean canRead() {
                return true;
            }

            @Override
            public boolean isFile() {
                return true;
            }

            @Override
            public boolean isDirectory() {
                return false;
            }

            @Override
            public BufferedReader getBufferedReader() throws IOException {
                return new BufferedReader(this.getReader());
            }
        };
        fileResource.setReader(preader);
        this.parse_nowait(this, fileResource, this.defines, this.includes);
    }

    public boolean parse_readerwait() throws CloudCompilerException {
        this.parse_wait();
        return true;
    }

    public void generate() throws CloudCompilerException, IOException {
        this.check(this);
        this.sendTemplates(this, this.tmplDir);
        List<FileStat> statlist = this.generateFileList(this, this.outDir);
        this.generate(this, statlist);
        this.getResults(this, this.outDir);
    }
}

