/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client.exception;

import com.objectriver.cloudcompiler.client.exception.TraceExceptionCause;
import com.objectriver.cloudcompiler.client.exception.TraceExceptionStackLocation;
import com.objectriver.cloudcompiler.client.exception.TraceException_Base;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class TraceException
extends TraceException_Base {
    private TraceException() {
    }

    public TraceException(Throwable cause) {
        super(cause);
        this.populateCauses(cause);
    }

    public TraceException(String message, Throwable cause) {
        super(message, cause);
        this.populateCauses(cause);
    }

    public String[] printCauseBy(boolean print) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<TraceExceptionCause> iter = this.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String output;
            TraceExceptionCause cause = iter.next();
            if (first) {
                output = "Exception " + cause.toString();
                if (print) {
                    System.err.println(output);
                }
                list.add(output);
            } else {
                output = "Caused By " + cause.toString();
                if (print) {
                    System.err.println(output);
                }
                list.add(output);
            }
            first = false;
        }
        return list.toArray(new String[0]);
    }

    public String[] printCauseTrace(TraceExceptionCause cause, boolean print) {
        ArrayList<String> list = new ArrayList<String>();
        String output = "Cause " + cause.toString();
        list.add(output);
        if (print) {
            System.err.println(output);
        }
        for (TraceExceptionStackLocation location : cause.getLocations()) {
            output = "Location" + location.toString();
            if (print) {
                System.err.println(output);
            }
            list.add(output);
        }
        return list.toArray(new String[0]);
    }

    public static void main(String[] args) {
        IOException io = new IOException("IO bottom");
        RuntimeException runtime = new RuntimeException("middle", io);
        RuntimeException runtime2 = new RuntimeException("top", runtime);
        TraceException trace = new TraceException(runtime2);
        trace.printCauseBy(true);
        trace.printCauseTrace(trace.causes[0], true);
    }
}

