/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client.exception;

import com.objectriver.cloudcompiler.client.exception.TraceExceptionStackLocation;
import java.util.ArrayList;
import java.util.List;

public class TraceExceptionCause {
    protected Throwable cause = null;
    protected String type = null;
    protected String message = null;
    protected List<TraceExceptionStackLocation> locations = new ArrayList<TraceExceptionStackLocation>();

    public TraceExceptionCause() {
    }

    public TraceExceptionCause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            StackTraceElement[] steArray;
            this.type = cause.getClass().getSimpleName();
            this.message = cause.getMessage();
            for (StackTraceElement element : steArray = cause.getStackTrace()) {
                this.locations.add(new TraceExceptionStackLocation(element));
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public TraceExceptionStackLocation getLocation() {
        return this.locations.get(0);
    }

    public List<TraceExceptionStackLocation> getLocations() {
        return this.locations;
    }

    public String toString() {
        String message = this.message != null ? this.getMessage() : " ";
        return this.type + " message:" + "\"" + message + "\" " + (!this.locations.isEmpty() ? this.locations.get(0).toString() : "");
    }
}

