/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client.exception;

public class TraceExceptionStackLocation {
    protected String declaringClass;
    protected String methodName;
    protected String fileName;
    protected int lineNumber;

    public TraceExceptionStackLocation(StackTraceElement ste) {
        if (ste == null) {
            this.declaringClass = "Unknown";
            this.methodName = "Unknown";
            this.fileName = "Unknown";
            this.lineNumber = 0;
        } else {
            this.declaringClass = ste.getClassName();
            this.methodName = ste.getMethodName();
            this.fileName = ste.getFileName();
            this.lineNumber = ste.getLineNumber();
        }
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("method=").append(this.declaringClass).append(':');
        buff.append(this.methodName);
        buff.append('(').append(this.fileName).append(' ');
        buff.append(":").append(this.lineNumber).append(')');
        return buff.toString();
    }
}

