/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Redirect {
    protected String bootstrapUrl;
    public LinkedList<String> releaseList = new LinkedList();
    public Map<String, Map<String, String>> releaseMap = new HashMap<String, Map<String, String>>();

    private Redirect() {
    }

    public Redirect(String bootstrapUrl) {
        this.bootstrapUrl = bootstrapUrl;
    }

    public void parseLocation() throws IOException {
        URL getUrl = new URL(this.bootstrapUrl);
        HttpURLConnection connection = (HttpURLConnection)getUrl.openConnection();
        try {
            connection.connect();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader reader = inputFactory.createXMLEventReader(new InputStreamReader(connection.getInputStream()));
            String current_release = null;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                if (element.getName().getLocalPart().equals("release")) {
                    Attribute webapp = element.getAttributeByName(QName.valueOf("webapp"));
                    Attribute rootcontext = element.getAttributeByName(QName.valueOf("rootcontext"));
                    current_release = webapp.getValue() + '/' + rootcontext.getValue();
                    this.releaseList.add(current_release);
                    continue;
                }
                if (!element.getName().getLocalPart().equals("language")) continue;
                Attribute langname = element.getAttributeByName(QName.valueOf("name"));
                Attribute serverurl = element.getAttributeByName(QName.valueOf("url"));
                Map<Object, Object> locationMap = null;
                if (this.releaseMap.containsKey(current_release)) {
                    locationMap = this.releaseMap.get(current_release);
                } else {
                    locationMap = new HashMap();
                    this.releaseMap.put(current_release, locationMap);
                }
                locationMap.put(langname.getValue(), serverurl.getValue());
            }
            reader.close();
        }
        catch (XMLStreamException ex) {
            throw new IOException("XMLStreamException parsing location", ex);
        }
        finally {
            connection.disconnect();
        }
    }

    public List<String> getReleaseList() {
        return this.releaseList;
    }

    public Map<String, String> getLanguageMap(String release) {
        return this.releaseMap.get(release);
    }

    public String getLatestReleaseUrl(String lang) {
        String release = this.releaseList.getLast();
        Map<String, String> latestReleaseMap = this.releaseMap.get(this.releaseList.getLast());
        String hosturl = "ws://" + latestReleaseMap.get(lang) + "/" + release + "/cloudcompiler";
        return hosturl;
    }

    public String getLatestProdReleaseUrl(String lang) {
        if (this.releaseList.size() == 1) {
            return this.getLatestReleaseUrl(lang);
        }
        Iterator<String> iter = this.releaseList.descendingIterator();
        while (iter.hasNext()) {
            String release = iter.next();
            if (!release.contains("prod")) continue;
            Map<String, String> prodReleaseMap = this.releaseMap.get(release);
            String hosturl = "ws://" + prodReleaseMap.get(lang) + "/" + release + "/cloudcompiler";
            return hosturl;
        }
        return null;
    }
}

