/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.client.util.location_picker;

import com.objectriver.cloudcompiler.client.util.location_picker.JsonParserWithPeek;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;

public class LocationPicker {
    public Map<String, List<String>> locationMap = new HashMap<String, List<String>>();

    private LocationPicker() {
    }

    public static LocationPicker parse(String bootstrapUrl) throws JsonParsingException {
        LocationPicker picker = new LocationPicker();
        try {
            InputStream is = null;
            if (bootstrapUrl.startsWith("file:")) {
                File file = new File(bootstrapUrl.substring(5));
                is = new FileInputStream(file);
            } else {
                URL getUrl = new URL(bootstrapUrl);
                URLConnection connection = getUrl.openConnection();
                is = connection.getInputStream();
            }
            JsonParserWithPeek parser = new JsonParserWithPeek(is);
            JsonParser.Event event = parser.peek();
            if (event != JsonParser.Event.START_OBJECT) {
                throw new JsonParsingException("Parser could not find START_OBJECT", null);
            }
            parser.next();
            while (parser.hasNext() && (event = parser.peek()) != JsonParser.Event.END_OBJECT) {
                if (event != JsonParser.Event.KEY_NAME) {
                    throw new JsonParsingException("\"Object Parser expected key! Found " + event.toString(), null);
                }
                event = parser.next();
                String model = parser.getString();
                ArrayList<String> modellocationList = new ArrayList<String>();
                picker.locationMap.put(model, modellocationList);
                event = parser.next();
                if (event != JsonParser.Event.START_ARRAY) {
                    throw new JsonParsingException("Parser could not find START_OBJECT", null);
                }
                while (parser.hasNext() && (event = parser.peek()) != JsonParser.Event.END_ARRAY) {
                    event = parser.next();
                    if (event != JsonParser.Event.START_OBJECT) continue;
                    event = parser.next();
                    event = parser.next();
                    Integer frequency = parser.getInt();
                    event = parser.next();
                    event = parser.next();
                    String host = parser.getString();
                    event = parser.next();
                    for (int ii = 0; ii < frequency; ++ii) {
                        modellocationList.add(host);
                    }
                }
                event = parser.next();
            }
        }
        catch (MalformedURLException ex) {
            throw new JsonParsingException(ex.getMessage(), null);
        }
        catch (IOException ex) {
            throw new JsonParsingException(ex.getMessage(), null);
        }
        return picker;
    }

    public String getLocation(String model) {
        List<String> locations = this.locationMap.get(model);
        if (locations == null) {
            return null;
        }
        int random = (int)(Math.random() * 100000.0);
        int index = random % locations.size();
        String host = locations.get(index);
        String url = "ws://" + host + "/cloudcompiler/V2_0_0/cloudcompiler";
        return url;
    }

    public static void main(String[] args) {
        LocationPicker lp = LocationPicker.parse("https://www.objectriver.net/cloudcompiler/location.json");
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("webrpc"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("soa"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
        System.out.println(lp.getLocation("rest"));
    }
}

