/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.cloudc.client;

import com.objectriver.cloudcompiler.cloudc.client.CloudCClientStub_V1;
import com.objectriver.cloudcompiler.cloudc.client.impl.CloudCClientConfigurator;
import com.objectriver.cloudcompiler.cloudc.common.CloudCLogger;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCBinaryStreamEnvelopeEncodeDecode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.WebSocketContainer;

public class CloudCClient
extends CloudCClientStub_V1 {
    public static CloudCClient connect(String path) throws IOException, DeploymentException, URISyntaxException {
        CloudCClient client = new CloudCClient();
        return CloudCClient.connect(client, path);
    }

    public static <T extends CloudCClient> T connect(T client, String path) throws IOException, DeploymentException, URISyntaxException {
        CloudCLogger.clogger.log(Level.INFO, "WebSocket.connect()");
        WebSocketContainer wsc = ContainerProvider.getWebSocketContainer();
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().configurator(new CloudCClientConfigurator()).encoders(Arrays.asList(CloudCBinaryStreamEnvelopeEncodeDecode.class)).decoders(Arrays.asList(CloudCBinaryStreamEnvelopeEncodeDecode.class)).build();
        client.session = wsc.connectToServer(client, clientEndpointConfig, new URI(path));
        client.setTimeout(25);
        return client;
    }

    public Integer getTimeout() {
        return (Integer)this.session.getUserProperties().get("timeout");
    }

    public void setTimeout(Integer seconds) {
        this.session.getUserProperties().put("timeout", seconds);
    }

    public void disconnect() throws IOException {
        CloudCLogger.clogger.info("WebSocket.disconnect()");
        if (this.session != null) {
            this.session.close();
        }
    }
}

