/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.cloudc.client;

import com.objectriver.cloudcompiler.cloudc.client.CcInterfaceClientSessionImplFactory;
import com.objectriver.cloudcompiler.cloudc.client.CloudCClientStub_V1;
import com.objectriver.cloudcompiler.cloudc.client.impl.CloudCClientConfigurator;
import com.objectriver.cloudcompiler.cloudc.common.CcInterfaceClientInterface_V1;
import com.objectriver.cloudcompiler.cloudc.common.CloudCLogger;
import com.objectriver.cloudcompiler.cloudc.common.CloudCMethods;
import com.objectriver.cloudcompiler.cloudc.common.ServerEndPointInterface;
import com.objectriver.cloudcompiler.cloudc.common.beans.CloudCompilerException;
import com.objectriver.cloudcompiler.cloudc.common.documents.CheckResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.CommandlineResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GenerateFileListResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GenerateResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GetResultsResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.InitializeResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCEnvelope;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCEnvelope_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCTextStreamEnvelopeEncodeDecode;
import com.objectriver.runtime.webrpc.MessageType;
import com.objectriver.runtime.webrpc.exception.WebRpcDecodeException;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;

public class CloudCClientEndpoint
extends Endpoint {
    protected final Endpoint endpoint = this;
    protected Session session = null;
    protected ClientEndpointConfig cloudCConfig = null;
    protected CloudCClientConfigurator cloudCConfigurator = null;
    protected CcInterfaceClientInterface_V1 impl = null;

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.cloudCConfig = (ClientEndpointConfig)config;
        this.cloudCConfigurator = (CloudCClientConfigurator)this.cloudCConfig.getConfigurator();
        CloudCLogger.clogger.fine("CloudC.onOpen()");
        try {
            this.impl = CcInterfaceClientSessionImplFactory.instanceOf(this.cloudCConfigurator.getVersion(), session);
            session.addMessageHandler(new CloudCMessageHandler());
            session.addMessageHandler(new CloudCTextHandler());
            ((ServerEndPointInterface)((Object)this.impl)).onOpen(session, config);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onClose(Session session, CloseReason closeReason) {
        CloudCLogger.clogger.fine("CloudC.onClose()");
        if (this.impl != null) {
            ((ServerEndPointInterface)((Object)this.impl)).onClose(session, closeReason);
        }
    }

    @Override
    public void onError(Session session, Throwable thr) {
        CloudCLogger.clogger.log(Level.WARNING, "CloudC.onError() {0}:{1}", new String[]{thr.getClass().toString(), thr.getMessage()});
        if (this.impl != null) {
            ((ServerEndPointInterface)((Object)this.impl)).onError(session, thr);
        } else {
            System.out.println(thr.getMessage());
            thr.printStackTrace();
        }
        if (thr instanceof DecodeException) {
            DecodeException dce = (DecodeException)thr;
            WebRpcDecodeException wsde = new WebRpcDecodeException("Decode Exception", dce);
            CloudCClientStub_V1 stub = new CloudCClientStub_V1(session);
            stub.raiseWebSocketException(wsde);
        }
    }

    private void sendReply(CloudCEnvelope envelope) throws IOException, EncodeException {
        switch (envelope.getMessageType()) {
            case Binary: {
                this.session.getBasicRemote().sendObject(envelope);
                break;
            }
            case Text: {
                CloudCTextStreamEnvelopeEncodeDecode marshaller = new CloudCTextStreamEnvelopeEncodeDecode();
                StringWriter sw = new StringWriter();
                marshaller.encode(envelope, (Writer)sw);
                this.session.getBasicRemote().sendText(sw.toString());
                break;
            }
        }
    }

    public class CloudCMessageHandler
    implements MessageHandler.Whole<CloudCEnvelope> {
        @Override
        public void onMessage(CloudCEnvelope envelope) {
            try {
                this.dispatch((CloudCEnvelope_V1)envelope);
            }
            catch (Exception ex) {
                try {
                    CloudCLogger.clogger.log(Level.SEVERE, "CloudC.onMessage()", ex);
                    envelope.setMethod(CloudCMethods.raiseWebSocketException_1_instance);
                    envelope.setWebSocketException(new WebSocketException("onMessage() Unknown Client Exception", ex));
                    CloudCClientEndpoint.this.sendReply(envelope);
                }
                catch (IOException iOException) {
                }
                catch (EncodeException encodeException) {
                    // empty catch block
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatch(CloudCEnvelope_V1 envelope) {
            switch (envelope.getMethod().getEnum()) {
                case checkResponse_1: {
                    CheckResponseDocument_V1 response = envelope.getCheckResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.checkResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case commandlineResponse_1: {
                    CommandlineResponseDocument_V1 response = envelope.getCommandlineResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.commandlineResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case sendTemplatesResponse_1: {
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.sendTemplatesResponse_1_instance.getMethod(), "Successful Response");
                    Session response = CloudCClientEndpoint.this.session;
                    synchronized (response) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case parseResponse_1: {
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.parseResponse_1_instance.getMethod(), "Successful Response");
                    Session response = CloudCClientEndpoint.this.session;
                    synchronized (response) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case getResultsResponse_1: {
                    GetResultsResponseDocument_V1 response = envelope.getGetResultsResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.getResultsResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case initializeResponse_1: {
                    InitializeResponseDocument_V1 response = envelope.getInitializeResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.initializeResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case raiseWebSocketException_1: {
                    CloudCLogger.clogger.warning("CloudC.dispatch() Server raised WebSocketException");
                    WebSocketException exception = envelope.getWebSocketException();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.raiseWebSocketException_1_instance.getMethod(), exception);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case generateResponse_1: {
                    GenerateResponseDocument_V1 response = envelope.getGenerateResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.generateResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case generateFileListResponse_1: {
                    GenerateFileListResponseDocument_V1 response = envelope.getGenerateFileListResponseDocument_V1();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.generateFileListResponse_1_instance.getMethod(), response);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
                case raiseCloudCompilerException_1: {
                    CloudCLogger.clogger.warning("CloudC.dispatch() Server raised WebSocketException");
                    CloudCompilerException exception = envelope.getCloudCompilerException();
                    CloudCClientEndpoint.this.session.getUserProperties().put(CloudCMethods.raiseCloudCompilerException_1_instance.getMethod(), exception);
                    Session session = CloudCClientEndpoint.this.session;
                    synchronized (session) {
                        CloudCClientEndpoint.this.session.notify();
                        break;
                    }
                }
            }
        }

        private void assembleUnknownException(String method, CloudCEnvelope envelope, Exception ex) {
            envelope.setMethod(CloudCMethods.raiseWebSocketException_1_instance);
            CloudCLogger.slogger.log(Level.WARNING, "CloudC.dispatch() " + method + " throwing {0}:{1}", new String[]{ex.getClass().toString(), ex.getMessage()});
            if (ex instanceof WebSocketException) {
                envelope.setWebSocketException((WebSocketException)ex);
            } else {
                envelope.setWebSocketException(new WebSocketException(method + "() Unknown Server Exception", ex));
            }
        }
    }

    public class CloudCTextHandler
    implements MessageHandler.Whole<String> {
        @Override
        public void onMessage(String text) {
            CloudCTextStreamEnvelopeEncodeDecode marshaller = new CloudCTextStreamEnvelopeEncodeDecode();
            try {
                CloudCEnvelope envelope = marshaller.decode(new StringReader(text));
                CloudCMessageHandler messageHandler = new CloudCMessageHandler();
                messageHandler.onMessage(envelope);
            }
            catch (DecodeException ex) {
                try {
                    CloudCLogger.slogger.log(Level.SEVERE, "CloudC.onMessage()", ex);
                    CloudCEnvelope envelope = new CloudCEnvelope();
                    envelope.setMethod(CloudCMethods.raiseWebSocketException_1_instance);
                    envelope.setWebSocketException(new WebSocketException("onMessage() DecodeException", ex));
                    envelope.setMessageType(MessageType.Text);
                    CloudCClientEndpoint.this.sendReply(envelope);
                }
                catch (IOException iOException) {
                }
                catch (EncodeException encodeException) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

