/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.cloudc.client;

import com.objectriver.cloudcompiler.cloudc.client.CloudCClientEndpoint;
import com.objectriver.cloudcompiler.cloudc.common.CcInterfaceServerInterface_V1;
import com.objectriver.cloudcompiler.cloudc.common.CloudCLogger;
import com.objectriver.cloudcompiler.cloudc.common.CloudCMethods;
import com.objectriver.cloudcompiler.cloudc.common.beans.CloudCompilerException;
import com.objectriver.cloudcompiler.cloudc.common.documents.CheckResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.CommandlineDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.CommandlineResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GenerateDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GenerateFileListResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GenerateResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.GetResultsResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.InitializeDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.InitializeResponseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.ParseDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.SendTemplatesDocument_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCBinaryStreamEnvelopeEncodeDecode;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCEnvelope;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCEnvelope_V1;
import com.objectriver.cloudcompiler.cloudc.common.documents.encodedecode.CloudCTextStreamEnvelopeEncodeDecode;
import com.objectriver.cloudcompiler.cloudc.common.enums.FileStat;
import com.objectriver.runtime.webrpc.exception.WebRpcClientException;
import com.objectriver.runtime.webrpc.exception.WebRpcTimedout;
import com.objectriver.runtime.webrpc.exception.beans.WebSocketException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.websocket.EncodeException;
import javax.websocket.Session;

public class CloudCClientStub_V1
extends CloudCClientEndpoint
implements CcInterfaceServerInterface_V1 {
    public CloudCClientStub_V1() {
    }

    public CloudCClientStub_V1(Session session) {
        this.session = session;
    }

    @Override
    public Boolean initialize(String user, String pw, String model, String domain, String country, String client_version) throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering initialize()");
        InitializeDocument_V1 inDoc = new InitializeDocument_V1(user, pw, model, domain, country, client_version);
        InitializeResponseDocument_V1 outDoc = this.initialize(inDoc);
        Boolean result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving initialize()");
        return result;
    }

    public InitializeResponseDocument_V1 initialize(InitializeDocument_V1 request) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.initialize_1_instance);
            envelope.setInitializeDocument_V1(request);
            CloudCLogger.clogger.finer("Sending initialize()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("initialize() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.initialize_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("initialize() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.initialize_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "initialize() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.initialize_1_instance.getName() + " method ", ex);
        }
        InitializeResponseDocument_V1 response = this.initialize_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitializeResponseDocument_V1 initialize_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for initialize()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.initializeResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.initializeResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("initialize() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("initialize Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from initialize()");
        InitializeResponseDocument_V1 response = (InitializeResponseDocument_V1)obj;
        return response;
    }

    @Override
    public Boolean commandline(String[] args) throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering commandline()");
        CommandlineDocument_V1 inDoc = new CommandlineDocument_V1(args);
        CommandlineResponseDocument_V1 outDoc = this.commandline(inDoc);
        Boolean result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving commandline()");
        return result;
    }

    public CommandlineResponseDocument_V1 commandline(CommandlineDocument_V1 request) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.commandline_1_instance);
            envelope.setCommandlineDocument_V1(request);
            CloudCLogger.clogger.finer("Sending commandline()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("commandline() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.commandline_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("commandline() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.commandline_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "commandline() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.commandline_1_instance.getName() + " method ", ex);
        }
        CommandlineResponseDocument_V1 response = this.commandline_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandlineResponseDocument_V1 commandline_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for commandline()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.commandlineResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.commandlineResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("commandline() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("commandline Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from commandline()");
        CommandlineResponseDocument_V1 response = (CommandlineResponseDocument_V1)obj;
        return response;
    }

    @Override
    public void parse(Object stream) throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering parse()");
        ParseDocument_V1 inDoc = new ParseDocument_V1(stream);
        this.parse(inDoc);
    }

    public void parse(ParseDocument_V1 request) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.parse_1_instance);
            envelope.setParseDocument_V1(request);
            CloudCLogger.clogger.finer("Sending parse()");
            OutputStream os = (OutputStream)request.getStream();
            CloudCBinaryStreamEnvelopeEncodeDecode encoder = new CloudCBinaryStreamEnvelopeEncodeDecode();
            encoder.encode(envelope, os);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("parse() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.parse_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "parse() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.parse_1_instance.getName() + " method ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for parse()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 60;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.parseResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.parseResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("parse() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("parse Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from parse()");
    }

    @Override
    public String[] check() throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering check()");
        CheckResponseDocument_V1 outDoc = this.check(1);
        String[] result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving check()");
        return result;
    }

    public CheckResponseDocument_V1 check(int dummy) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.check_1_instance);
            CloudCLogger.clogger.finer("Sending check()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("check() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.check_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("check() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.check_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "check() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.check_1_instance.getName() + " method ", ex);
        }
        CheckResponseDocument_V1 response = this.check_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckResponseDocument_V1 check_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for check()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.checkResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.checkResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("check() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("check Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from check()");
        CheckResponseDocument_V1 response = (CheckResponseDocument_V1)obj;
        return response;
    }

    @Override
    public void sendTemplates(Object stream) throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering sendTemplates()");
        SendTemplatesDocument_V1 inDoc = new SendTemplatesDocument_V1(stream);
        this.sendTemplates(inDoc);
    }

    public void sendTemplates(SendTemplatesDocument_V1 request) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.sendTemplates_1_instance);
            envelope.setSendTemplatesDocument_V1(request);
            CloudCLogger.clogger.finer("Sending sendTemplates()");
            OutputStream os = (OutputStream)request.getStream();
            CloudCBinaryStreamEnvelopeEncodeDecode encoder = new CloudCBinaryStreamEnvelopeEncodeDecode();
            encoder.encode(envelope, os);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("sendTemplates() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.sendTemplates_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "sendTemplates() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.sendTemplates_1_instance.getName() + " method ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTemplates_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for sendTemplates()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.sendTemplatesResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.sendTemplatesResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("sendTemplates() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("sendTemplates Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from sendTemplates()");
    }

    @Override
    public String[] generateFileList() throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering generateFileList()");
        GenerateFileListResponseDocument_V1 outDoc = this.generateFileList(1);
        String[] result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving generateFileList()");
        return result;
    }

    public GenerateFileListResponseDocument_V1 generateFileList(int dummy) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.generateFileList_1_instance);
            CloudCLogger.clogger.finer("Sending generateFileList()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("generateFileList() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.generateFileList_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("generateFileList() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.generateFileList_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "generateFileList() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.generateFileList_1_instance.getName() + " method ", ex);
        }
        GenerateFileListResponseDocument_V1 response = this.generateFileList_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenerateFileListResponseDocument_V1 generateFileList_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for generateFileList()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.generateFileListResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.generateFileListResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("generateFileList() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("generateFileList Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from generateFileList()");
        GenerateFileListResponseDocument_V1 response = (GenerateFileListResponseDocument_V1)obj;
        return response;
    }

    @Override
    public String[] generate(FileStat[] fileStats) throws CloudCompilerException {
        CloudCLogger.clogger.fine("Entering generate()");
        GenerateDocument_V1 inDoc = new GenerateDocument_V1(fileStats);
        GenerateResponseDocument_V1 outDoc = this.generate(inDoc);
        String[] result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving generate()");
        return result;
    }

    public GenerateResponseDocument_V1 generate(GenerateDocument_V1 request) throws CloudCompilerException {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.generate_1_instance);
            envelope.setGenerateDocument_V1(request);
            CloudCLogger.clogger.finer("Sending generate()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("generate() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.generate_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("generate() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.generate_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "generate() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.generate_1_instance.getName() + " method ", ex);
        }
        GenerateResponseDocument_V1 response = this.generate_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenerateResponseDocument_V1 generate_wait() throws CloudCompilerException {
        CloudCompilerException excep1;
        CloudCLogger.clogger.finer("Waiting for generate()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.generateResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.generateResponse_1_instance.getMethod());
        }
        if ((excep1 = (CloudCompilerException)this.session.getUserProperties().get("raiseCloudCompilerException")) != null) {
            this.session.getUserProperties().remove("raiseCloudCompilerException");
            throw excep1;
        }
        WebSocketException excep2 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException");
        if (excep2 != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep2;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("generate() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("generate Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from generate()");
        GenerateResponseDocument_V1 response = (GenerateResponseDocument_V1)obj;
        return response;
    }

    @Override
    public Object getResults() {
        CloudCLogger.clogger.fine("Entering getResults()");
        GetResultsResponseDocument_V1 outDoc = this.getResults(1);
        Object result = outDoc.getResult();
        CloudCLogger.clogger.fine("Leaving getResults()");
        return result;
    }

    public GetResultsResponseDocument_V1 getResults(int dummy) {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.getResults_1_instance);
            CloudCLogger.clogger.finer("Sending getResults()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("getResults() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.getResults_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("getResults() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.getResults_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "getResults() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.getResults_1_instance.getName() + " method ", ex);
        }
        GetResultsResponseDocument_V1 response = this.getResults_wait();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResultsResponseDocument_V1 getResults_wait() {
        WebSocketException excep1;
        CloudCLogger.clogger.finer("Waiting for getResults()");
        Integer timeout = (Integer)this.session.getUserProperties().get("timeout");
        if (timeout == null) {
            timeout = 25;
        }
        Session session = this.session;
        synchronized (session) {
            try {
                this.session.wait(timeout * 1000);
            }
            catch (InterruptedException ex) {
                System.out.println("Synchronous RPC Interrupted");
            }
        }
        Object obj = this.session.getUserProperties().get(CloudCMethods.getResultsResponse_1_instance.getMethod());
        if (obj != null) {
            this.session.getUserProperties().remove(CloudCMethods.getResultsResponse_1_instance.getMethod());
        }
        if ((excep1 = (WebSocketException)this.session.getUserProperties().get("raiseWebSocketException")) != null) {
            this.session.getUserProperties().remove("raiseWebSocketException");
            throw excep1;
        }
        if (obj == null) {
            CloudCLogger.clogger.warning("getResults() throwing WebRpcClientException Timed out");
            throw new WebRpcTimedout("getResults Method Timed Out");
        }
        CloudCLogger.clogger.finer("Returning from getResults()");
        GetResultsResponseDocument_V1 response = (GetResultsResponseDocument_V1)obj;
        return response;
    }

    public void raiseWebSocketException(WebSocketException request) {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.raiseWebSocketException_1_instance);
            envelope.setWebSocketException(request);
            CloudCLogger.clogger.finer("Sending raiseWebSocketException()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("raiseWebSocketException() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.raiseWebSocketException_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("raiseWebSocketException() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.raiseWebSocketException_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "raiseWebSocketException() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.raiseWebSocketException_1_instance.getName() + " method ", ex);
        }
    }

    public void raiseCloudCompilerException(CloudCompilerException request) {
        try {
            CloudCEnvelope_V1 envelope = new CloudCEnvelope_V1();
            envelope.setMethod(CloudCMethods.raiseCloudCompilerException_1_instance);
            envelope.setCloudCompilerException(request);
            CloudCLogger.clogger.finer("Sending raiseCloudCompilerException()");
            this.sendObject(this.session, envelope);
        }
        catch (EncodeException ex) {
            CloudCLogger.clogger.warning("raiseCloudCompilerException() throwing EncodeException");
            throw new WebRpcClientException("Encode Exception encoding " + CloudCMethods.raiseCloudCompilerException_1_instance.getName() + " method ", ex);
        }
        catch (IOException ex) {
            CloudCLogger.clogger.warning("raiseCloudCompilerException() throwing IOException");
            throw new WebRpcClientException("IOException Encoding " + CloudCMethods.raiseCloudCompilerException_1_instance.getName() + " method ", ex);
        }
        catch (RuntimeException ex) {
            CloudCLogger.clogger.log(Level.WARNING, "raiseCloudCompilerException() throwing {0}", ex.getClass().toString());
            throw new WebRpcClientException("Unknown Runtime Exception Encoding " + CloudCMethods.raiseCloudCompilerException_1_instance.getName() + " method ", ex);
        }
    }

    private void sendObject(Session session, CloudCEnvelope envelope) throws IOException, EncodeException {
        switch (envelope.getMessageType()) {
            case Binary: {
                session.getBasicRemote().sendObject(envelope);
                break;
            }
            case Text: {
                CloudCTextStreamEnvelopeEncodeDecode marshaller = new CloudCTextStreamEnvelopeEncodeDecode();
                StringWriter sw = new StringWriter();
                marshaller.encode(envelope, (Writer)sw);
                session.getBasicRemote().sendText(sw.toString());
                break;
            }
        }
    }
}

