/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.common.files;

import com.objectriver.cloudcompiler.cloudc.common.enums.FileStat;
import com.objectriver.cloudcompiler.common.files.FileTreeException;
import com.objectriver.runtime.util.ArrayIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileTree {
    public static ArrayList<File> getFilesInDir(File dir) throws FileTreeException {
        ArrayList<File> list = new ArrayList<File>();
        if (!dir.exists()) {
            throw new FileTreeException(dir.toString() + "does not exist");
        }
        if (!dir.isDirectory()) {
            throw new FileTreeException(dir.toString() + "is not a directory");
        }
        ArrayIterator iter = new ArrayIterator(dir.listFiles());
        while (iter.hasNext()) {
            File file = (File)iter.next();
            if (file.isDirectory()) {
                ArrayList<File> filelist = FileTree.getFilesInDir(file);
                list.addAll(filelist);
                continue;
            }
            list.add(file);
        }
        return list;
    }

    public static List<String> getRelativeList(String uuid, String outDir, List<File> filelist) {
        ArrayList<String> list = new ArrayList<String>();
        for (File file : filelist) {
            String fileString = file.getPath();
            int indexOfUuid = fileString.indexOf(uuid);
            if (indexOfUuid != -1) {
                fileString = fileString.substring(fileString.indexOf(uuid) + uuid.length() + 1);
            }
            if ((fileString = fileString.replace('\\', '/')).startsWith(outDir = outDir.replace('\\', '/'))) {
                fileString = fileString.substring(outDir.length());
            }
            if (fileString.startsWith("/")) {
                fileString = fileString.substring(1);
            }
            list.add(fileString);
        }
        return list;
    }

    public static List<FileStat> getFileStats(String rootdir, List<String> filelist) throws FileTreeException {
        ArrayList<FileStat> list = new ArrayList<FileStat>();
        Iterator<String> iter = filelist.iterator();
        while (iter.hasNext()) {
            File file = new File(rootdir + File.separator + iter.next());
            if (!file.exists()) {
                list.add(FileStat.DoesNotExist_instance);
                continue;
            }
            if (!file.canWrite()) {
                list.add(FileStat.ReadOnly_instance);
                continue;
            }
            list.add(FileStat.Exist_instance);
        }
        return list;
    }
}

