/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.common.zip;

import com.sun.misc.IOUtils_OpenJdk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipStream {
    public static void main(String[] args) throws Exception {
        ZipStream zip = new ZipStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        zip.zip(baos, "F:\\ct_view\\testing\\webrpc\\wrpc\\templates", "^.*(?:tmpl|xml).*", false);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        zip.unzip(bais, "F:\\ct_view\\testing\\webrpc\\wrpc\\fred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(OutputStream os, String directoryPathStr, final String pattern, boolean traditional) throws IOException {
        try (ZipOutputStream zos = null;){
            this.checkValidDirectory(directoryPathStr);
            zos = new ZipOutputStream(os);
            Path directoryPath = FileSystems.getDefault().getPath(directoryPathStr, new String[0]);
            File directoryPathFile = directoryPath.toFile();
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) throws IOException {
                    boolean accept = false;
                    if (pattern == null) {
                        accept = true;
                    } else {
                        File file = path.toFile();
                        if (file.isDirectory()) {
                            accept = true;
                        } else if (file.isFile() && Pattern.matches(pattern, file.getName())) {
                            accept = true;
                        }
                    }
                    return accept;
                }
            };
            if (traditional) {
                this.zipRecursive(zos, directoryPath, filter, directoryPathFile.getName());
            } else {
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directoryPath, (DirectoryStream.Filter<? super Path>)filter);
                for (Path entity : directoryStream) {
                    File entityFile = entity.toFile();
                    String entityPathName = entityFile.getName();
                    if (entityFile.isFile()) {
                        this.zipFile(zos, entity, entityFile, entityPathName);
                        continue;
                    }
                    if (!entityFile.isDirectory()) continue;
                    this.zipRecursive(zos, entity, filter, entityPathName);
                }
            }
        }
    }

    protected void zipRecursive(ZipOutputStream zos, Path directoryPath, DirectoryStream.Filter<Path> filter, String relativePath) throws IOException {
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directoryPath, filter);
        ZipEntry dirZipEntry = new ZipEntry(relativePath + "/");
        zos.putNextEntry(dirZipEntry);
        zos.closeEntry();
        for (Path entity : directoryStream) {
            File entityFile = entity.toFile();
            String entityPathName = relativePath + File.separator + entityFile.getName();
            if (entityFile.isFile()) {
                this.zipFile(zos, entity, entityFile, entityPathName);
                continue;
            }
            if (!entityFile.isDirectory()) continue;
            this.zipRecursive(zos, entity, filter, entityPathName);
        }
        directoryStream.close();
    }

    private void zipFile(ZipOutputStream zos, Path entity, File entityFile, String entityPathName) throws IOException {
        ZipEntry zipEntry = new ZipEntry(entityPathName);
        long fileSize = entityFile.length();
        zipEntry.setSize(fileSize);
        zos.putNextEntry(zipEntry);
        long bytesCopied = Files.copy(entity, zos);
        if (bytesCopied != fileSize) {
            throw new IOException("unable to copy all data from: " + entity);
        }
        zos.closeEntry();
    }

    private void checkValidDirectory(String directoryPathStr) throws IOException {
        File directoryToZip = new File(directoryPathStr);
        if (!directoryToZip.exists()) {
            throw new IOException("directory: '" + directoryPathStr + "' does not exist.");
        }
        if (!directoryToZip.isDirectory()) {
            throw new IOException("path: '" + directoryPathStr + "' is not a directory.");
        }
        if (!directoryToZip.canRead()) {
            throw new IOException("directory: '" + directoryPathStr + "' is unreadable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(InputStream is, String destinationDirectoryPathStr) throws IOException {
        try (ZipInputStream zis = null;){
            this.checkValidDirectory(destinationDirectoryPathStr);
            Path destinationDirectoryPath = FileSystems.getDefault().getPath(destinationDirectoryPathStr, new String[0]);
            File destinationDirectoryFile = destinationDirectoryPath.toFile();
            if (!destinationDirectoryFile.canWrite()) {
                throw new IOException("directory: '" + destinationDirectoryFile + "' is un-writable.");
            }
            String parentPath = destinationDirectoryFile.getAbsolutePath();
            zis = new ZipInputStream(is);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                String relativeEntityName = zipEntry.getName();
                String absoluteEntityName = parentPath + File.separator + relativeEntityName;
                Path entityPath = FileSystems.getDefault().getPath(absoluteEntityName, new String[0]);
                File entityFile = entityPath.toFile();
                if (zipEntry.isDirectory()) {
                    entityFile.mkdir();
                } else {
                    long size = zipEntry.getSize();
                    byte[] data = IOUtils_OpenJdk.readFully(zis, (int)size, false);
                    Files.write(entityPath, data, new OpenOption[0]);
                }
                zipEntry = zis.getNextEntry();
            }
        }
    }
}

