/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.plugin_common.metamodel;

import com.objectriver.cloudcompiler.plugin_common.metamodel.ParseCcException;
import com.objectriver.cloudcompiler.plugin_common.metamodel.beans.CcMetaModel;
import com.objectriver.cloudcompiler.plugin_common.metamodel.beans.CcMetaModelSingleton;
import com.objectriver.cloudcompiler.plugin_common.metamodel.beans.CcModelLanguage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.stream.JsonParser;

public class ParseCcMetaModel {
    public static void main(String[] args) {
        List<CcMetaModel> list = CcMetaModelSingleton.getInstance().getMetaModels();
        System.out.println("OK");
    }

    public static List<CcMetaModel> parseCcMetaModel(String url) throws ParseCcException {
        try {
            return ParseCcMetaModel.parseCcMetaModel(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw new ParseCcException("MalformedURLException with " + url.toString() + " " + ex.getMessage());
        }
    }

    public static List<CcMetaModel> parseCcMetaModel(URL url) throws ParseCcException {
        try {
            URLConnection connection = url.openConnection();
            connection.connect();
            InputStreamReader isr = new InputStreamReader(connection.getInputStream());
            return ParseCcMetaModel.parseCcMetaModel(isr);
        }
        catch (IOException ex) {
            throw new ParseCcException("IOException with " + url.toString() + " " + ex.getMessage());
        }
    }

    public static List<CcMetaModel> parseCcMetaModel(Reader is) throws ParseCcException {
        JsonParser parser = Json.createParser(is);
        if (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            if (event != JsonParser.Event.START_OBJECT) {
                throw new ParseCcException("Expecting Document Start?");
            }
            if (parser.hasNext()) {
                return ParseCcMetaModel.parserCcMetaModelList(parser);
            }
        }
        return new ArrayList<CcMetaModel>();
    }

    public static List<CcMetaModel> parserCcMetaModelList(JsonParser parser) throws ParseCcException {
        ArrayList<CcMetaModel> list = new ArrayList<CcMetaModel>();
        JsonParser.Event event = parser.next();
        if (event != JsonParser.Event.KEY_NAME) {
            new ParseCcException("Expecting MetaModel array name?");
        }
        String arrayname = parser.getString();
        event = parser.next();
        if (event != JsonParser.Event.START_ARRAY) {
            new ParseCcException("Expecting start of MetaModel array?");
        }
        event = parser.next();
        while (true) {
            if (event == JsonParser.Event.END_ARRAY) break;
            CcMetaModel model = ParseCcMetaModel.parserCcMetaModel(event, parser);
            list.add(model);
            event = parser.next();
        }
        return list;
    }

    public static CcMetaModel parserCcMetaModel(JsonParser.Event event, JsonParser parser) throws ParseCcException {
        if (event != JsonParser.Event.START_OBJECT) {
            new ParseCcException("Expecting Document Start?");
        }
        event = parser.next();
        CcMetaModel metaModel = new CcMetaModel("model");
        while (true) {
            if (event == JsonParser.Event.END_OBJECT) break;
            String key = parser.getString();
            event = parser.next();
            block9 : switch (key) {
                case "enabled": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        metaModel.setEnabled(true);
                        break;
                    }
                    metaModel.setEnabled(false);
                    break;
                }
                case "show_client_server": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        metaModel.setShow_client_server(true);
                        break;
                    }
                    metaModel.setShow_client_server(false);
                    break;
                }
                case "show_web_servers": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        metaModel.setShow_web_servers(true);
                        break;
                    }
                    metaModel.setShow_web_servers(false);
                    break;
                }
                case "model_extension": {
                    metaModel.setModel_extension(parser.getString());
                    metaModel.setIdentifier(metaModel.getModel_extension());
                    break;
                }
                case "model_label": {
                    metaModel.setModel_label(parser.getString());
                    break;
                }
                case "model_languages": {
                    if (event != JsonParser.Event.START_ARRAY) {
                        new ParseCcException("Expecting Language Array?");
                    }
                    event = parser.next();
                    while (true) {
                        if (event == JsonParser.Event.END_ARRAY) break block9;
                        CcModelLanguage language = ParseCcMetaModel.parserCcModelLanguage(event, parser);
                        language.setParent(metaModel);
                        metaModel.getModel_languages().add(language);
                        event = parser.next();
                    }
                }
                case "web_servers": {
                    if (event != JsonParser.Event.START_ARRAY) {
                        new ParseCcException("Expecting Language Array?");
                    }
                    event = parser.next();
                    while (true) {
                        if (event == JsonParser.Event.END_ARRAY) break block9;
                        metaModel.getWeb_servers().add(parser.getString());
                        event = parser.next();
                    }
                }
                default: {
                    ParseCcMetaModel.skipEvent(event, parser);
                }
            }
            event = parser.next();
        }
        return metaModel;
    }

    public static CcModelLanguage parserCcModelLanguage(JsonParser.Event event, JsonParser parser) throws ParseCcException {
        if (event != JsonParser.Event.START_OBJECT) {
            new ParseCcException("Expecting ModelLanguage Start?");
        }
        event = parser.next();
        CcModelLanguage modelLanguage = new CcModelLanguage("language");
        while (true) {
            if (event == JsonParser.Event.END_OBJECT) break;
            String key = parser.getString();
            event = parser.next();
            switch (key) {
                case "language_option": {
                    modelLanguage.setLanguage_option(parser.getString());
                    modelLanguage.setIdentifier(modelLanguage.getLanguage_option());
                    break;
                }
                case "language_menu": {
                    modelLanguage.setLanguage_menu(parser.getString());
                    break;
                }
                case "src_default": {
                    modelLanguage.setDefault_src(parser.getString());
                    break;
                }
                case "enable_client": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        modelLanguage.setEnable_client(true);
                        break;
                    }
                    modelLanguage.setEnable_client(false);
                    break;
                }
                case "enable_server": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        modelLanguage.setEnable_server(true);
                        break;
                    }
                    modelLanguage.setEnable_server(false);
                    break;
                }
                case "show_src_dir": {
                    if (event == JsonParser.Event.VALUE_TRUE) {
                        modelLanguage.setShow_src_dir(true);
                        break;
                    }
                    modelLanguage.setShow_src_dir(false);
                    break;
                }
                default: {
                    ParseCcMetaModel.skipEvent(event, parser);
                }
            }
            event = parser.next();
        }
        return modelLanguage;
    }

    private static void skipEvent(JsonParser.Event event, JsonParser parser) throws ParseCcException {
        switch (event) {
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: {
                break;
            }
            case KEY_NAME: 
            case VALUE_STRING: {
                String debug = parser.getString();
                break;
            }
            case VALUE_NUMBER: {
                parser.getBigDecimal();
                break;
            }
            case START_ARRAY: {
                ParseCcMetaModel.skipArray(event, parser);
                break;
            }
            case START_OBJECT: {
                ParseCcMetaModel.skipObject(event, parser);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                break;
            }
            default: {
                throw new ParseCcException("Unexpected Event!" + event.toString());
            }
        }
    }

    private static void skipObject(JsonParser.Event event, JsonParser parser) throws ParseCcException {
        event = parser.next();
        while (event != JsonParser.Event.END_OBJECT) {
            ParseCcMetaModel.skipEvent(event, parser);
            event = parser.next();
        }
    }

    private static void skipArray(JsonParser.Event event, JsonParser parser) throws ParseCcException {
        event = parser.next();
        while (event != JsonParser.Event.END_ARRAY) {
            ParseCcMetaModel.skipEvent(event, parser);
            event = parser.next();
        }
    }
}

