/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.cloudcompiler.plugin_common.metamodel.beans;

import com.objectriver.cloudcompiler.plugin_common.metamodel.ParseCcException;
import com.objectriver.cloudcompiler.plugin_common.metamodel.ParseCcMetaModel;
import com.objectriver.cloudcompiler.plugin_common.metamodel.beans.CcMetaModel;
import java.io.File;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.List;

public class CcMetaModelSingleton {
    private boolean isDefault = false;
    private List<CcMetaModel> ccmmList = null;
    private static CcMetaModelSingleton INSTANCE = null;
    private static String defaultModel = "{\n    \"models\" : [\n        {\n            \"enabled\" : true,\n            \"model_extension\" : \"rest\",\n            \"model_label\"   : \"(JAX-RS2.0 Jersey)rest\",\n            \"show_client_server\": true,\n            \"model_languages\" : [\n                {\n                    \"language_option\" : \"java\",\n                    \"language_menu\" : \"Java\",\n                    \"enable_client\" : true,\n                    \"enable_server\" : true,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"java\"\n                },\n                {\n                    \"language_option\" : \"apex\",\n                    \"language_menu\" : \"Apex(SalesForce)\",\n                    \"enable_client\" : true,\n                    \"enable_server\" : true,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"sfdc\"\n                },\n                {\n                    \"language_option\" : \"node\",\n                    \"language_menu\" : \"JavaScript(Node.js)\",\n                    \"enable_client\" : true,\n                    \"enable_server\" : true,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"node\"\n                },\n                {\n                    \"language_option\" : \"angular\",\n                    \"language_menu\" : \"Angular(Rest)\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : false,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"src\"\n                },\t\t\t\t\n                {\n                    \"language_option\" : \"angular_ws\",\n                    \"language_menu\" : \"Angular(WebSockets)\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : false,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"src\"\n                },\t\n                {\n                    \"language_option\" : \"meta_ws\",\n                    \"language_menu\" : \"Meta-WebSockets\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : false,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"model\"\n                },\n\t\t\t\t{\n                    \"language_option\" : \"meta_ws_callback\",\n                    \"language_menu\" : \"Meta-WebSockets Callback\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : false,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"model\"\n                }\t\t\t\t\t\t\n            ],\n            \"show_web_servers\" : false,\n            \"web_servers\" : []\n        },\n        {\n            \"enabled\" : true,\n            \"model_extension\" : \"webrpc\",\n            \"model_label\"   : \"(WebSockets)webrpc\",\n            \"show_client_server\": true,\n            \"model_languages\" : [\n                {\n                    \"language_option\" : \"java\",\n                    \"language_menu\" : \"Java\",\n                    \"enable_client\" : true,\n                    \"enable_server\" : true,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"java\"\n                },\n                {\n                    \"language_option\" : \"node_ts\",\n                    \"language_menu\" : \"TypeScript(Node.js Server)\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : true,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"node/server\"\n                },\t\t\t\t\n                {\n                    \"language_option\" : \"angular_ws_server\",\n                    \"language_menu\" : \"Angular(WebSockets) Callback\",\n                    \"enable_client\" : false,\n                    \"enable_server\" : false,\n                    \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"src\"\t\t\t\t\t\n                }\t\t\t\t\t\n            ],\n            \"show_web_servers\" : false,\n            \"web_servers\" : [\"TYRUS\", \"GLASSFISH\", \"TOMCAT\", \"WILDFLY\", \"JETTY\", \"WEBLOGIC\"]\n        },\n        {\n            \"enabled\" : true,\n            \"model_extension\" : \"jdo\",\n            \"model_label\"   : \"(MongoJDO)jdo\",\n            \"show_client_server\": false,\n            \"model_languages\" : [\n                 {\n                     \"language_option\" : \"java\",\n                     \"language_menu\" : \"Java\",\n                     \"enable_client\" : false,\n                     \"enable_server\" : false,\n                     \"show_src_dir\": true,\n\t\t\t\t\t\"src_default\": \"src\"\t\t\t\t\t\t \n                 }\n             ],\n             \"show_web_servers\" : false,\n             \"web_servers\" : []\n         }\n    ]\n}";

    private CcMetaModelSingleton() {
        if (INSTANCE == null) {
            try {
                String metaModels = System.getenv("OR_METAMODELS");
                if (metaModels != null) {
                    File file = new File(metaModels);
                    this.ccmmList = ParseCcMetaModel.parseCcMetaModel(file.toURL());
                } else {
                    this.ccmmList = ParseCcMetaModel.parseCcMetaModel("https://objectriver.net/cloudcompiler/MetaModels.json");
                }
                this.isDefault = false;
            }
            catch (ParseCcException | MalformedURLException ex) {
                StringReader sr = new StringReader(defaultModel);
                try {
                    this.ccmmList = ParseCcMetaModel.parseCcMetaModel(sr);
                    this.isDefault = true;
                }
                catch (ParseCcException parseCcException) {
                    // empty catch block
                }
            }
        }
    }

    public static synchronized CcMetaModelSingleton getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CcMetaModelSingleton();
        }
        return INSTANCE;
    }

    public List<CcMetaModel> getMetaModels() {
        return this.ccmmList;
    }

    public CcMetaModel getMetaModelByLabel(String label) {
        for (CcMetaModel model : this.ccmmList) {
            if (!model.getModel_label().equalsIgnoreCase(label)) continue;
            return model;
        }
        return null;
    }

    public CcMetaModel getMetaModelByExtension(String fileExtension) {
        for (CcMetaModel model : this.ccmmList) {
            if (!model.getModel_extension().equalsIgnoreCase(fileExtension)) continue;
            return model;
        }
        return null;
    }
}

