/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp;

import com.objectriver.compiler.cpp.CppException;
import com.objectriver.compiler.cpp.CppWriter;
import com.objectriver.compiler.cpp.MacroManager;
import com.objectriver.compiler.cpp.SourceReader;
import com.objectriver.compiler.cpp.TruthStack;
import com.objectriver.compiler.cpp.ifdef.IfDefParser;
import com.objectriver.compiler.lang.ParseException;
import com.objectriver.runtime.util.resource.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;

public class Cpp
extends Thread {
    private SourceReader _sourceReader;
    private MacroManager _macroManager = new MacroManager();
    private TruthStack _truthStack = new TruthStack();
    private Resource[] _includes;
    private StringBuffer _emit = null;
    private Stack _emitStack = new Stack();
    private Stack _fileStack = new Stack();
    private Resource _theFile;
    private CppWriter _writer;
    private boolean preserveComments = false;
    private boolean preserveCPlusPlusComments = false;
    private static final HashMap _directives = new HashMap();

    private Cpp(Reader reader, Resource file, Resource[] includes, String[] defines) {
        this._theFile = file;
        this._theFile.setReader(reader);
        this._sourceReader = new SourceReader(this);
        if (this._theFile.exists() && this._theFile.isFile()) {
            this._sourceReader.setFile(this._theFile);
        }
        this._includes = includes;
        if (defines != null) {
            for (int ii = 0; ii < defines.length; ++ii) {
                String define = defines[ii];
                if (define.indexOf(61) == -1) {
                    define = define + "=1";
                }
                this._macroManager.rememberMacro(define);
            }
        }
    }

    public static PipedReader preprocess(Resource input, Resource[] includes, String[] defines, boolean preserveComments) throws IOException {
        if (!input.exists()) {
            throw new FileNotFoundException(input.getPath());
        }
        if (!input.canRead()) {
            throw new IOException(input.getPath() + " not readable?");
        }
        Cpp cpp = new Cpp(input.getBufferedReader(), input, includes, defines);
        cpp.setPreserveComments(preserveComments);
        PipedWriter _pipedWriter = new PipedWriter();
        cpp.set_writer(new CppWriter(_pipedWriter));
        cpp.start();
        PipedReader pipedReader = new PipedReader(_pipedWriter);
        return pipedReader;
    }

    public static void preprocess(Resource input, Resource[] includes, String[] defines, boolean preserveComments, Writer writer) throws IOException {
        if (!input.exists()) {
            throw new FileNotFoundException(input.getPath());
        }
        if (!input.canRead()) {
            throw new IOException(input.getPath() + " not readable?");
        }
        Cpp cpp = new Cpp(input.getBufferedReader(), input, includes, defines);
        cpp.setPreserveComments(preserveComments);
        cpp.set_writer(new CppWriter(writer));
        cpp.start();
    }

    public void set_writer(CppWriter _writer) {
        this._writer = _writer;
    }

    private void preprocess() {
        String curLine = null;
        try {
            while ((curLine = this._sourceReader.getNextLine()) != null) {
                this._writer.write(this.process(curLine));
                this._writer.write(10);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-9);
        }
        catch (CppException e) {
            e.printStackTrace();
            System.exit(-9);
        }
    }

    @Override
    public void run() {
        this.preprocess();
        try {
            this._writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void emitPoundLine(SourceReader sr) throws CppException {
        try {
            this._writer.write("#line " + sr.currentLine() + " " + sr.currentFile() + "\n");
        }
        catch (IOException io) {
            throw new CppException("Write Failed?" + io.getMessage(), this._sourceReader.currentFilename(), this._sourceReader.currentLine());
        }
    }

    private void setFile(Resource theFile) {
        this._theFile = theFile;
    }

    public void pushState(Resource theFile) throws CppException {
        this.emitPoundLine(this._sourceReader);
        this._sourceReader.pushState(theFile);
        if (this._theFile != null) {
            this._fileStack.push(this._theFile);
        }
        if (this._emit != null) {
            this._emitStack.push(this._emit);
        }
        this.setFile(theFile);
        this.emitPoundLine(this._sourceReader);
    }

    public void popState() throws CppException {
        this._sourceReader.popState();
        if (!this._emitStack.empty()) {
            StringBuffer _emitCurrent = this._emit;
            this._emit = (StringBuffer)this._emitStack.peek();
            this._emitStack.pop();
            try {
                this._writer.write(_emitCurrent.toString());
            }
            catch (IOException io) {
                throw new CppException("Write Failed?" + io.getMessage(), this._sourceReader.currentFilename(), this._sourceReader.currentLine());
            }
        }
        if (!this._fileStack.empty()) {
            this._theFile = (Resource)this._fileStack.peek();
            this._fileStack.pop();
        }
        this.emitPoundLine(this._sourceReader);
    }

    public void setIncludes(Resource[] incs) {
        if (incs != null) {
            this._includes = incs;
        }
    }

    private String process(String line) throws CppException {
        int loc = line.indexOf("#");
        if (loc == -1) {
            return this.scan(line);
        }
        if (line.trim().charAt(0) != '#') {
            return this.scan(line);
        }
        return this.processDirective(line.substring(loc, line.length()), true);
    }

    private String scan(String line) {
        if (line == null || line.length() == 0) {
            return "";
        }
        if (this._truthStack.peek() == this._truthStack.T) {
            return this._macroManager.expandMacros(line);
        }
        return "";
    }

    private String stripComments(String line) {
        int cComment = line.indexOf("/*");
        int cppComment = line.indexOf("//");
        String strippedLine = line.trim();
        if (cComment > -1 && !this.inQuote(line, cComment)) {
            strippedLine = line.substring(0, cComment).trim();
        }
        if (cppComment > -1 && !this.inQuote(line, cppComment) && cppComment < strippedLine.length()) {
            strippedLine = line.substring(0, cppComment).trim();
        }
        return strippedLine;
    }

    private String processDirective(String directive, boolean alone) throws CppException {
        int endOfDirective;
        String originalDirective = directive;
        directive = directive.substring(1, directive.length()).trim();
        for (endOfDirective = 0; endOfDirective < directive.length() && !Character.isWhitespace(directive.charAt(endOfDirective)); ++endOfDirective) {
        }
        String dArgs = this.stripComments(directive.substring(endOfDirective, directive.length()));
        Integer dInteger = (Integer)_directives.get(directive.substring(0, endOfDirective));
        if (dInteger == null) {
            return originalDirective;
        }
        switch (dInteger) {
            case 0: {
                this.handleNullDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 1: {
                this.handleIfDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 2: {
                this.handleIfdefDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 3: {
                this.handleIfndefDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 4: {
                this.handleElifDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 5: {
                this.handleElseDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 6: {
                this.handleEndifDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 7: {
                if (this._truthStack.empty() || this._truthStack.peek() == this._truthStack.T) {
                    this.handleIncludeDirective(dArgs);
                }
                if (!alone) break;
                return "";
            }
            case 13: {
                if (this._truthStack.empty() || this._truthStack.peek() == this._truthStack.T) {
                    this.handleImportDirective(dArgs);
                }
                if (!alone) break;
                return "";
            }
            case 8: {
                this.handleDefineDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 9: {
                this.handleUndefDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 10: {
                this.handleLineDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 11: {
                if (this._truthStack.empty() || this._truthStack.peek() == this._truthStack.T) {
                    this.handleErrorDirective(dArgs);
                }
                if (!alone) break;
                return "";
            }
            case 12: {
                this.handlePragmaDirective(dArgs);
                if (!alone) break;
                return "";
            }
            case 14: {
                if (this._truthStack.empty() || this._truthStack.peek() == this._truthStack.T) {
                    this.handleIncludeCodesDirective(dArgs);
                }
                if (!alone) break;
                return "";
            }
            default: {
                this.handleBogusDirective(dArgs);
                if (!alone) break;
                return "";
            }
        }
        return null;
    }

    private void handleNullDirective(String dArgs) {
    }

    private void handleErrorDirective(String dArgs) throws CppException {
        this.addError("Cpp #error statement encountered: " + dArgs);
    }

    private void handlePragmaDirective(String dArgs) {
    }

    private void handleBogusDirective(String dArgs) throws CppException {
    }

    private boolean evaluateExpression_complex(String expression) {
        String expr_expanded = this._macroManager.expandMacros(expression).trim();
        IfDefParser parser = new IfDefParser(new StringBufferInputStream(expr_expanded));
        try {
            boolean ok = parser.EvaluateExpression(this._macroManager.getMacros());
            return ok;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean evaluateExpression(String expression) {
        String expr = expression;
        boolean not = false;
        if (expression.startsWith("!")) {
            not = true;
            expression = expression.substring(1);
        }
        if (expression.startsWith("defined(")) {
            String macroName = expression.substring(8);
            macroName = macroName.substring(0, macroName.length() - 1);
            if (this._macroManager.getMacros().containsKey(macroName)) {
                return !not;
            }
        } else if (expression.startsWith("defined")) {
            String macroName = expression.substring(8);
            if (this._macroManager.getMacros().containsKey(macroName)) {
                return !not;
            }
        } else {
            return this.evaluateExpression_complex(expr);
        }
        return not;
    }

    private void handleIfDirective(String expression) {
        if (this._truthStack.peek() == this._truthStack.T) {
            if (this.evaluateExpression_complex(expression)) {
                this._truthStack.push(this._truthStack.T);
            } else {
                this._truthStack.push(this._truthStack.F);
            }
        } else {
            this._truthStack.push(this._truthStack.I);
        }
    }

    private void handleElifDirective(String expression) throws CppException {
        if (this._truthStack.empty()) {
            this.addError("Cpp Found #elif with no matching #if");
            return;
        }
        if (this._truthStack.peek() == this._truthStack.T) {
            this._truthStack.pop();
            this._truthStack.push(this._truthStack.F);
        } else if (this._truthStack.peek() == this._truthStack.F && this.evaluateExpression_complex(expression)) {
            this._truthStack.pop();
            this._truthStack.push(this._truthStack.T);
        }
    }

    private void handleEndifDirective(String line) throws CppException {
        if (this._truthStack.empty()) {
            this.addError("Cpp Found #endif with no matching #if");
        } else {
            this._truthStack.pop();
        }
    }

    private void handleIfdefDirective(String identifier) {
        if (this._macroManager.getMacros().containsKey(identifier)) {
            this._truthStack.push(this._truthStack.T);
        } else {
            this._truthStack.push(this._truthStack.F);
        }
    }

    private void handleIfndefDirective(String identifier) {
        if (this._macroManager.getMacros().containsKey(identifier)) {
            this._truthStack.push(this._truthStack.F);
        } else {
            this._truthStack.push(this._truthStack.T);
        }
    }

    private void handleElseDirective(String line) throws CppException {
        if (this._truthStack.empty()) {
            this.addError("Cpp Found #else with no matching #if");
        } else if (this._truthStack.peek() == this._truthStack.T) {
            this._truthStack.pop();
            this._truthStack.push(this._truthStack.F);
        } else if (this._truthStack.peek() == this._truthStack.F) {
            this._truthStack.pop();
            this._truthStack.push(this._truthStack.T);
        }
    }

    private void handleImportDirective(String fileString) throws CppException {
        try {
            this._writer.write("#BeginImport\n");
            this.handleIncludeDirective(fileString);
            this._writer.write("#EndImport\n");
        }
        catch (IOException io) {
            throw new CppException("Write Failed?" + io.getMessage(), this._sourceReader.currentFilename(), this._sourceReader.currentLine());
        }
    }

    private void handleIncludeDirective(String fileString) throws CppException {
        if (fileString.length() < 3) {
            return;
        }
        fileString = this._macroManager.expandMacros(fileString).trim();
        char firstChar = fileString.charAt(0);
        char lastChar = fileString.charAt(fileString.length() - 1);
        boolean quoteDelimiters = false;
        if (firstChar == '\"' && lastChar == '\"') {
            quoteDelimiters = true;
        } else if (firstChar != '<' || lastChar != '>') {
            this.addError("Cpp IncludeName must be enclosed by matching <...> or \"...\"");
            return;
        }
        fileString = fileString.substring(1, fileString.length() - 1);
        Resource theFile = this.findFile(fileString);
        if (theFile != null) {
            this.pushState(theFile);
            this.setFile(theFile);
            this.preprocess();
            this.popState();
        }
    }

    private void handleIncludeCodesDirective(String enumfile) throws CppException {
        try {
            this._writer.write("BeginCSV {\n");
            this.handleIncludeDirective(enumfile);
            this._writer.write("}\n");
        }
        catch (IOException io) {
            throw new CppException("Write Failed?" + io.getMessage(), this._sourceReader.currentFilename(), this._sourceReader.currentLine());
        }
    }

    private void handleLineDirective(String dArgs) throws CppException {
        try {
            this._writer.write("#line " + dArgs + "\n");
        }
        catch (IOException io) {
            throw new CppException("Write Failed?" + io.getMessage(), this._sourceReader.currentFilename(), this._sourceReader.currentLine());
        }
    }

    private void handleDefineDirective(String line) {
        if (this._truthStack.peek() == this._truthStack.T) {
            String macro = line.trim();
            this._macroManager.rememberMacro(macro);
        }
    }

    private void handleUndefDirective(String identifier) {
        if (this._truthStack.peek() == this._truthStack.T) {
            this._macroManager.forgetMacro(identifier);
        }
    }

    public void addError(String theText) throws CppException {
        throw new CppException(theText, this._sourceReader.currentFilename(), this._sourceReader.currentLine());
    }

    private Resource findFile(String fileName) throws CppException {
        String fileMayHaveSpaces;
        Resource currentDirectory = this._sourceReader.currentFile().getParent();
        Resource member = currentDirectory.getMember(fileMayHaveSpaces = fileName.replaceAll("%20", " "));
        if (member != null) {
            return member;
        }
        if (this._includes != null) {
            for (int i = 0; i < this._includes.length; ++i) {
                member = this._includes[i].getMember(fileMayHaveSpaces);
                if (member == null) continue;
                return member;
            }
        }
        this.addError("Preprocessor could not find " + fileMayHaveSpaces);
        return null;
    }

    public boolean isPreserveComments() {
        return this.preserveComments;
    }

    public boolean isPreserveCPlusPlusComments() {
        return this.preserveCPlusPlusComments;
    }

    public void setPreserveComments(boolean preserveComments) {
        this.preserveComments = preserveComments;
    }

    public void setPreserveCPlusPlusComments(boolean preserveComments) {
        this.preserveCPlusPlusComments = preserveComments;
    }

    private boolean inQuote(String line, int position) {
        boolean inquote = false;
        for (int ii = 0; ii < position; ++ii) {
            char character = line.charAt(ii);
            if (character == '\\') {
                ++ii;
                continue;
            }
            if (character != '\"') continue;
            inquote = !inquote;
        }
        return inquote;
    }

    public static void main(String[] args) {
    }

    static {
        _directives.put("", new Integer(0));
        _directives.put("if", new Integer(1));
        _directives.put("ifdef", new Integer(2));
        _directives.put("ifndef", new Integer(3));
        _directives.put("elif", new Integer(4));
        _directives.put("else", new Integer(5));
        _directives.put("endif", new Integer(6));
        _directives.put("include", new Integer(7));
        _directives.put("define", new Integer(8));
        _directives.put("undef", new Integer(9));
        _directives.put("line", new Integer(10));
        _directives.put("error", new Integer(11));
        _directives.put("pragma", new Integer(12));
        _directives.put("import", new Integer(13));
        _directives.put("include_codes", new Integer(14));
    }
}

