/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp;

import java.util.ArrayList;

public class Macro {
    private String _name = null;
    private StringBuffer _replacement = new StringBuffer();
    private int _parameters;
    public boolean _isFunctionStyle = false;

    public Macro(String macroLine) {
        this._name = this.getIdentifier(macroLine.trim());
        if (this._name == null || this._name.length() == macroLine.length()) {
            return;
        }
        char c = macroLine.charAt(this._name.length());
        if (c == '=') {
            this._replacement.append(macroLine.substring(this._name.length() + 1, macroLine.length()).trim());
        } else if (Character.isWhitespace(c)) {
            this._replacement.append(macroLine.substring(this._name.length(), macroLine.length()).trim());
        } else if (c == '(') {
            this._isFunctionStyle = true;
            int closingparen = macroLine.indexOf(41, this._name.length());
            String parameterList = macroLine.substring(this._name.length() + 1, closingparen).trim();
            ArrayList parameters = this.getParameters(parameterList);
            this._parameters = parameters.size();
            this._replacement.append(macroLine.substring(closingparen + 1, macroLine.length()).trim());
            this.augmentReplacement(parameters);
        }
    }

    public String getName() {
        return this._name;
    }

    public StringBuffer getReplacement() {
        return this._replacement;
    }

    public String expand(String parameterList) {
        if (this._replacement == null) {
            return "";
        }
        if (parameterList == null) {
            return this._replacement.toString();
        }
        ArrayList theParams = this.getParameters(parameterList);
        StringBuffer expansion = new StringBuffer(this._replacement.toString());
        for (int i = theParams.size() - 1; i >= 0; --i) {
            int index = 0;
            String theParam = (String)theParams.get(i);
            if (theParam == null) continue;
            while ((index = expansion.toString().indexOf("%%" + i + "%%")) >= 0) {
                expansion.replace(index, index + 5, theParam);
            }
        }
        return expansion.toString();
    }

    private String getIdentifier(String macroLine) {
        char c;
        StringBuffer theIdentifier = new StringBuffer();
        int index = 0;
        int lineLength = macroLine.length();
        while (index < lineLength && Character.isJavaIdentifierPart(c = macroLine.charAt(index++))) {
            theIdentifier.append(c);
        }
        if (theIdentifier.length() == 0) {
            return null;
        }
        return theIdentifier.toString();
    }

    private ArrayList getParameters(String theList) {
        int nextComma;
        ArrayList<String> theParams = new ArrayList<String>();
        if (theList.length() == 0) {
            return theParams;
        }
        if (theList.charAt(0) == '(' && theList.charAt(theList.length() - 1) == ')') {
            theParams.add(theList);
            return theParams;
        }
        while ((nextComma = theList.indexOf(44)) >= 0) {
            theParams.add(theList.substring(0, nextComma).trim());
            theList = theList.substring(nextComma + 1, theList.length());
        }
        theParams.add(theList.trim());
        return theParams;
    }

    private void augmentReplacement(ArrayList theParams) {
        for (int i = theParams.size() - 1; i >= 0; --i) {
            String theParam = (String)theParams.get(i);
            int index = 0;
            int startAt = 0;
            while ((index = this._replacement.toString().indexOf(theParam, startAt)) >= 0) {
                if (this.isValidLocation(index, index + theParam.length() - 1)) {
                    this._replacement.replace(index, index + theParam.length(), "%%" + i + "%%");
                    index += 4;
                }
                startAt = index + 1;
            }
        }
        this._replacement = new StringBuffer(this._replacement.toString().replace('\t', ' '));
    }

    private boolean isValidLocation(int begin, int end) {
        boolean result = false;
        return !(begin != 0 && Character.isJavaIdentifierStart(this._replacement.charAt(begin - 1)) || this._replacement.length() != end + 1 && Character.isJavaIdentifierStart(this._replacement.charAt(end + 1)));
    }

    public static void main(String[] args) {
        Macro m = new Macro("FRED (1)");
        System.out.println(m.getName() + " " + m.getReplacement().toString());
        Macro m1 = new Macro("BARNEY=1");
        System.out.println(m1.getName() + " " + m1.getReplacement().toString());
        Macro m2 = new Macro("RALPH(a, b )  ((a)/(b)");
        String expands = m2.expand("123,345");
        System.out.println(expands);
    }
}

