/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp;

import com.objectriver.compiler.cpp.Macro;
import java.util.Enumeration;
import java.util.Hashtable;

class MacroManager {
    private Hashtable _macros = new Hashtable();

    public void reset() {
        this._macros.clear();
    }

    public Hashtable getMacros() {
        return this._macros;
    }

    public void rememberMacro(String macroLine) {
        Macro theMacro = new Macro(macroLine);
        String theName = theMacro.getName();
        if (theName == null || theName.length() < 1) {
            return;
        }
        if (this._macros.containsKey(theName)) {
            Macro m = (Macro)this._macros.get(theName);
            this._macros.remove(m);
        }
        this._macros.put(theName, theMacro);
    }

    public void forgetMacro(String macroLine) {
        String theName = this.getIdentifier(macroLine, 0);
        if (theName == null || theName.length() < 1) {
            return;
        }
        this._macros.remove(theName);
    }

    private String getIdentifier(String currentLine, int startAt) {
        int endAt;
        int lineLength = currentLine.length();
        while (startAt < lineLength && !Character.isJavaIdentifierStart(currentLine.charAt(startAt))) {
            ++startAt;
        }
        if (startAt >= lineLength) {
            return null;
        }
        for (endAt = startAt + 1; endAt < lineLength && Character.isJavaIdentifierPart(currentLine.charAt(endAt)); ++endAt) {
        }
        return currentLine.substring(startAt, endAt);
    }

    public String expandMacros(String sourceLine) {
        String curId;
        StringBuffer currentLine = new StringBuffer(128).append(sourceLine);
        int startIndex = 0;
        int endIndex = 0;
        String params = null;
        while ((curId = this.getIdentifier(currentLine.toString(), startIndex)) != null && curId.length() != 0) {
            startIndex = currentLine.toString().indexOf(curId, startIndex);
            int oldEndIndex = endIndex = startIndex + curId.length();
            while (endIndex < currentLine.length() && currentLine.charAt(endIndex) == ' ') {
                ++endIndex;
            }
            Macro theMacro = (Macro)this._macros.get(curId);
            if (theMacro != null) {
                if (theMacro._isFunctionStyle && endIndex < currentLine.length() && currentLine.charAt(endIndex) == '(') {
                    int closeParen = this.getClosingParen(currentLine.toString(), endIndex + 1);
                    if (closeParen > endIndex + 1) {
                        params = currentLine.toString().substring(endIndex + 1, closeParen);
                        endIndex = closeParen + 1;
                    }
                } else {
                    endIndex = oldEndIndex;
                }
                String theExpansion = theMacro.expand(params);
                if (theExpansion == null || theExpansion.startsWith("%%")) {
                    theExpansion = "";
                }
                currentLine.replace(startIndex, endIndex, theExpansion);
                startIndex += theExpansion.length();
                continue;
            }
            startIndex = endIndex;
        }
        String result = currentLine.toString().trim();
        if (result.endsWith("defined")) {
            currentLine.append(" 0");
        }
        return currentLine.toString();
    }

    public int getClosingParen(String theLine, int start) {
        int depth = 1;
        int iter = start;
        boolean done = false;
        while (!done && iter < theLine.length()) {
            char c = theLine.charAt(iter);
            if (c == '(') {
                ++depth;
            } else if (c == ')') {
                --depth;
            }
            if (depth == 0) {
                done = true;
                continue;
            }
            ++iter;
        }
        if (depth != 0) {
            iter = -1;
        }
        return iter;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        Enumeration e = this._macros.elements();
        while (e.hasMoreElements()) {
            Macro m = (Macro)this._macros.get(e.nextElement());
            StringBuffer rep = m.getReplacement();
            if (rep == null) {
                rep = new StringBuffer("JEFF");
            }
            out.append(m.getName() + "====" + rep + "\n");
        }
        return out.toString();
    }
}

