/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp;

import com.objectriver.compiler.cpp.Cpp;
import com.objectriver.compiler.cpp.Trimmer;
import com.objectriver.runtime.util.resource.Resource;
import java.util.EmptyStackException;
import java.util.Stack;

class SourceReader {
    private Stack _trimmerStack = new Stack();
    private Trimmer _currentTrimmer;
    private final Cpp cpp;

    public SourceReader(Cpp cpp) {
        this.cpp = cpp;
    }

    public void reset() {
        this._trimmerStack.clear();
    }

    public void setFile(Resource theFile) {
        this._currentTrimmer = new Trimmer(theFile, this.cpp);
    }

    public void pushState(Resource theFile) {
        this._trimmerStack.push(this._currentTrimmer);
        this.setFile(theFile);
    }

    public void popState() {
        try {
            this._currentTrimmer = (Trimmer)this._trimmerStack.pop();
        }
        catch (EmptyStackException e) {
            this._currentTrimmer = null;
        }
    }

    public String getNextLine() {
        if (this._currentTrimmer == null) {
            return null;
        }
        return this._currentTrimmer.readLine();
    }

    public Resource currentFile() {
        return this._currentTrimmer.getTheFile();
    }

    public String currentFilename() {
        return this._currentTrimmer.getFileName();
    }

    public int currentLine() {
        return this._currentTrimmer.getLineNumber();
    }
}

