/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp;

import com.objectriver.compiler.cpp.Cpp;
import com.objectriver.runtime.util.asserts.Assert;
import com.objectriver.runtime.util.resource.Resource;
import java.io.BufferedReader;
import java.io.IOException;

public class Trimmer {
    private Resource theFile = null;
    private String fileName = null;
    private int lineNumber = 1;
    private boolean _inString = false;
    private boolean _inComment = false;
    private boolean _emitLine = false;
    private BufferedReader _reader = null;
    private final Cpp cpp;

    public Trimmer(Resource theFile, Cpp cpp) {
        this.cpp = cpp;
        try {
            this.theFile = theFile;
            this.fileName = theFile.getPath();
            this._reader = theFile.getBufferedReader();
            this.lineNumber = 1;
        }
        catch (IOException e) {
            Assert.fail(e.getMessage());
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Resource getTheFile() {
        return this.theFile;
    }

    public String readLine() {
        if (this._emitLine) {
            this._emitLine = false;
            return "#line " + this.lineNumber;
        }
        return this.getNextLine();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer getContinuedLine() {
        if (this._reader == null) {
            return null;
        }
        StringBuffer continuedLine = new StringBuffer(128);
        try {
            String theLine = this._reader.readLine();
            if (theLine == null) {
                this._reader.close();
                this._reader = null;
                return null;
            }
            if (theLine.length() == 0) {
                return continuedLine;
            }
            continuedLine.append(theLine);
            while (continuedLine.charAt(continuedLine.length() - 1) == '\\') {
                this._emitLine = true;
                try {
                    String nextnextLine = this._reader.readLine();
                    if (nextnextLine == null) {
                        return continuedLine;
                    }
                    continuedLine.deleteCharAt(continuedLine.length() - 1);
                    continuedLine.append(nextnextLine);
                    ++this.lineNumber;
                }
                catch (IOException f) {
                    return continuedLine;
                }
            }
        }
        catch (IOException e) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._reader = null;
            return null;
        }
    }

    private boolean isSlashSlashInSqlString(String line, int curPos) {
        int slashslash = curPos - 1;
        int beginQuote = line.indexOf(39);
        int endQuote = line.lastIndexOf(39);
        return beginQuote != -1 && endQuote != -1 && beginQuote < slashslash && endQuote > slashslash;
    }

    private String getNextLine() {
        StringBuffer nextLine = this.getContinuedLine();
        if (nextLine == null) {
            return null;
        }
        StringBuffer theLine = new StringBuffer(128);
        int prevprev_ch = 10;
        int prev_ch = 10;
        int ch = 10;
        int next_ch = 10;
        int curPos = -1;
        int lineLength = nextLine.length();
        while (++curPos < lineLength) {
            prevprev_ch = prev_ch;
            prev_ch = ch;
            ch = nextLine.charAt(curPos);
            if (curPos + 1 < lineLength) {
                next_ch = nextLine.charAt(curPos + 1);
            }
            if (this._inComment) {
                if (prev_ch != 42 || ch != 47) continue;
                this._inComment = false;
                prev_ch = 10;
                ch = 10;
                continue;
            }
            if (prev_ch != 92 && ch == 34) {
                this._inString = !this._inString;
                theLine.append('\"');
                continue;
            }
            if (!this.cpp.isPreserveComments() && !this.cpp.isPreserveCPlusPlusComments()) {
                if (ch == 47 && prev_ch == 47 && !this._inString && !this.isSlashSlashInSqlString(nextLine.toString(), curPos)) {
                    curPos = lineLength;
                    theLine.deleteCharAt(theLine.length() - 1);
                    continue;
                }
                if (!(prev_ch != 47 || ch != 42 || this._inString || prevprev_ch == 39 && next_ch == 39)) {
                    this._inComment = true;
                    theLine.deleteCharAt(theLine.length() - 1);
                    continue;
                }
            }
            theLine.append((char)ch);
        }
        ++this.lineNumber;
        String theLineStr = theLine.toString();
        if (theLineStr.contains("--") && theLineStr.contains("\\u")) {
            int dashdash = theLineStr.indexOf("--");
            int backu = theLineStr.indexOf("\\u");
            if (backu > dashdash) {
                theLineStr = theLineStr.replace("\\u", "\\ u");
            }
        }
        return theLineStr;
    }
}

