/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.cpp.ifdef;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.util.asserts.Assert;
import java.util.Hashtable;

public class DefinedExpr
extends UnaryOpExpr {
    protected Hashtable macros = null;

    public DefinedExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Defined);
    }

    public void setMacros(Hashtable macros) {
        this.macros = macros;
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 30: {
                if (this.macros != null && this.macros.contains(eval.toString())) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
            case 10: {
                IntegerLiteralExpr integerExpr = (IntegerLiteralExpr)eval;
                IntegerToken integerToken = (IntegerToken)integerExpr.getValue();
                if (integerToken.intValue() != 0) {
                    return BooleanLiteralExpr.True;
                }
                return BooleanLiteralExpr.False;
            }
        }
        Assert.fail("Expression=" + eval.toString() + " does not evaluate to boolean expression!");
        return eval;
    }

    public String toString() {
        return "defined( " + this.operand.toString() + ")";
    }
}

