/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.driver;

import com.objectriver.compiler.driver.exceptions.SyntaxException;
import com.objectriver.runtime.util.ArrayIterator;

public class ArgumentParser {
    public static final String usage = "Usage: CloudC model [ -HhostUrl -Iinclude -Ddefine -WworkDir -OoutDir -SsrcDir -TtmplDir -pPackage -Pproject.xml -wait minutes .... ]";
    public final Config[] options = new Config[]{new Config("NAME", true, false, 1, 1, null), new Config("U", false, false, 2, 2, null), new Config("H", true, true, 0, 1, null), new Config("O", true, true, 0, 1, null), new Config("S", true, true, 0, 1, null), new Config("W", true, true, 0, 1, null), new Config("T", true, true, 0, 1, null), new Config("p", true, true, 0, 1, null), new Config("P", true, true, 0, 100, new String[]{"t"}), new Config("I", true, true, 0, 100, null), new Config("D", true, true, 0, 100, null), new Config("t", false, true, 1, 100, new String[]{"P"}), new Config("wait", false, true, 1, 1, null), new Config("debug", false, false, 0, 0, null), new Config("license", false, false, 0, 0, null), new Config("force", false, false, 0, 0, null), new Config("ignoreFields", false, true, 1, 1, null)};

    public ArgumentParser(String[] args) throws SyntaxException {
        ArrayIterator arguments = new ArrayIterator(args);
        if (!arguments.hasNext()) {
            System.out.println(usage);
            System.exit(0);
        }
        this.parseArgs(arguments);
        String[] newlist = null;
        for (int ii = 0; ii < this.options.length; ++ii) {
            if (this.options[ii].list == null || this.options[ii].list.length == this.options[ii].numberArgs) continue;
            newlist = new String[this.options[ii].numberArgs];
            System.arraycopy(this.options[ii].list, 0, newlist, 0, this.options[ii].numberArgs);
            this.options[ii].list = newlist;
        }
    }

    public boolean isSet(String key) {
        return this.getConfig((String)key).found;
    }

    public String getValue(String key) {
        return this.getConfig((String)key).list[0];
    }

    public String[] getValues(String key) {
        return this.getConfig(key).getList();
    }

    public Config getConfig(String key) {
        for (int ii = 0; ii < this.options.length; ++ii) {
            if (key.length() < this.options[ii].option.length() || !(this.options[ii].caseSensitive ? this.options[ii].option.equals(key.substring(0, this.options[ii].option.length())) : this.options[ii].option.equalsIgnoreCase(key.substring(0, this.options[ii].option.length())))) continue;
            return this.options[ii];
        }
        return null;
    }

    private void parseArgs(ArrayIterator arguments) throws SyntaxException {
        boolean again = false;
        block0: do {
            Config config;
            String option;
            if ((option = (String)arguments.current()).charAt(0) == '-') {
                config = this.getConfig(option.substring(1, option.length()));
                if (config == null) {
                    throw new SyntaxException("CloudC Error: Invalid option \"" + option + "\"", usage);
                }
                if (config.found && config.numberArgs >= config.maxArgs) {
                    throw new SyntaxException("CloudC Error: Option " + option + " defined too many times? ", usage);
                }
                config.setFound(true);
                this.checkExclusions(config);
                if (config.concat) {
                    config.setList(option.substring(1 + config.option.length()));
                } else {
                    while (config.numberArgs < config.maxArgs && arguments.hasNext()) {
                        String additional = (String)arguments.next();
                        if (additional.charAt(0) == '-') continue block0;
                        config.setList(additional);
                    }
                }
            } else {
                config = this.getConfig("NAME");
                if (config.found) {
                    throw new SyntaxException("CloudC Error: Multiple input files specified. \"" + option + "\" and \"" + config.list[0] + "\"", usage);
                }
                config.setFound(true);
                config.setList(option);
            }
            if (arguments.hasNext()) {
                arguments.next();
                again = true;
                continue;
            }
            again = false;
        } while (again);
        if (!this.isSet("NAME")) {
            throw new SyntaxException("CloudC Error: Model file not specified! \"", usage);
        }
    }

    private void checkExclusions(Config config) throws SyntaxException {
        String[] exclusions = config.getExclusions();
        if (exclusions == null) {
            return;
        }
        for (int ii = 0; ii < exclusions.length; ++ii) {
            if (!this.isSet(exclusions[ii])) continue;
            throw new SyntaxException("CloudC Error: The following options are mutually exclusive \"" + config.option + "\" and \"" + exclusions[ii] + "\"", usage);
        }
    }

    public class Config {
        public String option;
        public boolean concat;
        public boolean caseSensitive;
        public int minArgs;
        public int maxArgs;
        public int numberArgs;
        public boolean found;
        public String[] list;
        public String[] exclusions;

        public String getOption() {
            return this.option;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public boolean isConcat() {
            return this.concat;
        }

        public void setConcat(boolean concat) {
            this.concat = concat;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public int getMinArgs() {
            return this.minArgs;
        }

        public void setMinArgs(int minArgs) {
            this.minArgs = minArgs;
        }

        public int getMaxArgs() {
            return this.maxArgs;
        }

        public void setMaxArgs(int maxArgs) {
            this.maxArgs = maxArgs;
        }

        public int getNumberArgs() {
            return this.numberArgs;
        }

        public void setNumberArgs(int numberArgs) {
            this.numberArgs = numberArgs;
        }

        public boolean isFound() {
            return this.found;
        }

        public void setFound(boolean found) {
            this.found = found;
        }

        public String[] getList() {
            return this.list;
        }

        public void setList(String entry) {
            if (this.list == null) {
                this.list = new String[this.maxArgs];
                this.list[0] = entry;
                ++this.numberArgs;
                return;
            }
            this.list[this.numberArgs++] = entry;
        }

        public String[] getExclusions() {
            return this.exclusions;
        }

        public void setExclusions(String[] exclusions) {
            this.exclusions = exclusions;
        }

        public Config(String option, boolean concat, boolean caseSensitive, int minArgs, int maxArgs, String[] exclusions) {
            this.option = option;
            this.concat = concat;
            this.caseSensitive = caseSensitive;
            this.minArgs = minArgs;
            this.maxArgs = maxArgs;
            this.exclusions = exclusions;
            this.numberArgs = 0;
            this.found = false;
            this.list = null;
        }
    }
}

