/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.driver;

import com.objectriver.compiler.CompilerClassLoader;
import com.objectriver.compiler.CompilerTemplateResourceLoader;
import com.objectriver.compiler.driver.ArgumentParser;
import com.objectriver.compiler.driver.Package;
import com.objectriver.compiler.driver.exceptions.ArgumentParserException;
import com.objectriver.compiler.driver.exceptions.SyntaxException;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.NullLiteralExpr;
import com.objectriver.compiler.util.FileName;
import com.objectriver.runtime.util.ArrayHelper;
import com.objectriver.runtime.util.ArrayIterator;
import com.objectriver.runtime.util.FileHelper;
import com.objectriver.runtime.util.Pair;
import com.objectriver.runtime.util.resource.FileResource;
import com.objectriver.runtime.util.resource.Resource;
import com.objectriver.runtime.util.resource.ResourceFactory;
import com.objectriver.runtime.util.resource.ResourceType;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DriverArguments {
    public String driverName = "drivercc";
    protected ArgumentParser parsedArgs = null;
    public boolean cloudCompilerClient = false;

    public static String[] checkDefines(String[] defines) {
        if (defines == null || defines.length == 0) {
            defines = new String[]{"DbVendor=oracle"};
        } else {
            ArrayIterator iter = new ArrayIterator(defines);
            boolean hasDbVendor = false;
            while (iter.hasNext()) {
                String define = (String)iter.next();
                if (!define.startsWith("DbVendor")) continue;
                hasDbVendor = true;
                break;
            }
            if (!hasDbVendor) {
                defines = (String[])ArrayHelper.resize(defines, defines.length + 1);
                defines[defines.length - 1] = "DbVendor=oracle";
            }
        }
        return defines;
    }

    public void setParsedArgs(ArgumentParser parsedArgs) {
        this.parsedArgs = parsedArgs;
    }

    public String[] argumentParseDefines(ArgumentParser parsedArgs) {
        String[] defines = parsedArgs.isSet("D") ? parsedArgs.getValues("D") : new String[]{};
        return defines;
    }

    public boolean argumentParseDebug(ArgumentParser parsedArgs) {
        return parsedArgs.isSet("debug");
    }

    public boolean argumentParseForce(ArgumentParser parsedArgs) {
        return parsedArgs.isSet("force");
    }

    public boolean argumentParseLicense(ArgumentParser parsedArgs) {
        return parsedArgs.isSet("license");
    }

    public FileName argumentParseProjectFile(ArgumentParser parsedArgs) throws ArgumentParserException {
        FileName filename = new FileName(parsedArgs.getValue("NAME"));
        if (!filename.exists()) {
            throw new ArgumentParserException(this.driverName + " Error: Project not found? :" + parsedArgs.getValue("NAME"));
        }
        return filename;
    }

    public File argumentParseOutDir(ArgumentParser parsedArgs) throws ArgumentParserException {
        File outDir;
        File file = outDir = parsedArgs.isSet("O") ? new File(parsedArgs.getValue("O")) : null;
        if (!(outDir == null || outDir.exists() && outDir.isDirectory())) {
            throw new ArgumentParserException(this.driverName + " Error: Output directory not found? :" + outDir.getAbsolutePath());
        }
        return outDir;
    }

    public File argumentParseSrcDir(ArgumentParser parsedArgs) throws ArgumentParserException {
        File srcDir;
        File file = srcDir = parsedArgs.isSet("S") ? new File(parsedArgs.getValue("S")) : null;
        if (!(srcDir == null || srcDir.exists() && srcDir.isDirectory())) {
            throw new ArgumentParserException(this.driverName + " Error: Source directory not found? :" + srcDir.getAbsolutePath());
        }
        return srcDir;
    }

    public File argumentParseWorkDir(ArgumentParser parsedArgs) throws ArgumentParserException {
        File workDir;
        File file = workDir = parsedArgs.isSet("W") ? new File(parsedArgs.getValue("W")) : null;
        if (!(workDir == null || workDir.exists() && workDir.isDirectory())) {
            throw new ArgumentParserException(this.driverName + " Error: workDir directory not found? :" + workDir.getAbsolutePath());
        }
        return workDir;
    }

    public Integer argumentParseTimeout(ArgumentParser parsedArgs) throws ArgumentParserException {
        String timeoutString = parsedArgs.isSet("wait") ? parsedArgs.getValue("wait") : "4";
        Integer timeout = Integer.valueOf(timeoutString) * 60;
        return timeout;
    }

    public String argumentParseHost(ArgumentParser parsedArgs) throws ArgumentParserException {
        String host = parsedArgs.isSet("H") ? parsedArgs.getValue("H") : null;
        return host;
    }

    public Pair<String, String> argumentParseUser(ArgumentParser parsedArgs) {
        Pair<String, String> pair = null;
        if (parsedArgs.isSet("U")) {
            String[] userpw = parsedArgs.getValues("U");
            pair = Pair.of(userpw[0], userpw[1]);
        }
        return pair;
    }

    public void setCloudCompilerClient(boolean ccc) {
        this.cloudCompilerClient = ccc;
    }

    public Resource argumentParseTmplDir(ArgumentParser parsedArgs) throws ArgumentParserException {
        File dir;
        File file = dir = parsedArgs.isSet("T") ? new File(parsedArgs.getValue("T")) : null;
        if (!(dir == null || dir.exists() && dir.isDirectory())) {
            throw new ArgumentParserException(this.driverName + " Error: Tmpl directory not found? :" + dir.getAbsolutePath());
        }
        Resource resource = null;
        if (!this.cloudCompilerClient) {
            if (dir == null) {
                String model = parsedArgs.getValue("NAME");
                String ext = FileHelper.getExtension(new File(model));
                resource = CompilerTemplateResourceLoader.templateResourceLoader((String)ext.toLowerCase());
            } else {
                resource = new FileResource(dir);
            }
        } else if (dir != null) {
            resource = new FileResource(dir);
        }
        return resource;
    }

    public Resource getTemplateDir() throws ArgumentParserException {
        try {
            Resource resource = CompilerClassLoader.loadResource("templates");
            if (resource == null) {
                throw new ArgumentParserException("templates directory not found?");
            }
            return resource;
        }
        catch (Exception e) {
            throw new ArgumentParserException("Internal Error: CompilerLoaderClass failed.");
        }
    }

    public Expr argumentParsePackage(ArgumentParser parsedArgs, File srcDir, File outDir) {
        Expr package_ = NullLiteralExpr.Null;
        package_ = parsedArgs.isSet("p") ? Package.valueOf((String)parsedArgs.getValue("p")) : this.getPackage(srcDir, outDir);
        return package_;
    }

    public Expr getPackage(File srcDir, File outDir) {
        Expr package_ = NullLiteralExpr.Null;
        Package thePackage = new Package(srcDir, outDir);
        try {
            package_ = thePackage.getPackage();
        }
        catch (SyntaxException e) {
            return package_;
        }
        return package_;
    }

    public File getWorkDir() {
        Path currentRelativePath = Paths.get("", new String[0]);
        String workDir = currentRelativePath.toAbsolutePath().toString();
        return new File(workDir);
    }

    public FileResource argumentParseIgnoresFields(ArgumentParser parsedArgs) throws ArgumentParserException {
        if (parsedArgs.isSet("ignoreFields")) {
            String ignorefilename = parsedArgs.getValue("ignoreFields");
            if (ignorefilename == null) {
                throw new ArgumentParserException(this.driverName + " Error: -ignoreFields without file?");
            }
            FileResource ignorefile = new FileResource(new File(ignorefilename));
            if (ignorefile == null || !ignorefile.isDirectory()) {
                throw new ArgumentParserException("CloudC Error: Ignore Fields directory not found? " + ignorefilename);
            }
            return ignorefile;
        }
        return null;
    }

    public Resource[] argumentParseTemplates(Resource tmplDir, ArgumentParser parsedArgs) throws ArgumentParserException {
        Resource[] templates = null;
        String[] members = null;
        Resource member = null;
        if (parsedArgs.isSet("t")) {
            members = parsedArgs.getValues("t");
            if (members == null) {
                throw new ArgumentParserException(this.driverName + " Error: -t without template?");
            }
            templates = new Resource[members.length];
            for (int ii = 0; ii < members.length; ++ii) {
                member = tmplDir.getMember(members[ii]);
                if (member == null || !member.isFile()) {
                    if (member == null && !tmplDir.equals(this.getTemplateDir())) {
                        member = this.getTemplateDir().getMember(members[ii]);
                    }
                    if (member == null || !member.isFile()) {
                        throw new ArgumentParserException("CloudC Error: Template file not found? " + tmplDir.getPath() + "/" + members[ii]);
                    }
                }
                templates[ii] = member;
            }
        }
        return templates;
    }

    public Resource[] argumentParseIncludes(ArgumentParser parsedArgs) throws ArgumentParserException {
        Resource[] includes = null;
        if (parsedArgs.isSet("I")) {
            String[] directories = parsedArgs.getValues("I");
            includes = new Resource[directories.length];
            for (int ii = 0; ii < directories.length; ++ii) {
                try {
                    includes[ii] = ResourceFactory.valueOf(directories[ii], ResourceType.File);
                    if (includes[ii].exists() && includes[ii].isDirectory()) continue;
                    throw new ArgumentParserException(this.driverName + " Warning: Include directory not found? " + directories[ii]);
                }
                catch (MalformedURLException e) {
                    throw new ArgumentParserException(this.driverName + " Warning: Include directory malformed url: " + directories[ii]);
                }
                catch (FileNotFoundException e) {
                    throw new ArgumentParserException(this.driverName + " Warning: Include directory not found? " + directories[ii]);
                }
            }
        }
        return includes;
    }

    public String[] argumentParseProjectXml(ArgumentParser parsedArgs) {
        if (parsedArgs == null) {
            return null;
        }
        String[] projectXml = parsedArgs.isSet("P") ? parsedArgs.getValues("P") : null;
        return projectXml;
    }
}

