/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.FloatingLiteralExpr;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class AbsExpr
extends UnaryOpExpr {
    public AbsExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Abs);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        if (!eval.isIntegerExpression() && !(eval instanceof FloatingLiteralExpr)) {
            throw new EvaluateExprException("Operand of Absolute Value must be Integer | Floating Expression", this.getLexicalInfo());
        }
        if (eval.isIntegerExpression()) {
            return ((IntegerLiteralExpr)eval).abs();
        }
        return ((FloatingLiteralExpr)eval).abs();
    }

    public String toString() {
        return "abs( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfAbsExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfAbsExpr(this);
        return decend;
    }
}

