/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.CharStringLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.NullLiteralExpr;
import com.objectriver.compiler.exprs.OpExpr;
import com.objectriver.compiler.exprs.OpType;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.tokens.CharStringToken;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class AddExpr
extends OpExpr {
    public AddExpr(Expr left, Expr right) {
        super(left, OpType.valueOf("+"), right);
        this.setType(ExprType.Add);
    }

    public String toString() {
        return this.left.toString() + "+" + this.right.toString();
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr leftEval = this.left.evaluate(thing);
        ExprType lefttype = leftEval.getType();
        if (lefttype != ExprType.StringLiteral && lefttype != ExprType.CharStringLiteral && lefttype != ExprType.CharacterLiteral && lefttype != ExprType.IdentifierLiteral) {
            return super.evaluate(thing);
        }
        Expr rightEval = this.right.evaluate(thing);
        String leftString = leftEval.toString();
        String rightString = rightEval.toString();
        int leftlength = leftString.length();
        switch (lefttype.intValue()) {
            case 24: {
                String lexString;
                if (rightEval.getType() == ExprType.StringLiteral) {
                    int rightlength = rightString.length();
                    lexString = leftString.substring(0, leftlength - 1) + rightString.substring(1);
                } else if (rightEval.getType() == ExprType.CharStringLiteral || rightEval.getType() == ExprType.CharacterLiteral) {
                    int rightlength = rightString.length();
                    lexString = leftString.substring(0, leftlength - 1) + rightString.substring(1, rightlength - 1) + '\"';
                } else {
                    lexString = leftString.substring(0, leftlength - 1) + rightString + "\"";
                }
                return new StringLiteralExpr(new StringToken(lexString, leftEval.getLexicalInfo()));
            }
            case 5: 
            case 44: {
                String lexString;
                if (rightEval.getType() == ExprType.StringLiteral) {
                    int rightlength = rightString.length();
                    lexString = leftString.substring(0, leftlength - 1) + rightString.substring(1, leftlength - 1) + "'";
                } else if (rightEval.getType() == ExprType.CharStringLiteral) {
                    int rightlength = rightString.length();
                    lexString = leftString.substring(0, leftlength - 1) + rightString.substring(1);
                } else {
                    lexString = leftString.substring(0, leftlength - 1) + rightString + "'";
                }
                return new CharStringLiteralExpr(new CharStringToken(lexString, leftEval.getLexicalInfo()));
            }
            case 30: {
                String lexString;
                if (rightEval.getType() == ExprType.StringLiteral || rightEval.getType() == ExprType.CharStringLiteral || rightEval.getType() == ExprType.CharacterLiteral) {
                    int rightlength = rightString.length();
                    lexString = leftString + rightString.substring(1, rightlength - 1);
                } else {
                    lexString = leftString + rightString;
                }
                return new IdentifierExpr(new IdentifierToken(lexString, leftEval.getLexicalInfo()));
            }
        }
        return NullLiteralExpr.Null;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfAddExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfAddExpr(this);
        return decend;
    }
}

