/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.BooleanToken;
import com.objectriver.runtime.primitives.StringConst;
import com.objectriver.runtime.things.Visitor;

public class BooleanLiteralExpr
extends LiteralExpr {
    private static final LexicalInfo lexinfo = new LexicalInfo("BooleanLiteralExpr.java", 0, false);
    public static final BooleanLiteralExpr True = new BooleanLiteralExpr(new BooleanToken(true, StringConst.True, lexinfo));
    public static final BooleanLiteralExpr False = new BooleanLiteralExpr(new BooleanToken(false, StringConst.False, lexinfo));

    public BooleanLiteralExpr(BooleanToken value) {
        super(value);
        this.setType(ExprType.BooleanLiteral);
    }

    public boolean booleanValue() {
        BooleanToken token = (BooleanToken)this.getValue();
        return token.booleanValue();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfBooleanLiteralExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfBooleanLiteralExpr(this);
        return decend;
    }

    public BooleanLiteralExpr and(Expr right) {
        if (!(right instanceof BooleanLiteralExpr)) {
            throw new EvaluateExprException("Right side needs to be BooleanLiteralExpr", this.getLexicalInfo());
        }
        BooleanLiteralExpr rightBool = (BooleanLiteralExpr)right;
        boolean newvalue = ((BooleanToken)this.value).booleanValue() & ((BooleanToken)rightBool.value).booleanValue();
        if (newvalue) {
            return True;
        }
        return False;
    }

    public BooleanLiteralExpr or(Expr right) {
        if (!(right instanceof BooleanLiteralExpr)) {
            throw new EvaluateExprException("Right side needs to be BooleanLiteralExpr", this.getLexicalInfo());
        }
        BooleanLiteralExpr rightBool = (BooleanLiteralExpr)right;
        boolean newvalue = ((BooleanToken)this.value).booleanValue() | ((BooleanToken)rightBool.value).booleanValue();
        if (newvalue) {
            return True;
        }
        return False;
    }

    public BooleanLiteralExpr not() {
        if (this.equals(True)) {
            return False;
        }
        return True;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanLiteralExpr)) {
            return false;
        }
        BooleanLiteralExpr booleanLiteralExpr = (BooleanLiteralExpr)o;
        return !(this.value != null ? !this.value.equals(booleanLiteralExpr.value) : booleanLiteralExpr.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

