/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.AddExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class ConcatExpr
extends AddExpr {
    public ConcatExpr(Expr left, Expr right) {
        super(left, right);
        this.setType(ExprType.Concat);
    }

    @Override
    public String toString() {
        return "concat(" + this.left.toString() + "," + this.right.toString() + ")";
    }

    @Override
    public ExprType getType() {
        return ExprType.Concat;
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr leftEval = this.left.evaluate(thing);
        switch (leftEval.getType().intValue()) {
            case 5: 
            case 24: 
            case 30: 
            case 44: {
                return super.evaluate(thing);
            }
        }
        Expr rightEval = this.right.evaluate(thing);
        String result = leftEval.toString() + rightEval.toString();
        return new StringLiteralExpr(new StringToken(result, leftEval.getLexicalInfo()));
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfConcatExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfConcatExpr(this);
        return decend;
    }

    public static void main(String[] args) {
        LexicalInfo lexInfo = new LexicalInfo("fred", 777, false);
        StringLiteralExpr strLitExpr = new StringLiteralExpr(new StringToken("\"RestList<\"", lexInfo));
        IdentifierExpr idenExpr = new IdentifierExpr(new IdentifierToken("String", lexInfo));
        StringLiteralExpr strLitExpr2 = new StringLiteralExpr(new StringToken("\">\"", lexInfo));
        ConcatExpr concat1 = new ConcatExpr(strLitExpr, idenExpr);
        ConcatExpr concat2 = new ConcatExpr(concat1, strLitExpr2);
        Expr result = concat2.evaluate(null);
        System.out.println(result.toString());
    }
}

