/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class ConditionalExpr
extends Expr {
    protected Expr condition;
    protected Expr trueExpr;
    protected Expr falseExpr;

    public ConditionalExpr(Expr condition, Expr trueExpr, Expr falseExpr) {
        super(trueExpr.getLexicalInfo());
        this.setType(ExprType.Conditional);
        this.condition = condition;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    public Expr getCondition() {
        return this.condition;
    }

    public Expr getTrueExpr() {
        return this.trueExpr;
    }

    public Expr getFalseExpr() {
        return this.falseExpr;
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr evalCondition = this.condition.evaluate(thing);
        if (!evalCondition.isBooleanExpression()) {
            throw new EvaluateExprException("Condition of tiernary operation must Boolean Expression", this.getLexicalInfo());
        }
        if (evalCondition.equals(BooleanLiteralExpr.True)) {
            return this.trueExpr.evaluate(thing);
        }
        return this.falseExpr.evaluate(thing);
    }

    public String toString() {
        return "(" + this.condition.toString() + ") ? " + this.trueExpr.toString() + ":" + this.falseExpr.toString();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfConditionalExpr(this);
        if (decend &= v.beginVisitOfExpr(this)) {
            this.condition.visit(visitor);
            this.trueExpr.visit(visitor);
            this.falseExpr.visit(visitor);
        }
        v.endVisitOfExpr(this);
        v.endVisitOfConditionalExpr(this);
        return decend;
    }
}

