/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class ConsoleDebugExpr
extends UnaryOpExpr {
    public Expr tabs = new IntegerLiteralExpr(new IntegerToken(0L, "0", new LexicalInfo("ConsoleExpr", 19, false)));

    public ConsoleDebugExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.ConsoleDebug);
    }

    public ConsoleDebugExpr(Expr operand, Expr tabsExpr) {
        super(operand);
        this.tabs = tabsExpr;
        this.setType(ExprType.ConsoleDebug);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        Expr tabs__ = this.tabs.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: {
                StringLiteralExpr value = new StringLiteralExpr(new StringToken(eval.toString(), eval.getLexicalInfo()));
                this.systemConsole(value.toString(), tabs__);
                return value;
            }
            case 30: {
                IdentifierExpr value = new IdentifierExpr(new IdentifierToken(eval.toString(), eval.getLexicalInfo()));
                this.systemConsole(value.toString(), tabs__);
                return value;
            }
        }
        throw new EvaluateExprException("Console needs to operate on String or Identifier  Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "console( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfConsoleDebugExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfConsoleDebugExpr(this);
        return decend;
    }

    private void systemConsole(String line, Expr tabs__) {
        if (!(tabs__ instanceof IntegerLiteralExpr)) {
            throw new EvaluateExprException("Console tabs needs to be Integer Literal Expression", this.getLexicalInfo());
        }
        int tabsInt = ((IntegerToken)((IntegerLiteralExpr)tabs__).value).intValue();
        for (int ii = 0; ii < tabsInt; ++ii) {
            System.out.print('\t');
        }
        System.out.println(line);
    }
}

