/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.CharacterLiteralExpr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.FloatingLiteralExpr;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.NullLiteralExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.lexinfo.AbstractSemanticValue;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.BooleanToken;
import com.objectriver.compiler.tokens.CharacterToken;
import com.objectriver.compiler.tokens.FloatingToken;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.compiler.tokens.NullToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.compiler.tokens.TkToken;
import com.objectriver.runtime.things.Visit;
import com.objectriver.runtime.things.Visitor;

public abstract class Expr
extends AbstractSemanticValue
implements Visit {
    protected ExprType type = null;

    public Expr(LexicalInfo lexicalInfo) {
        super(lexicalInfo);
    }

    public ExprType getType() {
        return this.type;
    }

    public void setType(ExprType type) {
        this.type = type;
    }

    public abstract Expr evaluate(CtThing var1);

    public boolean isLiteral() {
        switch (this.type.intValue()) {
            case 5: 
            case 9: 
            case 10: 
            case 15: 
            case 24: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public boolean isBooleanExpression() {
        switch (this.type.intValue()) {
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 14: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public boolean isIntegerExpression() {
        switch (this.type.intValue()) {
            case 1: 
            case 2: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public static Expr valueOf(TkToken token) {
        switch (token.getType().intValue()) {
            case 1: {
                return new BooleanLiteralExpr((BooleanToken)token);
            }
            case 2: {
                return new CharacterLiteralExpr((CharacterToken)token);
            }
            case 3: {
                return new FloatingLiteralExpr((FloatingToken)token);
            }
            case 4: {
                return new IdentifierExpr((IdentifierToken)token);
            }
            case 5: {
                return new IntegerLiteralExpr((IntegerToken)token);
            }
            case 6: {
                return new NullLiteralExpr((NullToken)token);
            }
            case 7: {
                return new StringLiteralExpr((StringToken)token);
            }
        }
        return null;
    }

    protected abstract boolean acceptVisit(Visitor var1, boolean var2);

    @Override
    public final void visit(Visitor visitor) {
        this.acceptVisit(visitor, true);
    }
}

