/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.tokens.FloatingToken;
import com.objectriver.runtime.things.Visitor;

public class FloatingLiteralExpr
extends LiteralExpr {
    public FloatingLiteralExpr(FloatingToken value) {
        super(value);
        this.setType(ExprType.FloatingLiteral);
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfFloatingLiteralExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfFloatingLiteralExpr(this);
        return decend;
    }

    public Expr negate() {
        double newvalue = -((FloatingToken)this.value).doubleValue();
        return new FloatingLiteralExpr(new FloatingToken(newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr abs() {
        double newvalue = Math.abs(((FloatingToken)this.value).doubleValue());
        return new FloatingLiteralExpr(new FloatingToken(newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatingLiteralExpr)) {
            return false;
        }
        FloatingLiteralExpr floatingLiteralExpr = (FloatingLiteralExpr)o;
        return !(this.value != null ? !this.value.equals(floatingLiteralExpr.value) : floatingLiteralExpr.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

