/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;

public class HashExpr
extends UnaryOpExpr {
    public HashExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Hash);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        int hashCode = Math.abs(eval.hashCode());
        return new IntegerLiteralExpr(new IntegerToken(hashCode, Integer.toString(hashCode), eval.getLexicalInfo()));
    }

    public String toString() {
        return "hash( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfHashExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfHashExpr(this);
        return decend;
    }
}

