/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class IdentifierFunctionExpr
extends UnaryOpExpr {
    public IdentifierFunctionExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.IdentifierFunction);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        String evalString = StringUtility.removeQuotes(eval.toString());
        return new IdentifierExpr(new IdentifierToken(evalString, this.getLexicalInfo()));
    }

    public String toString() {
        return "identifier( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfIdentifierFunctionExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfIdentifierFunctionExpr(this);
        return decend;
    }
}

