/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;
import com.objectriver.runtime.util.StringUtility;

public class IndexOfExpr
extends UnaryOpExpr {
    protected final String hasthis;

    public IndexOfExpr(Expr operand, StringLiteralExpr hasthis) {
        super(operand);
        this.hasthis = StringUtility.removeQuotes(hasthis.toString());
        this.setType(ExprType.IndexOf);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: 
            case 30: {
                if (!eval.toString().contains(this.hasthis)) {
                    return IntegerLiteralExpr.MinusOne;
                }
                int index = eval.toString().indexOf(this.hasthis);
                return IntegerLiteralExpr.valueOf(new IntegerToken(index, String.valueOf(index), thing.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("Length must operate on Literal String or Identifier Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "contains( " + this.operand.toString() + ",\"" + this.hasthis + "\")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfIndexOfExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfIndexOfExpr(this);
        return decend;
    }
}

