/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.LiteralExpr;
import com.objectriver.compiler.exprs.OpType;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;

public class IntegerLiteralExpr
extends LiteralExpr {
    private static LexicalInfo lexinfo = new LexicalInfo("IntegerLiteralExpr.java", 14, false);
    public static IntegerLiteralExpr Zero = (IntegerLiteralExpr)IntegerLiteralExpr.valueOf(new IntegerToken(0L, "0", lexinfo));
    public static IntegerLiteralExpr MinusOne = (IntegerLiteralExpr)IntegerLiteralExpr.valueOf(new IntegerToken(-1L, "-1", lexinfo));
    public static IntegerLiteralExpr One = (IntegerLiteralExpr)IntegerLiteralExpr.valueOf(new IntegerToken(1L, "1", lexinfo));

    public IntegerLiteralExpr(IntegerToken value) {
        super(value);
        this.setType(ExprType.IntegerLiteral);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfIntegerLiteralExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfIntegerLiteralExpr(this);
        return decend;
    }

    public Expr greaterThan(Object o) {
        if (this == o) {
            return BooleanLiteralExpr.False;
        }
        if (!(o instanceof IntegerLiteralExpr)) {
            throw new EvaluateExprException("Right side needs to be IntegerLiteralExpr", this.getLexicalInfo());
        }
        IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)o;
        if (((IntegerToken)this.value).intValue() > ((IntegerToken)integerLiteralExpr.value).intValue()) {
            return BooleanLiteralExpr.True;
        }
        return BooleanLiteralExpr.False;
    }

    public Expr lessThan(Object o) {
        if (this == o) {
            return BooleanLiteralExpr.False;
        }
        if (!(o instanceof IntegerLiteralExpr)) {
            throw new EvaluateExprException("Right side needs to be IntegerLiteralExpr", this.getLexicalInfo());
        }
        IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)o;
        if (((IntegerToken)this.value).intValue() < ((IntegerToken)integerLiteralExpr.value).intValue()) {
            return BooleanLiteralExpr.True;
        }
        return BooleanLiteralExpr.False;
    }

    public Expr greaterThanOrEqual(Object o) {
        if (this.equals(o) | this.greaterThan(o) == BooleanLiteralExpr.True) {
            return BooleanLiteralExpr.True;
        }
        return BooleanLiteralExpr.False;
    }

    public Expr lessThanOrEqual(Object o) {
        if (this.equals(o) | this.lessThan(o) == BooleanLiteralExpr.True) {
            return BooleanLiteralExpr.True;
        }
        return BooleanLiteralExpr.False;
    }

    public IntegerLiteralExpr math(OpType op2, Expr o) {
        if (this == o) {
            return this;
        }
        if (!(o instanceof IntegerLiteralExpr)) {
            throw new EvaluateExprException("Right side needs to be IntegerLiteral", this.getLexicalInfo());
        }
        IntegerLiteralExpr thatExpr = (IntegerLiteralExpr)o;
        long newvalue = 0L;
        switch (op2.intValue()) {
            case 0: {
                newvalue = ((IntegerToken)this.value).longValue() + ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 1: {
                newvalue = ((IntegerToken)this.value).longValue() - ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 2: {
                newvalue = ((IntegerToken)this.value).longValue() * ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 3: {
                newvalue = ((IntegerToken)this.value).longValue() / ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 7: {
                newvalue = ((IntegerToken)this.value).longValue() % ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 4: {
                newvalue = ((IntegerToken)this.value).longValue() << (int)((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 6: {
                newvalue = ((IntegerToken)this.value).longValue() >> (int)((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 5: {
                newvalue = ((IntegerToken)this.value).longValue() >>> (int)((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 9: {
                newvalue = ((IntegerToken)this.value).longValue() & ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 8: {
                newvalue = ((IntegerToken)this.value).longValue() | ((IntegerToken)thatExpr.value).longValue();
                break;
            }
            case 10: {
                newvalue = ((IntegerToken)this.value).longValue() ^ ((IntegerToken)thatExpr.value).longValue();
            }
        }
        return new IntegerLiteralExpr(new IntegerToken(newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr negate() {
        long newvalue = ((IntegerToken)this.value).longValue();
        if (newvalue == 0L) {
            return this;
        }
        newvalue = newvalue > 0L ? 0L - newvalue : Math.abs(newvalue);
        return new IntegerLiteralExpr(new IntegerToken(newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr abs() {
        long newvalue = ((IntegerToken)this.value).longValue();
        if (newvalue >= 0L) {
            return this;
        }
        newvalue = Math.abs(newvalue);
        return new IntegerLiteralExpr(new IntegerToken(newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr onesComplement() {
        long newvalue = ((IntegerToken)this.value).longValue();
        return new IntegerLiteralExpr(new IntegerToken(newvalue ^= 0xFFFFFFFFFFFFFFFFL, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr increment() {
        long newvalue = ((IntegerToken)this.value).longValue();
        return new IntegerLiteralExpr(new IntegerToken(++newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public Expr decrement() {
        long newvalue = ((IntegerToken)this.value).longValue();
        return new IntegerLiteralExpr(new IntegerToken(--newvalue, String.valueOf(newvalue), this.getLexicalInfo()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerLiteralExpr)) {
            return false;
        }
        IntegerLiteralExpr integerLiteralExpr = (IntegerLiteralExpr)o;
        return !(this.value != null ? !this.value.equals(integerLiteralExpr.value) : integerLiteralExpr.value != null);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

