/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IntegerToken;
import com.objectriver.runtime.things.Visitor;

public class LengthExpr
extends UnaryOpExpr {
    public LengthExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.Length);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 10: 
            case 24: 
            case 30: {
                int length = eval.toString().length();
                return new IntegerLiteralExpr(new IntegerToken(length, Integer.toString(length), eval.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("Length must operate on Literal String Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "length( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfLengthExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfLengthExpr(this);
        return decend;
    }
}

