/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class LowerCaseExpr
extends UnaryOpExpr {
    public LowerCaseExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.LowerCase);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: {
                return new StringLiteralExpr(new StringToken(eval.toString().toLowerCase(), eval.getLexicalInfo()));
            }
            case 30: {
                return new IdentifierExpr(new IdentifierToken(eval.toString().toLowerCase(), eval.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("LowerCase needs to operate on String or Identifier  Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "lowercase( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfLowerCaseExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfLowerCaseExpr(this);
        return decend;
    }
}

