/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IdentifierExpr;
import com.objectriver.compiler.exprs.StringLiteralExpr;
import com.objectriver.compiler.exprs.UnaryOpExpr;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.compiler.lexinfo.LexicalInfo;
import com.objectriver.compiler.tokens.IdentifierToken;
import com.objectriver.compiler.tokens.StringToken;
import com.objectriver.runtime.things.Visitor;

public class LowerExpr
extends UnaryOpExpr {
    public LowerExpr(Expr operand) {
        super(operand);
        this.setType(ExprType.LowerCase);
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr eval = this.operand.evaluate(thing);
        switch (eval.getType().intValue()) {
            case 24: {
                String lower = eval.toString().substring(0, 2).toLowerCase() + eval.toString().substring(2);
                return new StringLiteralExpr(new StringToken(lower, eval.getLexicalInfo()));
            }
            case 30: {
                String lower = eval.toString().substring(0, 1).toLowerCase() + eval.toString().substring(1);
                return new IdentifierExpr(new IdentifierToken(lower, eval.getLexicalInfo()));
            }
        }
        throw new EvaluateExprException("LowerCase needs to operate on String or Identifier  Expression", this.getLexicalInfo());
    }

    public String toString() {
        return "lower( " + this.operand.toString() + ")";
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfLowerExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfLowerExpr(this);
        return decend;
    }

    public static void main(String[] args) {
        StringLiteralExpr str = new StringLiteralExpr(new StringToken("\"Fred\"", new LexicalInfo("file", 3, false)));
        System.out.println("StrExpr before=" + str.toString());
        LowerExpr lower = new LowerExpr(str);
        System.out.println(lower.evaluate(null).toString());
        IdentifierExpr iden = new IdentifierExpr(new IdentifierToken("Fred", new LexicalInfo("file", 3, false)));
        System.out.println("IdentExpr before=" + iden.toString());
        lower = new LowerExpr(iden);
        System.out.println(lower.evaluate(null).toString());
    }
}

