/*
 * Decompiled with CFR 0.152.
 */
package com.objectriver.compiler.exprs;

import com.objectriver.compiler.ct.things.CtThing;
import com.objectriver.compiler.exprs.BooleanLiteralExpr;
import com.objectriver.compiler.exprs.Expr;
import com.objectriver.compiler.exprs.ExprType;
import com.objectriver.compiler.exprs.ExprVisitor;
import com.objectriver.compiler.exprs.IntegerLiteralExpr;
import com.objectriver.compiler.exprs.OpExpr;
import com.objectriver.compiler.exprs.OpType;
import com.objectriver.compiler.lang.EvaluateExprException;
import com.objectriver.runtime.things.Visitor;

public class MaxExpr
extends OpExpr {
    public MaxExpr(Expr left, Expr right) {
        super(left, OpType.valueOf("Max"), right);
        this.setType(ExprType.Max);
    }

    public String toString() {
        return "max(" + this.left.toString() + "," + this.right.toString() + ")";
    }

    @Override
    public Expr evaluate(CtThing thing) {
        Expr leftEval = this.left.evaluate(thing);
        Expr rightEval = this.right.evaluate(thing);
        if (leftEval.getType() != ExprType.IntegerLiteral || rightEval.getType() != ExprType.IntegerLiteral) {
            throw new EvaluateExprException("Max expressions must evaluate to Integer Literals", this.getLexicalInfo());
        }
        IntegerLiteralExpr leftInt = (IntegerLiteralExpr)leftEval;
        if (leftInt.greaterThan(rightEval) == BooleanLiteralExpr.True) {
            return leftEval;
        }
        return rightEval;
    }

    @Override
    public boolean acceptVisit(Visitor visitor, boolean decend) {
        ExprVisitor v = (ExprVisitor)visitor;
        decend &= v.beginVisitOfMaxExpr(this);
        decend &= super.acceptVisit(visitor, decend);
        v.endVisitOfMaxExpr(this);
        return decend;
    }
}

